/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.ai;

import cl.mc3d.ai.Console;
import cl.mc3d.ai.DescompresorZip;
import cl.mc3d.ai.GridDownloadResponse;
import cl.mc3d.ai.GridPublishFile;
import cl.mc3d.ai.GridSuscribeFile;
import cl.mc3d.gpt4all.LLModel;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;

public class TimerService
implements Runnable {
    private Thread thread = null;
    private boolean needConfig = false;
    private Properties p = new Properties();
    private String sConfig = "mc3d-ai.properties";
    private Ignite ignite = null;
    private IgniteCache igniteCache = null;
    private String modelFilePath;
    private String modelPromptTemplate;
    private String libraryPath;
    private String cacheName;
    private String cacheLocalIp;
    private String hostname;
    private String missionPromptFolder;
    private String cipherMessage;
    private String keyStorePass;
    private String locationStart = System.getProperty("user.dir");
    private Console console = null;
    private boolean activeUI = false;

    public TimerService() {
        this.config();
        this.start();
        Logger.getLogger(TimerService.class.getName()).log(Level.INFO, "Starting MeshGrid file integration ");
        if (this.p.getProperty("chatUI").equals("true")) {
            this.console = new Console(this);
            this.console.getIgniteControl().setEnabled(false);
            this.activeUI = true;
            this.console.getLogTextArea().append("Starting MeshGrid file integration\n");
        } else {
            Logger.getLogger(TimerService.class.getName()).log(Level.INFO, "Chat UI disabled ");
        }
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
        }
        this.thread.start();
    }

    public void config() {
        this.needConfig = false;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.hostname = addr.getHostName();
        }
        catch (UnknownHostException ex) {
            if (this.activeUI) {
                this.console.getLogTextArea().append("Hostname can not be resolved\n");
            }
            Logger.getLogger(TimerService.class.getName()).log(Level.INFO, "Hostname can not be resolved");
        }
        File fConfig = new File(this.sConfig);
        try {
            if (!fConfig.exists()) {
                this.needConfig = true;
                String sStep = "Please set Model name in mc3d-ai.properties";
                if (this.activeUI) {
                    this.console.getLogTextArea().append(sStep + "\n");
                }
                Logger.getLogger(TimerService.class.getName()).log(Level.SEVERE, sStep);
                sStep = "Please set Model Prompt Template in mc3d-ai.properties";
                if (this.activeUI) {
                    this.console.getLogTextArea().append(sStep + "\n");
                }
                Logger.getLogger(TimerService.class.getName()).log(Level.SEVERE, sStep);
                sStep = "Please set Cache name in mc3d-ai.properties (if cipherMessage is setting to true, the keystore will be name to <CacheName>.pfx";
                if (this.activeUI) {
                    this.console.getLogTextArea().append(sStep + "\n");
                }
                Logger.getLogger(TimerService.class.getName()).log(Level.SEVERE, sStep);
                sStep = "Please set Cache Local IP for lockup other nodes in mc3d-ai.properties";
                if (this.activeUI) {
                    this.console.getLogTextArea().append(sStep + "\n");
                }
                Logger.getLogger(TimerService.class.getName()).log(Level.SEVERE, sStep);
                sStep = "Please set CipherMessage to true if you need to turn the conversation privates in the network (AES) in mc3d-ai.properties";
                if (this.activeUI) {
                    this.console.getLogTextArea().append(sStep + "\n");
                }
                Logger.getLogger(TimerService.class.getName()).log(Level.SEVERE, sStep);
                sStep = "Please set keyStorePass in mc3d-ai.properties if you are set the cipherMessage to true, you can share the keystore (or the Certificate) with other machines or cluster Locations";
                if (this.activeUI) {
                    this.console.getLogTextArea().append(sStep + "\n");
                }
                Logger.getLogger(TimerService.class.getName()).log(Level.SEVERE, sStep);
                sStep = "Please set chatUI to false in mc3d-ai.properties if you need to run the Cluster without UI for integration or scaling up the Grid";
                if (this.activeUI) {
                    this.console.getLogTextArea().append(sStep + "\n");
                }
                Logger.getLogger(TimerService.class.getName()).log(Level.SEVERE, sStep);
                FileOutputStream fos = new FileOutputStream(this.sConfig);
                this.p.setProperty("model", "");
                this.p.setProperty("modelPromptTemplate", "### Human:\n%1\n### Assistant:");
                this.p.setProperty("cache", "");
                this.p.setProperty("cacheLocalIp", "");
                this.p.setProperty("missionPromptFolder", "");
                this.p.setProperty("cipherMessage", "false");
                this.p.setProperty("keyStorePass", "");
                this.p.setProperty("chatUI", "true");
                this.p.store(fos, "MC3D AI- configuration");
                fos.close();
            } else {
                String sLogMessage;
                FileInputStream fis = new FileInputStream(this.sConfig);
                this.p.load(fis);
                fis.close();
                this.modelFilePath = "" + this.p.getProperty("model");
                this.modelPromptTemplate = "" + this.p.getProperty("modelPromptTemplate");
                this.cacheName = "" + this.p.getProperty("cache");
                this.cacheLocalIp = "" + this.p.getProperty("cacheLocalIp");
                this.missionPromptFolder = "" + this.p.getProperty("missionPromptFolder");
                this.cipherMessage = "" + this.p.getProperty("cipherMessage");
                this.keyStorePass = "" + this.p.getProperty("keyStorePass");
                if (!this.modelFilePath.isEmpty() && !this.modelFilePath.equals("null") && new File(this.modelFilePath).exists()) {
                    sLogMessage = "Model File Path:" + this.modelFilePath;
                    if (this.activeUI) {
                        this.console.getLogTextArea().append(sLogMessage + "\n");
                    }
                    Logger.getLogger(TimerService.class.getName()).log(Level.INFO, sLogMessage);
                } else {
                    sLogMessage = "Please set model path and validate if the file mc3d-ai.properties exists";
                    if (this.activeUI) {
                        this.console.getLogTextArea().append(sLogMessage + "\n");
                    }
                    Logger.getLogger(TimerService.class.getName()).log(Level.SEVERE, sLogMessage);
                    this.p.setProperty("model", "");
                    this.needConfig = true;
                }
                if (!this.modelPromptTemplate.isEmpty() && !this.modelPromptTemplate.equals("null")) {
                    sLogMessage = "modelPromptTemplate:" + this.modelPromptTemplate;
                    if (this.activeUI) {
                        this.console.getLogTextArea().append(sLogMessage + "\n");
                    }
                    Logger.getLogger(TimerService.class.getName()).log(Level.INFO, sLogMessage);
                } else {
                    sLogMessage = "Please set model prompt template and validate if the file  mc3d-ai.properties exists (ie: ### Human:\n%1\n### Assistant:)";
                    if (this.activeUI) {
                        this.console.getLogTextArea().append(sLogMessage + "\n");
                    }
                    Logger.getLogger(TimerService.class.getName()).log(Level.SEVERE, sLogMessage);
                    this.p.setProperty("modelPromptTemplate", "### Human:\n%1\n### Assistant:");
                    this.needConfig = true;
                }
                if (!this.cacheName.isEmpty() && !this.cacheName.equals("null")) {
                    sLogMessage = "Cache name:" + this.cacheName;
                    if (this.activeUI) {
                        this.console.getLogTextArea().append(sLogMessage + "\n");
                    }
                    Logger.getLogger(TimerService.class.getName()).log(Level.INFO, sLogMessage);
                } else {
                    sLogMessage = "Please set Cache name in mc3d-ai.properties";
                    if (this.activeUI) {
                        this.console.getLogTextArea().append(sLogMessage + "\n");
                    }
                    Logger.getLogger(TimerService.class.getName()).log(Level.SEVERE, sLogMessage);
                    this.p.setProperty("cache", "");
                    this.needConfig = true;
                }
                if (!this.cacheLocalIp.isEmpty() && !this.cacheLocalIp.equals("null")) {
                    Logger.getLogger(TimerService.class.getName()).log(Level.INFO, "Cache Local Ip:" + this.cacheLocalIp);
                } else {
                    this.p.setProperty("cacheLocalIp", "");
                    sLogMessage = "Please set Cache Local IP in mc3d-ai.properties";
                    if (this.activeUI) {
                        this.console.getLogTextArea().append(sLogMessage + "\n");
                    }
                    Logger.getLogger(TimerService.class.getName()).log(Level.SEVERE, sLogMessage);
                    this.needConfig = true;
                }
                if (!this.cipherMessage.isEmpty() && !this.cipherMessage.equals("null")) {
                    Logger.getLogger(TimerService.class.getName()).log(Level.INFO, "Cipher Message:" + this.cipherMessage);
                } else {
                    sLogMessage = "Please set cipherMessage in mc3d-ai.properties";
                    if (this.activeUI) {
                        this.console.getLogTextArea().append(sLogMessage + "\n");
                    }
                    Logger.getLogger(TimerService.class.getName()).log(Level.SEVERE, sLogMessage);
                    this.p.setProperty("cipherMessage", "false");
                }
                if (this.needConfig) {
                    FileOutputStream fos = new FileOutputStream(this.sConfig);
                    this.p.store(fos, "MC3D AI- configuration");
                    fos.close();
                }
            }
        }
        catch (Exception ex) {
            String sLogMessage = ex.toString();
            if (this.activeUI) {
                this.console.getLogTextArea().append(sLogMessage + "\n");
            }
            Logger.getLogger(TimerService.class.getName()).log(Level.SEVERE, (String)null, sLogMessage);
        }
    }

    @Override
    public void run() {
        block25: {
            String os = System.getProperty("os.name");
            String gpt4allVersion = "linux-2.7.0";
            if (os.toLowerCase().contains("win")) {
                gpt4allVersion = "windows-2.7.0";
            }
            Logger.getLogger(LLModel.class.getName()).log(Level.INFO, "Java bindings for gpt4all version: " + gpt4allVersion);
            this.libraryPath = this.getLibraryPath(gpt4allVersion);
            String sLogMessage = "needConfig: " + this.needConfig;
            if (this.activeUI) {
                this.console.getLogTextArea().append(sLogMessage + "\n");
            }
            Logger.getLogger(LLModel.class.getName()).log(Level.INFO, sLogMessage);
            if (!this.needConfig) {
                try {
                    IgniteConfiguration igniteCfg = new IgniteConfiguration();
                    igniteCfg.setLocalHost(this.cacheLocalIp);
                    this.ignite = Ignition.start((IgniteConfiguration)igniteCfg);
                    CacheConfiguration cacheCfg = new CacheConfiguration();
                    cacheCfg.setName(this.cacheName);
                    cacheCfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
                    cacheCfg.setCacheMode(CacheMode.REPLICATED);
                    this.igniteCache = this.ignite.getOrCreateCache(cacheCfg);
                    Iterator iCacheNames = this.ignite.cacheNames().iterator();
                    while (iCacheNames.hasNext()) {
                        sLogMessage = "Cache List:" + (String)iCacheNames.next();
                        if (this.activeUI) {
                            this.console.getLogTextArea().append(sLogMessage + "\n");
                        }
                        System.out.println(sLogMessage);
                    }
                }
                catch (Exception e) {
                    this.ignite.close();
                    sLogMessage = "TimerService, Cluster stopped: " + e.toString();
                    if (this.activeUI) {
                        this.console.getLogTextArea().append(sLogMessage + "\n");
                    }
                    Logger.getLogger(TimerService.class.getName()).log(Level.SEVERE, sLogMessage);
                }
                if (this.activeUI) {
                    this.console.getIgniteControl().setBackground(Color.yellow);
                }
                Path path = Paths.get(this.modelFilePath, new String[0]);
                LLModel model = new LLModel(gpt4allVersion, path, this.libraryPath, 32768);
                LLModel.GenerationConfig config = LLModel.config().withNPredict(2048).build();
                model.llmodel_gpu_init_gpu_device_by_int(1);
                GridSuscribeFile unitaryProcessFileWriter = new GridSuscribeFile(this.locationStart, this.igniteCache, this.cacheName, model, config, this.modelPromptTemplate, this.cipherMessage, this.keyStorePass);
                unitaryProcessFileWriter.start();
                GridDownloadResponse gridDownloadResponse = new GridDownloadResponse(this.locationStart, this.igniteCache, this.cacheName, model, config, this.modelPromptTemplate, this.cipherMessage, this.keyStorePass);
                gridDownloadResponse.start();
                sLogMessage = "TimerService, Cluster running";
                if (this.activeUI) {
                    this.console.getLogTextArea().append(sLogMessage + "\n");
                    this.console.getIgniteControl().setSelected(true);
                    this.console.getIgniteControl().setBackground(Color.green);
                    this.console.getIgniteControl().setEnabled(true);
                }
                Logger.getLogger(TimerService.class.getName()).log(Level.INFO, sLogMessage);
                long diferenceCluster = System.currentTimeMillis();
                while (true) {
                    if (this.activeUI) {
                        if (!this.console.getIgniteControl().isSelected()) break block25;
                        if (System.currentTimeMillis() - diferenceCluster >= 500L) {
                            Collection nodosConectados = this.ignite.cluster().forCacheNodes(this.cacheName).nodes();
                            int iLine = 0;
                            for (ClusterNode nodo : nodosConectados) {
                                String id = "" + nodo.id();
                                if (id.equals("" + this.ignite.cluster().localNode().id())) {
                                    Properties nodeInfo = new Properties();
                                    nodeInfo.setProperty("modelName", this.modelFilePath);
                                    this.igniteCache.put((Object)("services_" + id), (Object)nodeInfo);
                                }
                                String ip = "" + nodo.addresses();
                                String lastAccess = "" + System.currentTimeMillis();
                                if (this.igniteCache.get((Object)("services_" + id)) != null) {
                                    String modelName = "" + ((Properties)this.igniteCache.get((Object)("services_" + id))).getProperty("modelName");
                                    int iGridStatus = this.console.getDtmGridStatus().getRowCount();
                                    boolean existsRow = false;
                                    for (int j = 0; j < iGridStatus; ++j) {
                                        if (!this.console.getDtmGridStatus().getValueAt(j, 0).toString().equals(id) || !this.console.getDtmGridStatus().getValueAt(j, 1).toString().equals(ip)) continue;
                                        existsRow = true;
                                        break;
                                    }
                                    if (!existsRow) {
                                        Vector<String> vector = new Vector<String>();
                                        vector.add(id);
                                        vector.add(ip);
                                        vector.add(modelName);
                                        vector.add(lastAccess);
                                        this.console.getDtmGridStatus().addRow(vector);
                                    } else {
                                        long diferenceGrid = Long.parseLong(lastAccess) - Long.parseLong("" + this.console.getDtmGridStatus().getValueAt(iLine, 3).toString());
                                        if (diferenceGrid >= 1000L) {
                                            this.console.getDtmGridStatus().setValueAt(id, iLine, 0);
                                            this.console.getDtmGridStatus().setValueAt(ip, iLine, 1);
                                            this.console.getDtmGridStatus().setValueAt(modelName, iLine, 2);
                                            this.console.getDtmGridStatus().setValueAt(lastAccess, iLine, 3);
                                        }
                                    }
                                }
                                ++iLine;
                            }
                            int iData = this.console.getDtmGridStatus().getRowCount();
                            for (int i = 0; i < iData; ++i) {
                                long lLastAccess = Long.parseLong(this.console.getDtmGridStatus().getValueAt(i, 3).toString());
                                long now = System.currentTimeMillis();
                                if (now - lLastAccess <= 5000L) continue;
                                this.console.getDtmGridStatus().removeRow(i);
                            }
                            diferenceCluster = System.currentTimeMillis();
                        }
                    }
                    try {
                        Long start = System.currentTimeMillis();
                        GridPublishFile unitaryProcessFileReader = new GridPublishFile(this.locationStart, this.igniteCache, this.cacheName, this.hostname, this.modelFilePath, this.missionPromptFolder, this.cipherMessage, this.keyStorePass);
                        unitaryProcessFileReader.start();
                        Long end = System.currentTimeMillis();
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
            }
            sLogMessage = "TimerService, Cluster not running";
            if (this.activeUI) {
                this.console.getLogTextArea().append(sLogMessage + "\n");
            }
            Logger.getLogger(TimerService.class.getName()).log(Level.INFO, sLogMessage);
        }
    }

    public String getLibraryPath(String gpt4allVersion) {
        String result = "";
        try {
            String classpath = System.getProperty("java.class.path");
            String str1 = "TimerService Classpath: " + classpath;
            if (this.activeUI) {
                this.console.getLogTextArea().append(str1 + "\n");
            }
            Logger.getLogger(TimerService.class.getName()).log(Level.INFO, str1);
            str1 = "TimerService locationStart: " + this.locationStart;
            if (this.activeUI) {
                this.console.getLogTextArea().append(str1 + "\n");
            }
            Logger.getLogger(TimerService.class.getName()).log(Level.INFO, str1);
            if (!classpath.equals("MeshGrid_GPT.jar")) {
                String[] sFindLib;
                File findLib = new File(this.locationStart);
                for (String dist : sFindLib = findLib.list()) {
                    if (!dist.equals("dist")) continue;
                    this.locationStart = this.locationStart + "/dist";
                    break;
                }
            }
            String sGPT4All = "gpt4all-" + gpt4allVersion;
            String destinationDirectory = this.locationStart + "/lib";
            if (destinationDirectory.contains("\\")) {
                destinationDirectory = destinationDirectory.replaceAll("\\\\", "/");
            }
            if (!new File(destinationDirectory + "/" + sGPT4All).exists()) {
                String archivoZip = destinationDirectory + "/" + sGPT4All + ".zip";
                DescompresorZip.descomprimirArchivoZip(archivoZip, destinationDirectory + "/" + sGPT4All);
            }
            result = destinationDirectory + "/" + sGPT4All;
        }
        catch (Exception ex) {
            String str = ex.toString();
            if (this.activeUI) {
                this.console.getLogTextArea().append(str + "\n");
            }
            Logger.getLogger(TimerService.class.getName()).log(Level.INFO, str);
        }
        String sLogMessage = "Library Path: " + result;
        if (this.activeUI) {
            this.console.getLogTextArea().append(sLogMessage + "\n");
        }
        Logger.getLogger(TimerService.class.getName()).log(Level.INFO, sLogMessage);
        return result;
    }

    public void stop() {
        try {
            this.ignite.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (this.console.getDtmGridStatus().getRowCount() > 0) {
            this.console.getDtmGridStatus().removeRow(0);
        }
        this.thread = null;
        Thread.interrupted();
        String sLogMessage = "TimerService, Cluster not running";
        if (this.activeUI) {
            this.console.getLogTextArea().append(sLogMessage + "\n");
        }
        Logger.getLogger(TimerService.class.getName()).log(Level.SEVERE, sLogMessage);
    }

    public static void main(String[] args) {
        TimerService timerService = new TimerService();
    }
}

