/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.ai;

import cl.mc3d.ai.FileInterpreter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PubSubFiles {
    public LinkedHashMap putQuestion(String location, String localDocsFolder, String uuid, String question) {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        try {
            location = location + "questions";
            File fDirectory = new File(location);
            if (!fDirectory.exists()) {
                fDirectory.mkdirs();
            }
            String fileName = location + "/" + uuid + ".txt";
            RandomAccessFile raf = new RandomAccessFile(fileName, "rw");
            String searchLocalDocs = "localDoc=\"";
            if (question.contains(searchLocalDocs)) {
                String line = question;
                while (line.contains(searchLocalDocs)) {
                    String localDoc = line.substring(line.indexOf(searchLocalDocs) + searchLocalDocs.length(), line.length());
                    localDoc = localDoc.substring(0, localDoc.indexOf("\""));
                    String searchText = "localDoc=\"" + localDoc + "\"";
                    String startInQuestion = question.substring(0, question.indexOf(searchText));
                    String endInQuestion = question.substring(question.indexOf(searchText) + searchText.length(), question.length());
                    String localDocText = "";
                    if (localDoc.toLowerCase().endsWith(".txt")) {
                        try {
                            byte[] bytes = Files.readAllBytes(Paths.get(localDocsFolder + localDoc, new String[0]));
                            localDocText = new String(bytes, StandardCharsets.UTF_8);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else if (localDoc.toLowerCase().endsWith(".pdf")) {
                        FileInterpreter f2t = new FileInterpreter();
                        localDocText = f2t.getPdf2Text(localDoc);
                    }
                    question = startInQuestion + localDocText + endInQuestion;
                    line = line.substring(line.indexOf(localDoc) + localDoc.length(), line.length());
                }
            }
            raf.writeBytes(question);
            raf.close();
            resultMap.put("uuid", uuid + ".txt");
        }
        catch (Exception ex) {
            Logger.getLogger(PubSubFiles.class.getName()).log(Level.SEVERE, null, ex);
        }
        return resultMap;
    }

    public synchronized List getResponseId(String location) {
        ArrayList<String> resultMap = new ArrayList<String>();
        try {
            String[] fileList;
            String sDirectory = location + "responses/";
            File fDirectory = new File(sDirectory);
            if (!fDirectory.exists()) {
                fDirectory.mkdirs();
            }
            for (String sFile : fileList = fDirectory.list()) {
                if (!sFile.endsWith(".txt")) continue;
                resultMap.add(sFile);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(PubSubFiles.class.getName()).log(Level.SEVERE, null, ex);
        }
        return resultMap;
    }

    public synchronized LinkedHashMap getResponse(String location, String name) {
        String data = "";
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        try {
            String sResponse = location + "responses/" + name;
            File fResponse = new File(sResponse);
            if (fResponse.exists()) {
                FileInputStream is = new FileInputStream(fResponse);
                DataInputStream dis = new DataInputStream(is);
                String line = "";
                while ((line = dis.readLine()) != null) {
                    System.out.println(line);
                    data = data + "\r\n" + line;
                }
                dis.close();
                ((InputStream)is).close();
            }
            resultMap.put("data", data);
        }
        catch (Exception ex) {
            Logger.getLogger(PubSubFiles.class.getName()).log(Level.SEVERE, null, ex);
        }
        return resultMap;
    }

    public synchronized boolean deleteResponse(String location, String name) {
        boolean status = false;
        try {
            String sResponse = location + "responses/" + name;
            File fResponse = new File(sResponse);
            if (fResponse.exists()) {
                fResponse.delete();
                status = true;
            }
            String sQuestionProcessed = location + "questions_processed/" + name;
            System.out.println("sQuestionProcessed: " + sQuestionProcessed);
            File fQuestionProcessed = new File(sQuestionProcessed);
            if (fQuestionProcessed.exists()) {
                fQuestionProcessed.delete();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(PubSubFiles.class.getName()).log(Level.SEVERE, null, ex);
        }
        return status;
    }
}

