/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.ai;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class JProgressItem
extends JPanel
implements Runnable {
    private Thread thread;
    private String file;
    private long finalSize;
    private JProgressBar progressBar;
    private boolean endFile = false;
    private JLabel titleLabel;

    public JProgressItem(String destinationFolder, String model, String modelType, String modelSize) {
        this.setLayout(new FlowLayout(0));
        JPanel groupComponent = new JPanel(new GridLayout(2, 1));
        this.finalSize = JProgressItem.gigabytesToBytes(modelSize);
        if (model.contains("/")) {
            model = model.substring(1, model.lastIndexOf("/"));
        }
        model = model.toLowerCase();
        if ((modelType = modelType.toLowerCase()).contains(".gguf")) {
            modelType = modelType.substring(0, modelType.lastIndexOf(".gguf"));
            modelType = modelType + "-by_" + model + ".tmp";
        }
        this.titleLabel = new JLabel(modelType);
        this.setBorder(BorderFactory.createTitledBorder("Download"));
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(150, 20));
        groupComponent.add(this.titleLabel);
        groupComponent.add(this.progressBar);
        this.add(groupComponent);
        if (destinationFolder.contains("\\")) {
            destinationFolder = destinationFolder.replaceAll("\\\\", "/");
        }
        this.file = destinationFolder + "/" + modelType;
        this.start();
    }

    public long getFileSize(String filePath) {
        long iSize = 0L;
        System.out.println("File monitoring: " + filePath);
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            iSize = file.length();
        } else {
            System.err.println("El archivo no existe o no es un archivo v\u00e1lido.");
            filePath = filePath.toLowerCase().replaceAll(".tmp", ".gguf");
            File finalFile = new File(filePath);
            if (finalFile.exists()) {
                iSize = -2L;
                this.titleLabel.setText(filePath);
                this.endFile = true;
            }
        }
        return iSize;
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
        }
        this.thread.start();
    }

    @Override
    public void run() {
        do {
            try {
                double currentSize = this.getFileSize(this.file);
                Double avance = currentSize / (double)this.finalSize;
                if (currentSize == -2.0) {
                    avance = 1.0;
                }
                System.out.println("Porcentaje de avance: filesize=" + this.finalSize + ", in progress=" + this.getFileSize(this.file) + ", avance:" + avance);
                String sAdvance = avance.toString();
                if (sAdvance.contains(".")) {
                    sAdvance = sAdvance.substring(0, sAdvance.lastIndexOf("."));
                }
                this.progressBar.setValue(Integer.parseInt(sAdvance) * 100);
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        } while (!this.endFile);
    }

    public static long gigabytesToBytes(String modelSize) {
        double size = 0.0;
        if (modelSize.toLowerCase().contains("gb")) {
            size = Double.parseDouble(modelSize.substring(0, modelSize.indexOf(" ")));
        }
        return (long)(size * Math.pow(1024.0, 3.0));
    }
}

