/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.ai;

import java.io.File;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class DownloadModels
implements Runnable {
    private Thread thread;
    private String carpetaDestino;
    private String model;
    private String modelType;

    public DownloadModels(String carpetaDestino, String model, String modelType) {
        this.carpetaDestino = carpetaDestino;
        this.model = model;
        this.modelType = modelType;
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
        }
        this.thread.start();
    }

    @Override
    public void run() {
        try {
            URL url = new URL("https://huggingface.co" + this.model + "/resolve/main/" + this.modelType + "?download=true");
            System.out.println("Download model: " + url);
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("Content-Type", "application/octet-stream");
            HttpURLConnection httpUrlConnection = (HttpURLConnection)connection;
            if (this.model.contains("/")) {
                this.model = this.model.substring(1, this.model.lastIndexOf("/"));
            }
            this.model = this.model.toLowerCase();
            this.modelType = this.modelType.toLowerCase();
            if (this.modelType.contains(".gguf")) {
                this.modelType = this.modelType.substring(0, this.modelType.lastIndexOf(".gguf"));
                this.modelType = this.modelType + "-by_" + this.model + ".tmp";
            }
            System.out.println("Download model: " + this.model);
            File fModelType = new File(this.carpetaDestino + "/" + this.modelType);
            if (!fModelType.exists()) {
                ReadableByteChannel readableByteChannel = Channels.newChannel(httpUrlConnection.getInputStream());
                FileOutputStream fileOutputStream = new FileOutputStream(fModelType);
                fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                fileOutputStream.close();
                readableByteChannel.close();
                System.out.println("Descarga de model finalizada:" + this.modelType);
                if (this.modelType.contains(".tmp")) {
                    this.modelType = this.modelType.substring(0, this.modelType.lastIndexOf(".tmp"));
                    this.modelType = this.modelType + ".gguf";
                    fModelType.renameTo(new File(this.carpetaDestino + "/" + this.modelType));
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

