/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.ai;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DescompresorZip {
    public static String descomprimirArchivoZip(String archivoZip, String carpetaDestino) throws IOException {
        String finalFolder = "";
        File destino = new File(carpetaDestino);
        byte[] buffer = new byte[1024];
        if (!destino.exists()) {
            destino.mkdir();
        }
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(archivoZip));){
            ZipEntry entradaZip = zis.getNextEntry();
            while (entradaZip != null) {
                String lastDirectory;
                String nombreEntrada = entradaZip.getName();
                String archivoDescomprimido = carpetaDestino + "/" + nombreEntrada;
                if (archivoDescomprimido.contains("/") && !new File(lastDirectory = archivoDescomprimido.substring(0, archivoDescomprimido.lastIndexOf("/"))).exists()) {
                    new File(lastDirectory).mkdirs();
                    finalFolder = lastDirectory;
                }
                try (FileOutputStream fos = new FileOutputStream(archivoDescomprimido);){
                    int longitud;
                    while ((longitud = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, longitud);
                    }
                }
                entradaZip = zis.getNextEntry();
            }
        }
        System.out.println("Descompresi\u00f3n completada en: " + finalFolder);
        return finalFolder;
    }
}

