/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security;

import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.util.typedef.F;

public abstract class IgniteSecurityAdapter
extends GridProcessorAdapter
implements IgniteSecurity {
    private static final CodeSource CORE_CODE_SOURCE = SecurityUtils.class.getProtectionDomain().getCodeSource();
    private static final ConcurrentMap<Class<?>, Boolean> SYSTEM_TYPES = new ConcurrentHashMap();

    protected IgniteSecurityAdapter(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public boolean isSystemType(Class<?> cls) {
        return SYSTEM_TYPES.computeIfAbsent(cls, c -> {
            ProtectionDomain pd = SecurityUtils.doPrivileged(c::getProtectionDomain);
            return pd != null && F.eq(CORE_CODE_SOURCE, pd.getCodeSource());
        });
    }
}

