/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.HashSet;
import java.util.Set;
import javax.cache.CacheException;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class QueryEntityEx
extends QueryEntity {
    private static final long serialVersionUID = 0L;
    private Set<String> notNullFields;
    private boolean preserveKeysOrder;
    private boolean implicitPk;
    private boolean fillAbsentPKsWithDefaults;
    private Integer pkInlineSize;
    private Integer affKeyInlineSize;

    public QueryEntityEx() {
    }

    public QueryEntityEx(QueryEntity other) {
        super(other);
        if (other instanceof QueryEntityEx) {
            QueryEntityEx other0 = (QueryEntityEx)other;
            this.notNullFields = other0.notNullFields != null ? new HashSet<String>(other0.notNullFields) : null;
            this.preserveKeysOrder = other0.preserveKeysOrder;
            this.implicitPk = other0.implicitPk;
            this.fillAbsentPKsWithDefaults = other0.fillAbsentPKsWithDefaults;
            this.pkInlineSize = other0.pkInlineSize != null ? other0.pkInlineSize : -1;
            this.affKeyInlineSize = other0.affKeyInlineSize != null ? other0.affKeyInlineSize : -1;
        }
    }

    @Override
    @Nullable
    public Set<String> getNotNullFields() {
        return this.notNullFields;
    }

    @Override
    public QueryEntity setNotNullFields(@Nullable Set<String> notNullFields) {
        this.notNullFields = notNullFields;
        return this;
    }

    public boolean isPreserveKeysOrder() {
        return this.preserveKeysOrder;
    }

    public QueryEntity setPreserveKeysOrder(boolean preserveKeysOrder) {
        this.preserveKeysOrder = preserveKeysOrder;
        return this;
    }

    public boolean implicitPk() {
        return this.implicitPk;
    }

    public QueryEntity implicitPk(boolean implicitPk) {
        this.implicitPk = implicitPk;
        return this;
    }

    public boolean fillAbsentPKsWithDefaults() {
        return this.fillAbsentPKsWithDefaults;
    }

    public QueryEntity fillAbsentPKsWithDefaults(boolean fillAbsentPKsWithDefaults) {
        this.fillAbsentPKsWithDefaults = fillAbsentPKsWithDefaults;
        return this;
    }

    public Integer getPrimaryKeyInlineSize() {
        return this.pkInlineSize;
    }

    public QueryEntity setPrimaryKeyInlineSize(Integer pkInlineSize) {
        if (pkInlineSize != null && pkInlineSize < 0) {
            throw new CacheException("Inline size for sorted primary key cannot be negative. [inlineSize=" + pkInlineSize + ']');
        }
        this.pkInlineSize = pkInlineSize;
        return this;
    }

    public Integer getAffinityKeyInlineSize() {
        return this.affKeyInlineSize;
    }

    public QueryEntity setAffinityKeyInlineSize(Integer affKeyInlineSize) {
        if (affKeyInlineSize != null && affKeyInlineSize < 0) {
            throw new CacheException("Inline size for affinity fieled index cannot be negative. [inlineSize=" + affKeyInlineSize + ']');
        }
        this.affKeyInlineSize = affKeyInlineSize;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryEntityEx entity = (QueryEntityEx)o;
        return super.equals(entity) && F.eq(this.notNullFields, entity.notNullFields) && this.preserveKeysOrder == entity.preserveKeysOrder && this.implicitPk == entity.implicitPk && F.eq(this.pkInlineSize, entity.pkInlineSize) && F.eq(this.affKeyInlineSize, entity.affKeyInlineSize);
    }

    @Override
    public int hashCode() {
        int res = super.hashCode();
        res = 31 * res + (this.notNullFields != null ? this.notNullFields.hashCode() : 0);
        res = 31 * res + (this.preserveKeysOrder ? 1 : 0);
        res = 31 * res + (this.implicitPk ? 1 : 0);
        res = 31 * res + (this.pkInlineSize != null ? this.pkInlineSize.hashCode() : 0);
        res = 31 * res + (this.affKeyInlineSize != null ? this.affKeyInlineSize.hashCode() : 0);
        return res;
    }

    @Override
    public String toString() {
        return S.toString(QueryEntityEx.class, this);
    }
}

