/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.performancestatistics;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentedRingByteBuffer;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.performancestatistics.OperationType;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridIntIterator;
import org.apache.ignite.internal.util.GridIntList;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.thread.IgniteThread;

public class FilePerformanceStatisticsWriter {
    public static final String PERF_STAT_DIR = "perf_stat";
    public static final long DFLT_FILE_MAX_SIZE = 0x800000000L;
    public static final int DFLT_BUFFER_SIZE = 0x2000000;
    public static final int DFLT_FLUSH_SIZE = 0x800000;
    public static final int DFLT_CACHED_STRINGS_THRESHOLD = 10240;
    static final String WRITER_THREAD_NAME = "performance-statistics-writer";
    private final int flushSize = IgniteSystemProperties.getInteger("IGNITE_PERF_STAT_FLUSH_SIZE", 0x800000);
    private final int cachedStrsThreshold = IgniteSystemProperties.getInteger("IGNITE_PERF_STAT_CACHED_STRINGS_THRESHOLD", 10240);
    private final FileIOFactory fileIoFactory = new RandomAccessFileIOFactory();
    private final File file;
    private final FileIO fileIo;
    private final FileWriter fileWriter;
    private boolean started;
    private final SegmentedRingByteBuffer ringByteBuf;
    private final AtomicInteger writtenToBuf = new AtomicInteger();
    private final AtomicBoolean smallBufLogged = new AtomicBoolean();
    private final AtomicBoolean stopByMaxSize = new AtomicBoolean();
    private final IgniteLogger log;
    private final Set<Integer> knownStrs = new GridConcurrentHashSet<Integer>();
    private volatile int knownStrsSz;

    public FilePerformanceStatisticsWriter(GridKernalContext ctx) throws IgniteCheckedException, IOException {
        this.log = ctx.log(this.getClass());
        this.file = FilePerformanceStatisticsWriter.resolveStatisticsFile(ctx);
        this.fileIo = this.fileIoFactory.create(this.file);
        this.log.info("Performance statistics file created [file=" + this.file.getAbsolutePath() + ']');
        long fileMaxSize = IgniteSystemProperties.getLong("IGNITE_PERF_STAT_FILE_MAX_SIZE", 0x800000000L);
        int bufSize = IgniteSystemProperties.getInteger("IGNITE_PERF_STAT_BUFFER_SIZE", 0x2000000);
        this.ringByteBuf = new SegmentedRingByteBuffer(bufSize, fileMaxSize, SegmentedRingByteBuffer.BufferMode.DIRECT);
        this.fileWriter = new FileWriter(ctx, this.log);
    }

    public synchronized void start() {
        assert (!this.started);
        new IgniteThread(this.fileWriter).start();
        this.started = true;
    }

    public synchronized void stop() {
        assert (this.started);
        this.ringByteBuf.close();
        U.awaitForWorkersStop(Collections.singleton(this.fileWriter), true, this.log);
        this.ringByteBuf.poll();
        this.ringByteBuf.free();
        try {
            this.fileIo.force();
        }
        catch (IOException e) {
            this.log.warning("Failed to fsync the performance statistics file.", e);
        }
        U.closeQuiet(this.fileIo);
        this.knownStrs.clear();
        this.started = false;
    }

    public void cacheStart(int cacheId, String name) {
        boolean cached = this.cacheIfPossible(name);
        this.doWrite(OperationType.CACHE_START, OperationType.cacheStartRecordSize(cached ? 0 : name.getBytes().length, cached), buf -> {
            FilePerformanceStatisticsWriter.writeString(buf, name, cached);
            buf.putInt(cacheId);
        });
    }

    public void cacheOperation(OperationType type, int cacheId, long startTime, long duration) {
        this.doWrite(type, OperationType.cacheRecordSize(), buf -> {
            buf.putInt(cacheId);
            buf.putLong(startTime);
            buf.putLong(duration);
        });
    }

    public void transaction(GridIntList cacheIds, long startTime, long duration, boolean commited) {
        this.doWrite(commited ? OperationType.TX_COMMIT : OperationType.TX_ROLLBACK, OperationType.transactionRecordSize(cacheIds.size()), buf -> {
            buf.putInt(cacheIds.size());
            GridIntIterator iter = cacheIds.iterator();
            while (iter.hasNext()) {
                buf.putInt(iter.next());
            }
            buf.putLong(startTime);
            buf.putLong(duration);
        });
    }

    public void query(GridCacheQueryType type, String text, long id, long startTime, long duration, boolean success) {
        boolean cached = this.cacheIfPossible(text);
        this.doWrite(OperationType.QUERY, OperationType.queryRecordSize(cached ? 0 : text.getBytes().length, cached), buf -> {
            FilePerformanceStatisticsWriter.writeString(buf, text, cached);
            buf.put((byte)type.ordinal());
            buf.putLong(id);
            buf.putLong(startTime);
            buf.putLong(duration);
            buf.put(success ? (byte)1 : (byte)0);
        });
    }

    public void queryReads(GridCacheQueryType type, UUID queryNodeId, long id, long logicalReads, long physicalReads) {
        this.doWrite(OperationType.QUERY_READS, OperationType.queryReadsRecordSize(), buf -> {
            buf.put((byte)type.ordinal());
            FilePerformanceStatisticsWriter.writeUuid(buf, queryNodeId);
            buf.putLong(id);
            buf.putLong(logicalReads);
            buf.putLong(physicalReads);
        });
    }

    public void queryRows(GridCacheQueryType type, UUID qryNodeId, long id, String action, long rows) {
        boolean cached = this.cacheIfPossible(action);
        this.doWrite(OperationType.QUERY_ROWS, OperationType.queryRowsRecordSize(cached ? 0 : action.getBytes().length, cached), buf -> {
            FilePerformanceStatisticsWriter.writeString(buf, action, cached);
            buf.put((byte)type.ordinal());
            FilePerformanceStatisticsWriter.writeUuid(buf, qryNodeId);
            buf.putLong(id);
            buf.putLong(rows);
        });
    }

    public void queryProperty(GridCacheQueryType type, UUID qryNodeId, long id, String name, String val) {
        if (val == null) {
            return;
        }
        boolean cachedName = this.cacheIfPossible(name);
        boolean cachedVal = this.cacheIfPossible(val);
        this.doWrite(OperationType.QUERY_PROPERTY, OperationType.queryPropertyRecordSize(cachedName ? 0 : name.getBytes().length, cachedName, cachedVal ? 0 : val.getBytes().length, cachedVal), buf -> {
            FilePerformanceStatisticsWriter.writeString(buf, name, cachedName);
            FilePerformanceStatisticsWriter.writeString(buf, val, cachedVal);
            buf.put((byte)type.ordinal());
            FilePerformanceStatisticsWriter.writeUuid(buf, qryNodeId);
            buf.putLong(id);
        });
    }

    public void task(IgniteUuid sesId, String taskName, long startTime, long duration, int affPartId) {
        boolean cached = this.cacheIfPossible(taskName);
        this.doWrite(OperationType.TASK, OperationType.taskRecordSize(cached ? 0 : taskName.getBytes().length, cached), buf -> {
            FilePerformanceStatisticsWriter.writeString(buf, taskName, cached);
            FilePerformanceStatisticsWriter.writeIgniteUuid(buf, sesId);
            buf.putLong(startTime);
            buf.putLong(duration);
            buf.putInt(affPartId);
        });
    }

    public void job(IgniteUuid sesId, long queuedTime, long startTime, long duration, boolean timedOut) {
        this.doWrite(OperationType.JOB, OperationType.jobRecordSize(), buf -> {
            FilePerformanceStatisticsWriter.writeIgniteUuid(buf, sesId);
            buf.putLong(queuedTime);
            buf.putLong(startTime);
            buf.putLong(duration);
            buf.put(timedOut ? (byte)1 : (byte)0);
        });
    }

    File file() {
        return this.file;
    }

    public void checkpoint(long beforeLockDuration, long lockWaitDuration, long listenersExecDuration, long markDuration, long lockHoldDuration, long pagesWriteDuration, long fsyncDuration, long walCpRecordFsyncDuration, long writeCpEntryDuration, long splitAndSortCpPagesDuration, long totalDuration, long cpStartTime, int pagesSize, int dataPagesWritten, int cowPagesWritten) {
        this.doWrite(OperationType.CHECKPOINT, OperationType.checkpointRecordSize(), buf -> {
            buf.putLong(beforeLockDuration);
            buf.putLong(lockWaitDuration);
            buf.putLong(listenersExecDuration);
            buf.putLong(markDuration);
            buf.putLong(lockHoldDuration);
            buf.putLong(pagesWriteDuration);
            buf.putLong(fsyncDuration);
            buf.putLong(walCpRecordFsyncDuration);
            buf.putLong(writeCpEntryDuration);
            buf.putLong(splitAndSortCpPagesDuration);
            buf.putLong(totalDuration);
            buf.putLong(cpStartTime);
            buf.putInt(pagesSize);
            buf.putInt(dataPagesWritten);
            buf.putInt(cowPagesWritten);
        });
    }

    public void pagesWriteThrottle(long endTime, long duration) {
        this.doWrite(OperationType.PAGES_WRITE_THROTTLE, OperationType.pagesWriteThrottleRecordSize(), buf -> {
            buf.putLong(endTime);
            buf.putLong(duration);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(OperationType op, int recSize, Consumer<ByteBuffer> writer) {
        int size = recSize + 1;
        SegmentedRingByteBuffer.WriteSegment seg = this.ringByteBuf.offer(size);
        if (seg == null) {
            if (this.smallBufLogged.compareAndSet(false, true)) {
                this.log.warning("The performance statistics in-memory buffer size is too small. Some operations will not be logged.");
            }
            return;
        }
        if (seg.buffer() == null) {
            seg.release();
            if (!this.fileWriter.isCancelled() && this.stopByMaxSize.compareAndSet(false, true)) {
                this.log.warning("The performance statistics file maximum size is reached.");
            }
            return;
        }
        ByteBuffer buf = seg.buffer();
        buf.put(op.id());
        writer.accept(buf);
        seg.release();
        int bufCnt = this.writtenToBuf.get() / this.flushSize;
        if (this.writtenToBuf.addAndGet(size) / this.flushSize > bufCnt) {
            FileWriter fileWriter = this.fileWriter;
            synchronized (fileWriter) {
                this.fileWriter.notify();
            }
        }
    }

    private static File resolveStatisticsFile(GridKernalContext ctx) throws IgniteCheckedException {
        String igniteWorkDir = U.workDirectory(ctx.config().getWorkDirectory(), ctx.config().getIgniteHome());
        File fileDir = U.resolveWorkDirectory(igniteWorkDir, PERF_STAT_DIR, false);
        File file = new File(fileDir, "node-" + ctx.localNodeId() + ".prf");
        int idx = 0;
        while (file.exists()) {
            file = new File(fileDir, "node-" + ctx.localNodeId() + '-' + ++idx + ".prf");
        }
        return file;
    }

    private static void writeUuid(ByteBuffer buf, UUID uuid) {
        buf.putLong(uuid.getMostSignificantBits());
        buf.putLong(uuid.getLeastSignificantBits());
    }

    static void writeIgniteUuid(ByteBuffer buf, IgniteUuid uuid) {
        buf.putLong(uuid.globalId().getMostSignificantBits());
        buf.putLong(uuid.globalId().getLeastSignificantBits());
        buf.putLong(uuid.localId());
    }

    static void writeString(ByteBuffer buf, String str, boolean cached) {
        buf.put(cached ? (byte)1 : 0);
        if (cached) {
            buf.putInt(str.hashCode());
        } else {
            byte[] bytes = str.getBytes();
            buf.putInt(bytes.length);
            buf.put(bytes);
        }
    }

    private boolean cacheIfPossible(String str) {
        if (this.knownStrsSz >= this.cachedStrsThreshold) {
            return false;
        }
        int hash = str.hashCode();
        if (this.knownStrs.contains(hash) || !this.knownStrs.add(hash)) {
            return true;
        }
        this.knownStrsSz = this.knownStrs.size();
        return false;
    }

    private class FileWriter
    extends GridWorker {
        FileWriter(GridKernalContext ctx, IgniteLogger log) {
            super(ctx.igniteInstanceName(), FilePerformanceStatisticsWriter.WRITER_THREAD_NAME, log, ctx.workersRegistry());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            try {
                long writtenToFile = 0L;
                while (!this.isCancelled()) {
                    this.blockingSectionBegin();
                    try {
                        FileWriter fileWriter = this;
                        synchronized (fileWriter) {
                            if (writtenToFile / (long)FilePerformanceStatisticsWriter.this.flushSize == (long)(FilePerformanceStatisticsWriter.this.writtenToBuf.get() / FilePerformanceStatisticsWriter.this.flushSize)) {
                                this.wait();
                            }
                        }
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                    writtenToFile += (long)this.flush();
                }
                this.flush();
            }
            catch (InterruptedException e) {
                try {
                    this.flush();
                }
                catch (IOException iOException) {}
            }
            catch (ClosedByInterruptException e) {
            }
            catch (IOException e) {
                this.log.error("Unable to write to the performance statistics file.", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int flush() throws IOException {
            List<SegmentedRingByteBuffer.ReadSegment> segs = FilePerformanceStatisticsWriter.this.ringByteBuf.poll();
            if (segs == null) {
                return 0;
            }
            int written = 0;
            for (SegmentedRingByteBuffer.ReadSegment seg : segs) {
                this.updateHeartbeat();
                try {
                    written += FilePerformanceStatisticsWriter.this.fileIo.writeFully(seg.buffer());
                }
                finally {
                    seg.release();
                }
            }
            return written;
        }
    }
}

