/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.IgniteFutureCancelledCheckedException;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.AbstractSnapshotFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotFutureTaskResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotSender;
import org.apache.ignite.internal.processors.marshaller.MappedName;
import org.apache.ignite.internal.util.lang.IgniteThrowableRunner;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;

public abstract class AbstractCreateSnapshotFutureTask
extends AbstractSnapshotFutureTask<SnapshotFutureTaskResult> {
    protected final Map<Integer, Set<Integer>> processed = new HashMap<Integer, Set<Integer>>();
    protected volatile CompletableFuture<Void> closeFut;

    protected AbstractCreateSnapshotFutureTask(GridCacheSharedContext<?, ?> cctx, UUID srcNodeId, UUID reqId, String snpName, SnapshotSender snpSndr, Map<Integer, Set<Integer>> parts) {
        super(cctx, srcNodeId, reqId, snpName, snpSndr, parts);
    }

    protected abstract List<CompletableFuture<Void>> saveCacheConfigs();

    protected abstract List<CompletableFuture<Void>> saveGroup(int var1, Set<Integer> var2) throws IgniteCheckedException;

    @Override
    public boolean cancel() {
        super.cancel();
        try {
            this.closeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            U.error(this.log, "SnapshotFutureTask cancellation failed", e);
            return false;
        }
        return true;
    }

    protected abstract CompletableFuture<Void> closeAsync();

    protected boolean stopping() {
        return this.err.get() != null;
    }

    protected void processPartitions() throws IgniteCheckedException {
        for (Map.Entry e : this.parts.entrySet()) {
            boolean affNode;
            Iterator<GridDhtLocalPartition> iter;
            int grpId = (Integer)e.getKey();
            Set grpParts = (Set)e.getValue();
            CacheGroupContext gctx = this.cctx.cache().cacheGroup(grpId);
            if (grpParts == null) {
                iter = gctx.topology().currentLocalPartitions().iterator();
            } else {
                if (grpParts.contains(65535)) {
                    throw new IgniteCheckedException("Index partition cannot be included into snapshot if  set of cache group partitions has been explicitly provided [grpId=" + grpId + ']');
                }
                iter = F.iterator(grpParts, gctx.topology()::localPartition, false, new IgnitePredicate[0]);
            }
            HashSet<Integer> owning = new HashSet<Integer>();
            HashSet<Integer> missed = new HashSet<Integer>();
            while (iter.hasNext()) {
                GridDhtLocalPartition part = iter.next();
                if (part.state() == GridDhtPartitionState.OWNING) {
                    owning.add(part.id());
                    continue;
                }
                missed.add(part.id());
            }
            boolean bl = affNode = gctx.nodeFilter() == null || gctx.nodeFilter().apply(this.cctx.localNode());
            if (grpParts != null) {
                if (!missed.isEmpty()) {
                    throw new IgniteCheckedException("Snapshot operation cancelled due to not all of requested partitions has OWNING state on local node [grpId=" + grpId + ", missed=" + S.toStringSortedDistinct(missed) + ']');
                }
            } else if (!missed.isEmpty()) {
                this.log.warning("All local cache group partitions in OWNING state have been included into a snapshot. Partitions which have different states skipped. Index partitions has also been skipped [snpName=" + this.snpName + ", grpId=" + grpId + ", missed=" + S.toStringSortedDistinct(missed) + ']');
            } else if (affNode && missed.isEmpty() && this.cctx.kernalContext().query().moduleEnabled()) {
                owning.add(65535);
            }
            this.processed.put(grpId, owning);
        }
    }

    protected void saveSnapshotData() {
        try {
            ArrayList<CompletableFuture<Void>> futs = new ArrayList<CompletableFuture<Void>>();
            Collection<BinaryType> binTypesCopy = this.cctx.kernalContext().cacheObjects().metadata();
            ArrayList<Map<Integer, MappedName>> mappingsCopy = this.cctx.kernalContext().marshallerContext().getCachedMappings();
            futs.add(this.runAsync(() -> this.snpSndr.sendBinaryMeta(binTypesCopy)));
            futs.add(this.runAsync(() -> this.snpSndr.sendMarshallerMeta(mappingsCopy)));
            futs.addAll(this.saveCacheConfigs());
            for (Map.Entry<Integer, Set<Integer>> grpParts : this.processed.entrySet()) {
                futs.addAll(this.saveGroup(grpParts.getKey(), grpParts.getValue()));
            }
            int futsSize = futs.size();
            CompletableFuture.allOf(futs.toArray(new CompletableFuture[futsSize])).whenComplete((res, t) -> {
                assert (t == null) : "Exception must never be thrown since a wrapper is used for each snapshot task: " + t;
                this.closeAsync();
            });
        }
        catch (IgniteCheckedException e) {
            this.acceptException(e);
        }
    }

    @Override
    public void acceptException(Throwable th) {
        if (th == null) {
            return;
        }
        if (!(th instanceof IgniteFutureCancelledCheckedException)) {
            U.error(this.log, "Snapshot task has accepted exception to stop", th);
        }
        if (this.err.compareAndSet(null, th)) {
            this.closeAsync();
        }
    }

    Runnable wrapExceptionIfStarted(IgniteThrowableRunner exec) {
        return () -> {
            if (this.stopping()) {
                return;
            }
            try {
                exec.run();
            }
            catch (Throwable t) {
                this.acceptException(t);
            }
        };
    }

    protected CompletableFuture<Void> runAsync(IgniteThrowableRunner task) {
        return CompletableFuture.runAsync(this.wrapExceptionIfStarted(task), this.snpSndr.executor());
    }
}

