/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheRawVersionedEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class MvccTxEntry {
    private KeyCacheObject key;
    private CacheObject val;
    private int cacheId;
    private GridCacheVersion ver;
    private CacheObject oldVal;
    private boolean primary;
    private AffinityTopologyVersion topVer;
    private MvccVersion mvccVer;
    private long ttl;
    private long expireTime;
    private long updCntr;

    public MvccTxEntry(KeyCacheObject key, @Nullable CacheObject val, long ttl, long expireTime, GridCacheVersion ver, CacheObject oldVal, boolean primary, AffinityTopologyVersion topVer, MvccVersion mvccVer, int cacheId) {
        assert (key != null);
        assert (mvccVer != null);
        this.key = key;
        this.val = val;
        this.ttl = ttl;
        this.expireTime = expireTime;
        this.ver = ver;
        this.oldVal = oldVal;
        this.primary = primary;
        this.topVer = topVer;
        this.mvccVer = mvccVer;
        this.cacheId = cacheId;
    }

    public GridCacheRawVersionedEntry versionedEntry() {
        return new GridCacheRawVersionedEntry(this.key, this.val, this.ttl, this.expireTime, this.ver);
    }

    public KeyCacheObject key() {
        return this.key;
    }

    public CacheObject value() {
        return this.val;
    }

    public long ttl() {
        return this.ttl;
    }

    public long expireTime() {
        return this.expireTime;
    }

    public GridCacheVersion version() {
        return this.ver;
    }

    public CacheObject oldValue() {
        return this.oldVal;
    }

    public void oldValue(CacheObject oldVal) {
        this.oldVal = oldVal;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public MvccVersion mvccVersion() {
        return this.mvccVer;
    }

    public int cacheId() {
        return this.cacheId;
    }

    public long updateCounter() {
        return this.updCntr;
    }

    public void updateCounter(long updCntr) {
        this.updCntr = updCntr;
    }

    public String toString() {
        return S.toString(MvccTxEntry.class, this);
    }
}

