/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.bulkload.pipeline;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.bulkload.pipeline.PipelineBlock;

public class LineSplitterBlock
extends PipelineBlock<char[], String> {
    private final Pattern delim;
    private StringBuilder leftover = new StringBuilder();

    public LineSplitterBlock(Pattern delim) {
        this.delim = delim;
    }

    @Override
    public void accept(char[] chars, boolean isLastPortion) throws IgniteCheckedException {
        this.leftover.append(chars);
        String input = this.leftover.toString();
        Matcher matcher = this.delim.matcher(input);
        int lastPos = 0;
        while (matcher.find()) {
            String outStr = input.substring(lastPos, matcher.start());
            if (!outStr.isEmpty()) {
                this.nextBlock.accept(outStr, false);
            }
            lastPos = matcher.end();
        }
        if (lastPos != 0) {
            this.leftover.delete(0, lastPos);
        }
        if (isLastPortion && this.leftover.length() > 0) {
            this.nextBlock.accept(this.leftover.toString(), true);
            this.leftover.setLength(0);
        }
    }
}

