/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.encryption;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteEncryption;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.encryption.CacheGroupEncryptionKeys;
import org.apache.ignite.internal.managers.encryption.CacheGroupPageScanner;
import org.apache.ignite.internal.managers.encryption.EncryptionCacheKeyProvider;
import org.apache.ignite.internal.managers.encryption.GenerateEncryptionKeyRequest;
import org.apache.ignite.internal.managers.encryption.GenerateEncryptionKeyResponse;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.managers.encryption.GroupKeyChangeProcess;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.managers.encryption.ReencryptStateUtils;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.pagemem.wal.record.MasterKeyChangeRecordV2;
import org.apache.ignite.internal.pagemem.wal.record.ReencryptionStartRecord;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.util.distributed.DistributedProcess;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteFutureCancelledException;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.jetbrains.annotations.Nullable;

public class GridEncryptionManager
extends GridManagerAdapter<EncryptionSpi>
implements EncryptionCacheKeyProvider,
MetastorageLifecycleListener,
IgniteChangeGlobalStateSupport,
IgniteEncryption,
PartitionsExchangeAware {
    private static final IgniteProductVersion CACHE_ENCRYPTION_SINCE = IgniteProductVersion.fromString("2.7.0");
    public static final String MASTER_KEY_NAME_PREFIX = "encryption-master-key-name";
    public static final String ENCRYPTION_KEYS_PREFIX = "grp-encryption-keys-";
    public static final int INITIAL_KEY_ID = 0;
    private static final String REENCRYPTED_WAL_SEGMENTS = "reencrypted-wal-segments";
    @Deprecated
    private static final String ENCRYPTION_KEY_PREFIX = "grp-encryption-key-";
    private final Object metaStorageMux = new Object();
    private final Object opsMux = new Object();
    private final ReentrantReadWriteLock masterKeyChangeLock = new ReentrantReadWriteLock();
    private volatile boolean disconnected;
    private volatile boolean stopped;
    private volatile boolean writeToMetaStoreEnabled;
    private CacheGroupEncryptionKeys grpKeys;
    private ConcurrentMap<IgniteUuid, GenerateEncryptionKeyFuture> genEncKeyFuts = new ConcurrentHashMap<IgniteUuid, GenerateEncryptionKeyFuture>();
    private volatile ReadWriteMetastorage metaStorage;
    private GridMessageListener ioLsnr;
    private DiscoveryEventListener discoLsnr;
    private volatile boolean restoredFromWAL;
    private volatile boolean recoveryMasterKeyName;
    private KeyChangeFuture masterKeyChangeFut;
    private volatile MasterKeyChangeRequest masterKeyChangeRequest;
    private volatile byte[] masterKeyDigest;
    private DistributedProcess<MasterKeyChangeRequest, EmptyResult> prepareMKChangeProc;
    private DistributedProcess<MasterKeyChangeRequest, EmptyResult> performMKChangeProc;
    private GroupKeyChangeProcess grpKeyChangeProc;
    private final Map<Integer, long[]> reencryptGroups = new ConcurrentHashMap<Integer, long[]>();
    private final Map<Integer, Integer> reencryptGroupsForced = new ConcurrentHashMap<Integer, Integer>();
    private CacheGroupPageScanner pageScanner;

    public GridEncryptionManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])new EncryptionSpi[]{ctx.config().getEncryptionSpi()});
        ctx.internalSubscriptionProcessor().registerMetastorageListener(this);
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.startSpi();
        this.discoLsnr = (evt, discoCache) -> {
            UUID leftNodeId = evt.eventNode().id();
            Object object = this.opsMux;
            synchronized (object) {
                Iterator futsIter = this.genEncKeyFuts.entrySet().iterator();
                while (futsIter.hasNext()) {
                    GenerateEncryptionKeyFuture fut = (GenerateEncryptionKeyFuture)futsIter.next().getValue();
                    if (!F.eq(leftNodeId, fut.nodeId())) {
                        return;
                    }
                    try {
                        futsIter.remove();
                        this.sendGenerateEncryptionKeyRequest(fut);
                        this.genEncKeyFuts.put(fut.id(), fut);
                    }
                    catch (IgniteCheckedException e) {
                        fut.onDone(null, (Throwable)e);
                    }
                }
            }
        };
        this.ctx.event().addDiscoveryEventListener(this.discoLsnr, 11, 12);
        this.ioLsnr = (nodeId, msg, plc) -> {
            Object object = this.opsMux;
            synchronized (object) {
                if (msg instanceof GenerateEncryptionKeyRequest) {
                    GenerateEncryptionKeyRequest req = (GenerateEncryptionKeyRequest)msg;
                    assert (req.keyCount() != 0);
                    ArrayList<byte[]> encKeys = new ArrayList<byte[]>(req.keyCount());
                    byte[] masterKeyDigest = this.withMasterKeyChangeReadLock(() -> {
                        for (int i = 0; i < req.keyCount(); ++i) {
                            encKeys.add(((EncryptionSpi)this.getSpi()).encryptKey(((EncryptionSpi)this.getSpi()).create()));
                        }
                        return ((EncryptionSpi)this.getSpi()).masterKeyDigest();
                    });
                    try {
                        this.ctx.io().sendToGridTopic(nodeId, GridTopic.TOPIC_GEN_ENC_KEY, (Message)new GenerateEncryptionKeyResponse(req.id(), encKeys, masterKeyDigest), (byte)2);
                    }
                    catch (IgniteCheckedException e) {
                        U.error(this.log, "Unable to send generate key response[nodeId=" + nodeId + "]");
                    }
                } else {
                    GenerateEncryptionKeyResponse resp = (GenerateEncryptionKeyResponse)msg;
                    GenerateEncryptionKeyFuture fut = (GenerateEncryptionKeyFuture)this.genEncKeyFuts.get(resp.requestId());
                    if (fut != null) {
                        fut.onDone(new T2<Collection<byte[]>, byte[]>(resp.encryptionKeys(), resp.masterKeyDigest()), (Throwable)null);
                    } else {
                        U.warn(this.log, "Response received for a unknown request.[reqId=" + resp.requestId() + "]");
                    }
                }
            }
        };
        this.ctx.io().addMessageListener(GridTopic.TOPIC_GEN_ENC_KEY, this.ioLsnr);
        this.prepareMKChangeProc = new DistributedProcess(this.ctx, DistributedProcess.DistributedProcessType.MASTER_KEY_CHANGE_PREPARE, this::prepareMasterKeyChange, this::finishPrepareMasterKeyChange);
        this.performMKChangeProc = new DistributedProcess(this.ctx, DistributedProcess.DistributedProcessType.MASTER_KEY_CHANGE_FINISH, this::performMasterKeyChange, this::finishPerformMasterKeyChange);
        this.grpKeys = new CacheGroupEncryptionKeys((EncryptionSpi)this.getSpi());
        this.pageScanner = new CacheGroupPageScanner(this.ctx);
        this.grpKeyChangeProc = new GroupKeyChangeProcess(this.ctx, this.grpKeys);
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.stopSpi();
        this.pageScanner.stop();
    }

    @Override
    protected void onKernalStart0() {
        this.ctx.cache().context().exchange().registerExchangeAwareComponent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onKernalStop0(boolean cancel) {
        Object object = this.opsMux;
        synchronized (object) {
            this.stopped = true;
            if (this.ioLsnr != null) {
                this.ctx.io().removeMessageListener(GridTopic.TOPIC_GEN_ENC_KEY, this.ioLsnr);
            }
            if (this.discoLsnr != null) {
                this.ctx.event().removeDiscoveryEventListener(this.discoLsnr, 11, 12);
            }
            this.cancelFutures("Kernal stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        Object object = this.opsMux;
        synchronized (object) {
            assert (!this.disconnected);
            this.disconnected = true;
            this.masterKeyChangeRequest = null;
            this.masterKeyDigest = null;
            this.cancelFutures("Client node was disconnected from topology (operation result is unknown).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) {
        Object object = this.opsMux;
        synchronized (object) {
            assert (this.disconnected);
            this.disconnected = false;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLocalJoin() {
        if (!U.isLocalNodeCoordinator(this.ctx.discovery())) {
            return;
        }
        Object object = this.metaStorageMux;
        synchronized (object) {
            HashMap<Integer, GroupKeyEncrypted> knownEncKeys = this.grpKeys.getAll();
            HashMap<Integer, byte[]> newEncKeys = this.newEncryptionKeys(knownEncKeys == null ? Collections.EMPTY_SET : knownEncKeys.keySet());
            if (newEncKeys == null) {
                return;
            }
            for (Map.Entry<Integer, byte[]> entry : newEncKeys.entrySet()) {
                this.addGroupKey(entry.getKey(), new GroupKeyEncrypted(0, entry.getValue()));
                U.quietAndInfo(this.log, "Added encryption key on local join [grpId=" + entry.getKey() + "]");
            }
        }
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag.JoiningNodeDiscoveryData discoData) {
        IgniteNodeValidationResult res = super.validateNode(node, discoData);
        if (res != null) {
            return res;
        }
        if (this.isMasterKeyChangeInProgress()) {
            return new IgniteNodeValidationResult(this.ctx.localNodeId(), "Master key change is in progress! Node join is rejected. [node=" + node.id() + "]", "Master key change is in progress! Node join is rejected.");
        }
        if (node.isClient()) {
            return null;
        }
        res = this.validateNode(node);
        if (res != null) {
            return res;
        }
        if (this.grpKeyChangeProc.inProgress()) {
            return new IgniteNodeValidationResult(this.ctx.localNodeId(), "Cache group key change is in progress! Node join is rejected. [node=" + node.id() + "]", "Cache group key change is in progress! Node join is rejected.");
        }
        NodeEncryptionKeys nodeEncKeys = (NodeEncryptionKeys)discoData.joiningNodeData();
        if (!discoData.hasJoiningNodeData() || nodeEncKeys == null) {
            return new IgniteNodeValidationResult(this.ctx.localNodeId(), "Joining node doesn't have encryption data [node=" + node.id() + "]", "Joining node doesn't have encryption data.");
        }
        if (!Arrays.equals(((EncryptionSpi)this.getSpi()).masterKeyDigest(), nodeEncKeys.masterKeyDigest)) {
            return new IgniteNodeValidationResult(this.ctx.localNodeId(), "Master key digest differs! Node join is rejected. [node=" + node.id() + "]", "Master key digest differs! Node join is rejected.");
        }
        if (!IgniteFeatures.nodeSupports(node, IgniteFeatures.CACHE_GROUP_KEY_CHANGE)) {
            return new IgniteNodeValidationResult(this.ctx.localNodeId(), "Joining node doesn't support multiple encryption keys for single group [node=" + node.id() + "]", "Joining node doesn't support multiple encryption keys for single group.");
        }
        if (F.isEmpty(nodeEncKeys.knownKeys)) {
            U.quietAndInfo(this.log, "Joining node doesn't have stored group keys [node=" + node.id() + "]");
            return null;
        }
        assert (!F.isEmpty(nodeEncKeys.knownKeysWithIds));
        for (Map.Entry<Integer, List<GroupKeyEncrypted>> entry : nodeEncKeys.knownKeysWithIds.entrySet()) {
            List<GroupKeyEncrypted> rmtKeys;
            int grpId = entry.getKey();
            GroupKey locEncKey = this.getActiveKey(grpId);
            if (locEncKey == null || (rmtKeys = entry.getValue()) == null) continue;
            GroupKeyEncrypted rmtKeyEncrypted = null;
            for (GroupKeyEncrypted rmtKey0 : rmtKeys) {
                if (rmtKey0.id() != locEncKey.unsignedId()) continue;
                rmtKeyEncrypted = rmtKey0;
                break;
            }
            if (rmtKeyEncrypted == null || F.eq(locEncKey.key(), ((EncryptionSpi)this.getSpi()).decryptKey(rmtKeyEncrypted.key()))) continue;
            return new IgniteNodeValidationResult(this.ctx.localNodeId(), "Cache key differs! Node join is rejected. [node=" + node.id() + ", grp=" + entry.getKey() + "]", "Cache key differs! Node join is rejected.");
        }
        return null;
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        if (this.ctx.clientNode()) {
            return;
        }
        Set<Integer> grpIds = this.grpKeys.groupIds();
        HashMap<Integer, List<GroupKeyEncrypted>> knownEncKeys = U.newHashMap(grpIds.size());
        for (int grpId : grpIds) {
            knownEncKeys.put(grpId, this.grpKeys.getAll(grpId));
        }
        HashMap<Integer, byte[]> newKeys = this.newEncryptionKeys(grpIds);
        if (this.log.isInfoEnabled()) {
            String newGrps;
            String knownGrps;
            String string = knownGrps = F.isEmpty(knownEncKeys) ? null : F.concat(knownEncKeys.keySet(), ",");
            if (knownGrps != null) {
                U.quietAndInfo(this.log, "Sending stored group keys to coordinator [grps=" + knownGrps + "]");
            }
            String string2 = newGrps = F.isEmpty(newKeys) ? null : F.concat(newKeys.keySet(), ",");
            if (newGrps != null) {
                U.quietAndInfo(this.log, "Sending new group keys to coordinator [grps=" + newGrps + "]");
            }
        }
        dataBag.addJoiningNodeData(GridComponent.DiscoveryDataExchangeType.ENCRYPTION_MGR.ordinal(), new NodeEncryptionKeys(knownEncKeys, newKeys, ((EncryptionSpi)this.getSpi()).masterKeyDigest()));
    }

    @Override
    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        NodeEncryptionKeys nodeEncryptionKeys = (NodeEncryptionKeys)data.joiningNodeData();
        if (nodeEncryptionKeys == null || nodeEncryptionKeys.newKeys == null || this.ctx.clientNode()) {
            return;
        }
        for (Map.Entry<Integer, byte[]> entry : nodeEncryptionKeys.newKeys.entrySet()) {
            if (this.getActiveKey(entry.getKey()) == null) {
                U.quietAndInfo(this.log, "Store group key received from joining node [node=" + data.joiningNodeId() + ", grp=" + entry.getKey() + "]");
                this.addGroupKey(entry.getKey(), new GroupKeyEncrypted(0, entry.getValue()));
                continue;
            }
            U.quietAndInfo(this.log, "Skip group key received from joining node. Already exists. [node=" + data.joiningNodeId() + ", grp=" + entry.getKey() + "]");
        }
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        if (dataBag.isJoiningNodeClient() || dataBag.commonDataCollectedFor(GridComponent.DiscoveryDataExchangeType.ENCRYPTION_MGR.ordinal())) {
            return;
        }
        HashMap<Integer, GroupKeyEncrypted> knownEncKeys = this.grpKeys.getAll();
        HashMap<Integer, byte[]> newKeys = this.newEncryptionKeys(knownEncKeys == null ? Collections.EMPTY_SET : knownEncKeys.keySet());
        if (!F.isEmpty(newKeys)) {
            if (knownEncKeys == null) {
                knownEncKeys = new HashMap();
            }
            for (Map.Entry<Integer, byte[]> entry : newKeys.entrySet()) {
                GroupKeyEncrypted old = knownEncKeys.putIfAbsent(entry.getKey(), new GroupKeyEncrypted(0, entry.getValue()));
                assert (old == null);
            }
        }
        dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.ENCRYPTION_MGR.ordinal(), knownEncKeys);
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        if (this.ctx.clientNode()) {
            return;
        }
        Map encKeysFromCluster = (Map)((Object)data.commonData());
        if (F.isEmpty(encKeysFromCluster)) {
            return;
        }
        for (Map.Entry entry : encKeysFromCluster.entrySet()) {
            int grpId = (Integer)entry.getKey();
            GroupKeyEncrypted rmtKey = entry.getValue() instanceof GroupKeyEncrypted ? (GroupKeyEncrypted)entry.getValue() : new GroupKeyEncrypted(0, (byte[])entry.getValue());
            GroupKey locGrpKey = this.getActiveKey(grpId);
            if (locGrpKey != null && locGrpKey.unsignedId() == rmtKey.id()) {
                U.quietAndInfo(this.log, "Skip group key received from coordinator. Already exists. [grp=" + grpId + ", keyId=" + rmtKey.id() + "]");
                continue;
            }
            U.quietAndInfo(this.log, "Store group key received from coordinator [grp=" + grpId + ", keyId=" + rmtKey.id() + "]");
            this.grpKeys.addKey(grpId, rmtKey);
            if (locGrpKey == null) continue;
            GroupKey prevKey = this.grpKeys.changeActiveKey(grpId, rmtKey.id());
            if (this.ctx.config().getDataStorageConfiguration().getWalMode() != WALMode.NONE) {
                this.grpKeys.reserveWalKey(grpId, prevKey.unsignedId(), this.ctx.cache().context().wal().currentSegment());
            }
            this.reencryptGroupsForced.put(grpId, rmtKey.id());
        }
    }

    @Override
    @Nullable
    public GroupKey getActiveKey(int grpId) {
        return this.grpKeys.getActiveKey(grpId);
    }

    @Override
    @Nullable
    public GroupKey groupKey(int grpId, int keyId) {
        return this.grpKeys.getKey(grpId, keyId);
    }

    @Nullable
    public List<Integer> groupKeyIds(int grpId) {
        return this.grpKeys.keyIds(grpId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addGroupKey(int grpId, GroupKeyEncrypted key) {
        Object object = this.metaStorageMux;
        synchronized (object) {
            try {
                this.grpKeys.addKey(grpId, key);
                this.writeGroupKeysToMetaStore(grpId, this.grpKeys.getAll(grpId));
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to write cache group encryption key [grpId=" + grpId + ']', e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> changeMasterKey(String masterKeyName) {
        byte[] digest;
        if (this.ctx.clientNode()) {
            return new IgniteFinishedFutureImpl<Void>(new UnsupportedOperationException("Client nodes can not perform this operation."));
        }
        if (!IgniteFeatures.allNodesSupports(this.ctx.grid().cluster().nodes(), IgniteFeatures.MASTER_KEY_CHANGE)) {
            return new IgniteFinishedFutureImpl<Void>(new IllegalStateException("Not all nodes in the cluster support the master key change process."));
        }
        if (!this.ctx.state().clusterState().state().active()) {
            return new IgniteFinishedFutureImpl<Void>(new IgniteException("Master key change was rejected. The cluster is inactive."));
        }
        if (masterKeyName.equals(this.getMasterKeyName())) {
            return new IgniteFinishedFutureImpl<Void>(new IgniteException("Master key change was rejected. New name equal to the current."));
        }
        try {
            digest = this.masterKeyDigest(masterKeyName);
        }
        catch (Exception e) {
            return new IgniteFinishedFutureImpl<Void>(new IgniteException("Master key change was rejected. Unable to get the master key digest.", e));
        }
        MasterKeyChangeRequest request = new MasterKeyChangeRequest(UUID.randomUUID(), this.encryptKeyName(masterKeyName), digest);
        Object object = this.opsMux;
        synchronized (object) {
            if (this.disconnected) {
                return new IgniteFinishedFutureImpl<Void>(new IgniteClientDisconnectedException(this.ctx.cluster().clientReconnectFuture(), "Master key change was rejected. Client node disconnected."));
            }
            if (this.stopped) {
                return new IgniteFinishedFutureImpl<Void>(new IgniteException("Master key change was rejected. Node is stopping."));
            }
            if (this.masterKeyChangeFut != null && !this.masterKeyChangeFut.isDone()) {
                return new IgniteFinishedFutureImpl<Void>(new IgniteException("Master key change was rejected. The previous change was not completed."));
            }
            this.masterKeyChangeFut = new KeyChangeFuture(request.requestId());
            this.prepareMKChangeProc.start(request.requestId(), request);
            return new IgniteFutureImpl<Void>(this.masterKeyChangeFut);
        }
    }

    @Override
    public String getMasterKeyName() {
        if (this.ctx.clientNode()) {
            throw new UnsupportedOperationException("Client nodes can not perform this operation.");
        }
        return this.withMasterKeyChangeReadLock(() -> ((EncryptionSpi)this.getSpi()).getMasterKeyName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> changeCacheGroupKey(Collection<String> cacheOrGrpNames) {
        A.notEmpty(cacheOrGrpNames, "cacheOrGrpNames");
        Object object = this.opsMux;
        synchronized (object) {
            if (this.stopped) {
                return new IgniteFinishedFutureImpl<Void>(new IgniteException("Cache group key change was rejected. Node is stopping."));
            }
            return this.grpKeyChangeProc.start(cacheOrGrpNames);
        }
    }

    protected void changeCacheGroupKeyLocal(int[] grpIds, byte[] keyIds, byte[][] keys) throws IgniteCheckedException {
        HashMap<Integer, Byte> encryptionStatus = U.newHashMap(grpIds.length);
        for (int i = 0; i < grpIds.length; ++i) {
            encryptionStatus.put(grpIds[i], keyIds[i]);
        }
        WALPointer ptr = this.ctx.cache().context().wal().log(new ReencryptionStartRecord(encryptionStatus));
        if (ptr != null) {
            this.ctx.cache().context().wal().flush(ptr, false);
        }
        for (int i = 0; i < grpIds.length; ++i) {
            int grpId = grpIds[i];
            int newKeyId = keyIds[i] & 0xFF;
            this.withMasterKeyChangeReadLock(() -> {
                Object object = this.metaStorageMux;
                synchronized (object) {
                    GroupKey prevGrpKey = this.grpKeys.changeActiveKey(grpId, newKeyId);
                    this.writeGroupKeysToMetaStore(grpId, this.grpKeys.getAll(grpId));
                    if (ptr == null) {
                        return null;
                    }
                    this.grpKeys.reserveWalKey(grpId, prevGrpKey.unsignedId(), this.ctx.cache().context().wal().currentSegment());
                    this.writeTrackedWalIdxsToMetaStore();
                }
                return null;
            });
            CacheGroupContext grp = this.ctx.cache().cacheGroup(grpId);
            if (grp != null && grp.affinityNode()) {
                this.reencryptGroups.put(grpId, this.pageScanner.pagesCount(grp));
            }
            if (!this.log.isInfoEnabled()) continue;
            this.log.info("New encryption key for group was added [grpId=" + grpId + ", keyId=" + newKeyId + ']');
        }
        this.startReencryption(encryptionStatus.keySet());
    }

    public IgniteInternalFuture<Void> reencryptionFuture(int grpId) {
        return this.pageScanner.statusFuture(grpId);
    }

    public boolean reencryptionInProgress(int grpId) {
        return this.reencryptGroups.containsKey(grpId);
    }

    public boolean reencryptionInProgress() {
        return this.grpKeyChangeProc.inProgress() || !this.reencryptGroups.isEmpty();
    }

    public double getReencryptionRate() {
        return this.pageScanner.getRate();
    }

    public void setReencryptionRate(double rate) {
        this.pageScanner.setRate(rate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeGroupKey(int grpId) {
        Object object = this.metaStorageMux;
        synchronized (object) {
            this.ctx.cache().context().database().checkpointReadLock();
            try {
                if (this.grpKeys.remove(grpId) == null) {
                    return;
                }
                this.metaStorage.remove(ENCRYPTION_KEYS_PREFIX + grpId);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Key(s) removed. [grp=" + grpId + "]");
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to clear meta storage", e);
            }
            finally {
                this.ctx.cache().context().database().checkpointReadUnlock();
            }
        }
    }

    public void setInitialGroupKey(int grpId, @Nullable byte[] encKey, @Nullable Integer encKeyId) {
        if (encKey == null || this.ctx.clientNode()) {
            return;
        }
        this.removeGroupKey(grpId);
        this.withMasterKeyChangeReadLock(() -> {
            this.addGroupKey(grpId, new GroupKeyEncrypted(encKeyId == null ? 0 : encKeyId, encKey));
            return null;
        });
    }

    public void onCacheGroupStop(int grpId) {
        try {
            this.reencryptionFuture(grpId).cancel();
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Unable to cancel reencryption [grpId=" + grpId + "]", e);
        }
        this.reencryptGroups.remove(grpId);
    }

    public void onCacheGroupDestroyed(int grpId) {
        if (this.getActiveKey(grpId) == null) {
            return;
        }
        this.removeGroupKey(grpId);
    }

    public void onDestroyPartitionStore(CacheGroupContext grp, int partId) {
        if (this.pageScanner.excludePartition(grp.groupId(), partId)) {
            this.setEncryptionState(grp, partId, 0, 0);
        }
    }

    public void onCancelDestroyPartitionStore(CacheGroupContext grp, int partId) {
        this.pageScanner.includePartition(grp.groupId(), partId);
    }

    public void onWalSegmentRemoved(long segmentIdx) {
        if (this.grpKeys.isReleaseWalKeysRequired(segmentIdx)) {
            this.ctx.pools().getSystemExecutorService().submit(() -> this.releaseWalKeys(segmentIdx));
        }
    }

    private void releaseWalKeys(long segmentIdx) {
        this.withMasterKeyChangeReadLock(() -> {
            Object object = this.metaStorageMux;
            synchronized (object) {
                Map<Integer, Set<Integer>> rmvKeys = this.grpKeys.releaseWalKeys(segmentIdx);
                if (F.isEmpty(rmvKeys)) {
                    return null;
                }
                try {
                    this.writeTrackedWalIdxsToMetaStore();
                    for (Map.Entry<Integer, Set<Integer>> entry : rmvKeys.entrySet()) {
                        Integer grpId = entry.getKey();
                        if (this.reencryptGroups.containsKey(grpId)) continue;
                        Set<Integer> keyIds = entry.getValue();
                        if (!this.grpKeys.removeKeysById(grpId, keyIds)) continue;
                        this.writeGroupKeysToMetaStore(grpId, this.grpKeys.getAll(grpId));
                        if (!this.log.isInfoEnabled()) continue;
                        this.log.info("Previous encryption keys have been removed [grpId=" + grpId + ", keyIds=" + keyIds + ']');
                    }
                }
                catch (IgniteCheckedException e) {
                    this.log.error("Unable to remove encryption keys from metastore.", e);
                }
            }
            return null;
        });
    }

    @Override
    public void onReadyForRead(ReadOnlyMetastorage metastorage) {
        try {
            Serializable savedSegments;
            String masterKeyName;
            if (!this.restoredFromWAL && (masterKeyName = (String)((Object)metastorage.read(MASTER_KEY_NAME_PREFIX))) != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Master key name loaded from metastrore [masterKeyName=" + masterKeyName + ']');
                }
                ((EncryptionSpi)this.getSpi()).setMasterKeyName(masterKeyName);
            }
            metastorage.iterate(ENCRYPTION_KEYS_PREFIX, (key, val) -> {
                int grpId = Integer.parseInt(key.replace(ENCRYPTION_KEYS_PREFIX, ""));
                if (this.grpKeys.groupIds().contains(grpId)) {
                    return;
                }
                this.grpKeys.setGroupKeys(grpId, (List)((Object)val));
            }, true);
            if (this.grpKeys.groupIds().isEmpty()) {
                metastorage.iterate(ENCRYPTION_KEY_PREFIX, (key, val) -> {
                    int grpId = Integer.parseInt(key.replace(ENCRYPTION_KEY_PREFIX, ""));
                    GroupKeyEncrypted grpKey = new GroupKeyEncrypted(0, (byte[])val);
                    this.grpKeys.setGroupKeys(grpId, Collections.singletonList(grpKey));
                }, true);
            }
            if ((savedSegments = metastorage.read(REENCRYPTED_WAL_SEGMENTS)) != null) {
                this.grpKeys.trackedWalSegments((Collection)((Object)savedSegments));
            }
            if (this.grpKeys.groupIds().isEmpty()) {
                U.quietAndInfo(this.log, "Encryption keys loaded from metastore. [grps=" + F.concat(this.grpKeys.groupIds(), ",") + ", masterKeyName=" + ((EncryptionSpi)this.getSpi()).getMasterKeyName() + ']');
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to read encryption keys state.", e);
        }
        String newMasterKeyName = IgniteSystemProperties.getString("IGNITE_MASTER_KEY_NAME_TO_CHANGE_BEFORE_STARTUP");
        if (newMasterKeyName != null) {
            if (newMasterKeyName.equals(((EncryptionSpi)this.getSpi()).getMasterKeyName())) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Restored master key name equals to name from system property IGNITE_MASTER_KEY_NAME_TO_CHANGE_BEFORE_STARTUP. This system property will be ignored and recommended to remove [masterKeyName=" + newMasterKeyName + ']');
                }
                return;
            }
            this.recoveryMasterKeyName = true;
            if (this.log.isInfoEnabled()) {
                this.log.info("System property IGNITE_MASTER_KEY_NAME_TO_CHANGE_BEFORE_STARTUP is set. Master key will be changed locally and group keys will be re-encrypted before join to cluster. Result will be saved to MetaStore on activation process. [masterKeyName=" + newMasterKeyName + ']');
            }
            ((EncryptionSpi)this.getSpi()).setMasterKeyName(newMasterKeyName);
        }
    }

    @Override
    public void onReadyForReadWrite(ReadWriteMetastorage metaStorage) throws IgniteCheckedException {
        this.withMasterKeyChangeReadLock(() -> {
            Object object = this.metaStorageMux;
            synchronized (object) {
                this.metaStorage = metaStorage;
                this.writeToMetaStoreEnabled = true;
                if (this.recoveryMasterKeyName) {
                    this.writeKeysToWal();
                }
                this.writeKeysToMetaStore(this.restoredFromWAL || this.recoveryMasterKeyName);
                this.restoredFromWAL = false;
                this.recoveryMasterKeyName = false;
            }
            return null;
        });
        for (Map.Entry<Integer, Integer> entry : this.reencryptGroupsForced.entrySet()) {
            CacheGroupContext grp;
            int grpId = entry.getKey();
            if (this.reencryptGroups.containsKey(grpId) || entry.getValue().intValue() != this.getActiveKey(grpId).unsignedId() || (grp = this.ctx.cache().cacheGroup(grpId)) == null || !grp.affinityNode()) continue;
            long[] offsets = this.pageScanner.pagesCount(grp);
            this.reencryptGroups.put(grpId, offsets);
        }
        this.reencryptGroupsForced.clear();
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        this.withMasterKeyChangeReadLock(() -> {
            Object object = this.metaStorageMux;
            synchronized (object) {
                boolean bl = this.writeToMetaStoreEnabled = this.metaStorage != null;
                if (this.writeToMetaStoreEnabled) {
                    this.writeKeysToMetaStore(false);
                }
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeActivate(GridKernalContext kctx) {
        Object object = this.metaStorageMux;
        synchronized (object) {
            this.writeToMetaStoreEnabled = false;
        }
    }

    @Override
    public void onDoneAfterTopologyUnlock(GridDhtPartitionsExchangeFuture fut) {
        if (fut.activateCluster() || fut.localJoinExchange()) {
            try {
                this.startReencryption(this.reencryptGroups.keySet());
            }
            catch (IgniteCheckedException e) {
                this.log.error("Unable to start reencryption", e);
            }
        }
    }

    public void setEncryptionState(CacheGroupContext grp, int partId, int idx, int total) {
        long[] states = this.reencryptGroups.computeIfAbsent(grp.groupId(), v -> new long[grp.affinity().partitions() + 1]);
        states[Math.min((int)partId, (int)(states.length - 1))] = ReencryptStateUtils.state(idx, total);
    }

    public long getEncryptionState(int grpId, int partId) {
        long[] states = this.reencryptGroups.get(grpId);
        if (states == null) {
            return 0L;
        }
        return states[Math.min(partId, states.length - 1)];
    }

    public long getBytesLeftForReencryption(int grpId) {
        return this.pageScanner.remainingPagesCount(grpId) * (long)this.ctx.config().getDataStorageConfiguration().getPageSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<T2<Collection<byte[]>, byte[]>> generateKeys(int keyCnt) {
        if (keyCnt == 0 || !this.ctx.clientNode()) {
            return new GridFinishedFuture<T2<Collection<byte[]>, byte[]>>(this.createKeys(keyCnt));
        }
        Object object = this.opsMux;
        synchronized (object) {
            if (this.disconnected || this.stopped) {
                return new GridFinishedFuture<T2<Collection<byte[]>, byte[]>>(new IgniteFutureCancelledException("Node " + (this.stopped ? "stopped" : "disconnected")));
            }
            try {
                GenerateEncryptionKeyFuture genEncKeyFut = new GenerateEncryptionKeyFuture(keyCnt);
                this.sendGenerateEncryptionKeyRequest(genEncKeyFut);
                this.genEncKeyFuts.put(genEncKeyFut.id(), genEncKeyFut);
                return genEncKeyFut;
            }
            catch (IgniteCheckedException e) {
                return new GridFinishedFuture<T2<Collection<byte[]>, byte[]>>(e);
            }
        }
    }

    private void sendGenerateEncryptionKeyRequest(GenerateEncryptionKeyFuture fut) throws IgniteCheckedException {
        ClusterNode rndNode = U.randomServerNode(this.ctx);
        if (rndNode == null) {
            throw new IgniteCheckedException("There is no node to send GenerateEncryptionKeyRequest to");
        }
        GenerateEncryptionKeyRequest req = new GenerateEncryptionKeyRequest(fut.keyCount());
        fut.id(req.id());
        fut.nodeId(rndNode.id());
        this.ctx.io().sendToGridTopic(rndNode.id(), GridTopic.TOPIC_GEN_ENC_KEY, (Message)req, (byte)2);
    }

    public boolean suspendReencryption(int grpId) throws IgniteCheckedException {
        return this.reencryptionFuture(grpId).cancel();
    }

    public boolean resumeReencryption(int grpId) throws IgniteCheckedException {
        if (!this.reencryptionFuture(grpId).isDone()) {
            return false;
        }
        if (!this.reencryptionInProgress(grpId)) {
            throw new IgniteCheckedException("Re-encryption completed or not required [grpId=" + grpId + "]");
        }
        this.startReencryption(Collections.singleton(grpId));
        return true;
    }

    private void startReencryption(Collection<Integer> grpIds) throws IgniteCheckedException {
        for (int grpId : grpIds) {
            IgniteInternalFuture<Void> fut = this.pageScanner.schedule(grpId);
            fut.listen(() -> {
                if (fut.isCancelled() || fut.error() != null) {
                    this.log.warning("Reencryption " + (fut.isCancelled() ? "cancelled" : "failed") + " [grp=" + grpId + "]", fut.error());
                    return;
                }
                this.withMasterKeyChangeReadLock(() -> {
                    Object object = this.metaStorageMux;
                    synchronized (object) {
                        this.cleanupKeys(grpId);
                        this.reencryptGroups.remove(grpId);
                    }
                    return null;
                });
            });
        }
    }

    private void cleanupKeys(int grpId) throws IgniteCheckedException {
        Set<Integer> rmvKeyIds = this.grpKeys.removeUnusedKeys(grpId);
        if (rmvKeyIds.isEmpty()) {
            return;
        }
        this.writeGroupKeysToMetaStore(grpId, this.grpKeys.getAll(grpId));
        if (this.log.isInfoEnabled()) {
            this.log.info("Previous encryption keys were removed [grpId=" + grpId + ", keyIds=" + rmvKeyIds + ']');
        }
    }

    private void writeKeysToMetaStore(boolean writeAll) throws IgniteCheckedException {
        if (writeAll) {
            this.metaStorage.write(MASTER_KEY_NAME_PREFIX, (Serializable)((Object)((EncryptionSpi)this.getSpi()).getMasterKeyName()));
        }
        if (!this.reencryptGroupsForced.isEmpty()) {
            this.writeTrackedWalIdxsToMetaStore();
        }
        for (Integer grpId : this.grpKeys.groupIds()) {
            if (!writeAll && !this.reencryptGroupsForced.containsKey(grpId) && this.metaStorage.read(ENCRYPTION_KEYS_PREFIX + grpId) != null) continue;
            this.writeGroupKeysToMetaStore(grpId, this.grpKeys.getAll(grpId));
        }
    }

    private void writeGroupKeysToMetaStore(int grpId, List<GroupKeyEncrypted> keys) throws IgniteCheckedException {
        assert (Thread.holdsLock(this.metaStorageMux));
        if (this.metaStorage == null || !this.writeToMetaStoreEnabled || this.stopped) {
            return;
        }
        this.ctx.cache().context().database().checkpointReadLock();
        try {
            this.metaStorage.write(ENCRYPTION_KEYS_PREFIX + grpId, (Serializable)((Object)keys));
        }
        finally {
            this.ctx.cache().context().database().checkpointReadUnlock();
        }
    }

    private void writeTrackedWalIdxsToMetaStore() throws IgniteCheckedException {
        assert (Thread.holdsLock(this.metaStorageMux));
        if (this.metaStorage == null || !this.writeToMetaStoreEnabled || this.stopped) {
            return;
        }
        this.ctx.cache().context().database().checkpointReadLock();
        try {
            this.metaStorage.write(REENCRYPTED_WAL_SEGMENTS, (Serializable)((Object)this.grpKeys.trackedWalSegments()));
        }
        finally {
            this.ctx.cache().context().database().checkpointReadUnlock();
        }
    }

    public void checkEncryptedCacheSupported() throws IgniteCheckedException {
        Collection<ClusterNode> nodes = this.ctx.grid().cluster().nodes();
        for (ClusterNode node : nodes) {
            if (CACHE_ENCRYPTION_SINCE.compareTo(node.version()) <= 0) continue;
            throw new IgniteCheckedException("All nodes in cluster should be 2.7.0 or greater to create encrypted cache! [nodeId=" + node.id() + "]");
        }
    }

    @Override
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.ENCRYPTION_MGR;
    }

    @Nullable
    private HashMap<Integer, byte[]> newEncryptionKeys(Set<Integer> knownKeys) {
        assert (!this.isMasterKeyChangeInProgress());
        Map<Integer, CacheGroupDescriptor> grpDescs = this.ctx.cache().cacheGroupDescriptors();
        HashMap<Integer, byte[]> newKeys = null;
        for (CacheGroupDescriptor grpDesc : grpDescs.values()) {
            if (knownKeys.contains(grpDesc.groupId()) || !grpDesc.config().isEncryptionEnabled()) continue;
            if (newKeys == null) {
                newKeys = new HashMap<Integer, byte[]>();
            }
            newKeys.put(grpDesc.groupId(), ((EncryptionSpi)this.getSpi()).encryptKey(((EncryptionSpi)this.getSpi()).create()));
        }
        return newKeys;
    }

    T2<Collection<byte[]>, byte[]> createKeys(int keyCnt) {
        return this.withMasterKeyChangeReadLock(() -> {
            if (keyCnt == 0) {
                return new T2(Collections.emptyList(), ((EncryptionSpi)this.getSpi()).masterKeyDigest());
            }
            ArrayList<byte[]> encKeys = new ArrayList<byte[]>(keyCnt);
            for (int i = 0; i < keyCnt; ++i) {
                encKeys.add(((EncryptionSpi)this.getSpi()).encryptKey(((EncryptionSpi)this.getSpi()).create()));
            }
            return new T2(encKeys, ((EncryptionSpi)this.getSpi()).masterKeyDigest());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangeMasterKey(String name) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Start master key change [masterKeyName=" + name + ']');
        }
        this.masterKeyChangeLock.writeLock().lock();
        try {
            ((EncryptionSpi)this.getSpi()).setMasterKeyName(name);
            Object object = this.metaStorageMux;
            synchronized (object) {
                this.ctx.cache().context().database().checkpointReadLock();
                try {
                    this.writeKeysToWal();
                    assert (this.writeToMetaStoreEnabled);
                    this.writeKeysToMetaStore(true);
                }
                finally {
                    this.ctx.cache().context().database().checkpointReadUnlock();
                }
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Master key successfully changed [masterKeyName=" + name + ']');
            }
        }
        catch (Exception e) {
            U.error(this.log, "Unable to change master key locally.", e);
            this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, new IgniteException("Unable to change master key locally.", e)));
        }
        finally {
            this.masterKeyChangeLock.writeLock().unlock();
        }
    }

    private void writeKeysToWal() throws IgniteCheckedException {
        ArrayList<T2<Integer, GroupKeyEncrypted>> reencryptedKeys = new ArrayList<T2<Integer, GroupKeyEncrypted>>();
        for (int grpId : this.grpKeys.groupIds()) {
            for (GroupKeyEncrypted grpKey : this.grpKeys.getAll(grpId)) {
                reencryptedKeys.add(new T2<Integer, GroupKeyEncrypted>(grpId, grpKey));
            }
        }
        MasterKeyChangeRecordV2 rec = new MasterKeyChangeRecordV2(((EncryptionSpi)this.getSpi()).getMasterKeyName(), reencryptedKeys);
        WALPointer ptr = this.ctx.cache().context().wal().log(rec);
        assert (ptr != null);
    }

    public void applyKeys(MasterKeyChangeRecordV2 rec) {
        assert (!this.writeToMetaStoreEnabled && !this.ctx.state().clusterState().active());
        if (this.log.isInfoEnabled()) {
            this.log.info("Master key name loaded from WAL [masterKeyName=" + rec.getMasterKeyName() + ']');
        }
        try {
            ((EncryptionSpi)this.getSpi()).setMasterKeyName(rec.getMasterKeyName());
            HashMap<Integer, List> keysMap = new HashMap<Integer, List>();
            for (T2<Integer, GroupKeyEncrypted> t2 : rec.getGrpKeys()) {
                keysMap.computeIfAbsent((Integer)t2.getKey(), v -> new ArrayList()).add(t2.getValue());
            }
            for (Map.Entry<Integer, GroupKeyEncrypted> entry : keysMap.entrySet()) {
                this.grpKeys.setGroupKeys(entry.getKey(), (List)((Object)entry.getValue()));
            }
            this.restoredFromWAL = true;
        }
        catch (IgniteSpiException e) {
            this.log.warning("Unable to apply group keys from WAL record [masterKeyName=" + rec.getMasterKeyName() + ']', e);
        }
    }

    public void applyReencryptionStartRecord(ReencryptionStartRecord rec) {
        assert (!this.writeToMetaStoreEnabled);
        for (Map.Entry<Integer, Byte> e : rec.groups().entrySet()) {
            this.reencryptGroupsForced.put(e.getKey(), e.getValue() & 0xFF);
        }
    }

    private IgniteInternalFuture<EmptyResult> prepareMasterKeyChange(MasterKeyChangeRequest req) {
        if (this.masterKeyChangeRequest != null) {
            return new GridFinishedFuture<EmptyResult>(new IgniteException("Master key change was rejected. The previous change was not completed."));
        }
        if (this.ctx.cache().context().snapshotMgr().isSnapshotCreating() || this.ctx.cache().context().snapshotMgr().isRestoring()) {
            return new GridFinishedFuture<EmptyResult>(new IgniteException("Master key change was rejected. Snapshot operation is in progress."));
        }
        this.masterKeyChangeRequest = req;
        if (this.ctx.clientNode()) {
            return new GridFinishedFuture<EmptyResult>();
        }
        try {
            String masterKeyName = this.decryptKeyName(req.encKeyName());
            if (masterKeyName.equals(this.getMasterKeyName())) {
                throw new IgniteException("Master key change was rejected. New name equal to the current.");
            }
            byte[] digest = this.tryChangeMasterKey(masterKeyName);
            if (!Arrays.equals(req.digest, digest)) {
                return new GridFinishedFuture<EmptyResult>(new IgniteException("Master key change was rejected. Master key digest consistency check failed. Make sure that the new master key is the same at all server nodes [nodeId=" + this.ctx.localNodeId() + ']'));
            }
        }
        catch (Exception e) {
            return new GridFinishedFuture<EmptyResult>(new IgniteException("Master key change was rejected [nodeId=" + this.ctx.localNodeId() + ']', e));
        }
        return new GridFinishedFuture<EmptyResult>(new EmptyResult());
    }

    private void finishPrepareMasterKeyChange(UUID id, Map<UUID, EmptyResult> res, Map<UUID, Throwable> err) {
        if (!err.isEmpty()) {
            if (this.masterKeyChangeRequest != null && this.masterKeyChangeRequest.requestId().equals(id)) {
                this.masterKeyChangeRequest = null;
            }
            this.completeMasterKeyChangeFuture(id, err);
        } else if (U.isLocalNodeCoordinator(this.ctx.discovery())) {
            this.performMKChangeProc.start(id, this.masterKeyChangeRequest);
        }
    }

    private IgniteInternalFuture<EmptyResult> performMasterKeyChange(MasterKeyChangeRequest req) {
        if (this.masterKeyChangeRequest == null || !this.masterKeyChangeRequest.equals(req)) {
            return new GridFinishedFuture<EmptyResult>(new IgniteException("Unknown master key change was rejected."));
        }
        if (!this.ctx.state().clusterState().state().active()) {
            this.masterKeyChangeRequest = null;
            return new GridFinishedFuture<EmptyResult>(new IgniteException("Master key change was rejected. The cluster is inactive."));
        }
        if (!this.ctx.clientNode()) {
            this.doChangeMasterKey(this.decryptKeyName(req.encKeyName()));
        }
        this.masterKeyChangeRequest = null;
        this.masterKeyDigest = req.digest();
        return new GridFinishedFuture<EmptyResult>(new EmptyResult());
    }

    private void finishPerformMasterKeyChange(UUID id, Map<UUID, EmptyResult> res, Map<UUID, Throwable> err) {
        this.completeMasterKeyChangeFuture(id, err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeMasterKeyChangeFuture(UUID reqId, Map<UUID, Throwable> err) {
        Object object = this.opsMux;
        synchronized (object) {
            boolean isInitiator;
            boolean bl = isInitiator = this.masterKeyChangeFut != null && this.masterKeyChangeFut.id().equals(reqId);
            if (!isInitiator || this.masterKeyChangeFut.isDone()) {
                return;
            }
            if (!F.isEmpty(err)) {
                Throwable e = err.values().stream().findFirst().get();
                this.masterKeyChangeFut.onDone(e);
            } else {
                this.masterKeyChangeFut.onDone();
            }
            this.masterKeyChangeFut = null;
        }
    }

    private void cancelFutures(String msg) {
        assert (Thread.holdsLock(this.opsMux));
        for (GenerateEncryptionKeyFuture fut : this.genEncKeyFuts.values()) {
            fut.onDone(new IgniteFutureCancelledException(msg));
        }
        if (this.masterKeyChangeFut != null && !this.masterKeyChangeFut.isDone()) {
            this.masterKeyChangeFut.onDone(new IgniteFutureCancelledException(msg));
        }
        if (this.grpKeyChangeProc != null) {
            this.grpKeyChangeProc.cancel(msg);
        }
    }

    public boolean isMasterKeyChangeInProgress() {
        return this.masterKeyChangeRequest != null;
    }

    @Nullable
    public byte[] masterKeyDigest() {
        return this.masterKeyDigest;
    }

    <T> T withMasterKeyChangeReadLock(Callable<T> c) {
        this.masterKeyChangeLock.readLock().lock();
        try {
            T t = c.call();
            return t;
        }
        catch (Exception e) {
            throw new IgniteException(e);
        }
        finally {
            this.masterKeyChangeLock.readLock().unlock();
        }
    }

    private byte[] masterKeyDigest(String masterKeyName) {
        return ((EncryptionSpi)this.getSpi()).masterKeyDigest(masterKeyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] tryChangeMasterKey(String masterKeyName) throws IgniteCheckedException {
        byte[] digest;
        this.masterKeyChangeLock.writeLock().lock();
        try {
            String curName = ((EncryptionSpi)this.getSpi()).getMasterKeyName();
            try {
                ((EncryptionSpi)this.getSpi()).setMasterKeyName(masterKeyName);
                digest = ((EncryptionSpi)this.getSpi()).masterKeyDigest();
            }
            catch (Exception e) {
                throw new IgniteException("Unable to set master key locally [masterKeyName=" + masterKeyName + ']', e);
            }
            finally {
                ((EncryptionSpi)this.getSpi()).setMasterKeyName(curName);
            }
        }
        finally {
            this.masterKeyChangeLock.writeLock().unlock();
        }
        return digest;
    }

    private byte[] encryptKeyName(String keyName) {
        return this.withMasterKeyChangeReadLock(() -> {
            Serializable key = ((EncryptionSpi)this.getSpi()).create();
            byte[] encKey = ((EncryptionSpi)this.getSpi()).encryptKey(key);
            byte[] serKeyName = U.toBytes((Serializable)((Object)keyName));
            ByteBuffer res = ByteBuffer.allocate(4 + encKey.length + ((EncryptionSpi)this.getSpi()).encryptedSize(serKeyName.length));
            res.putInt(encKey.length);
            res.put(encKey);
            ((EncryptionSpi)this.getSpi()).encrypt(ByteBuffer.wrap(serKeyName), key, res);
            return res.array();
        });
    }

    private String decryptKeyName(byte[] data) {
        return this.withMasterKeyChangeReadLock(() -> {
            ByteBuffer buf = ByteBuffer.wrap(data);
            int keyLen = buf.getInt();
            byte[] encKey = new byte[keyLen];
            buf.get(encKey);
            byte[] encKeyName = new byte[buf.remaining()];
            buf.get(encKeyName);
            byte[] serKeyName = ((EncryptionSpi)this.getSpi()).decrypt(encKeyName, ((EncryptionSpi)this.getSpi()).decryptKey(encKey));
            return (String)U.fromBytes(serKeyName);
        });
    }

    protected static class KeyChangeFuture
    extends GridFutureAdapter<Void> {
        private final UUID id;

        KeyChangeFuture(UUID id) {
            this.id = id;
        }

        public UUID id() {
            return this.id;
        }

        @Override
        public String toString() {
            return S.toString(KeyChangeFuture.class, this);
        }
    }

    private class GenerateEncryptionKeyFuture
    extends GridFutureAdapter<T2<Collection<byte[]>, byte[]>> {
        private IgniteUuid id;
        private int keyCnt;
        private UUID nodeId;

        private GenerateEncryptionKeyFuture(int keyCnt) {
            this.keyCnt = keyCnt;
        }

        @Override
        public boolean onDone(@Nullable T2<Collection<byte[]>, byte[]> res, @Nullable Throwable err) {
            GridEncryptionManager.this.genEncKeyFuts.remove(this.id, this);
            return super.onDone(res, err);
        }

        public IgniteUuid id() {
            return this.id;
        }

        public void id(IgniteUuid id) {
            this.id = id;
        }

        public UUID nodeId() {
            return this.nodeId;
        }

        public void nodeId(UUID nodeId) {
            this.nodeId = nodeId;
        }

        public int keyCount() {
            return this.keyCnt;
        }

        @Override
        public String toString() {
            return S.toString(GenerateEncryptionKeyFuture.class, this);
        }
    }

    protected static class NodeEncryptionKeys
    implements Serializable {
        private static final long serialVersionUID = 0L;
        Map<Integer, byte[]> knownKeys;
        Map<Integer, byte[]> newKeys;
        byte[] masterKeyDigest;
        Map<Integer, List<GroupKeyEncrypted>> knownKeysWithIds;

        NodeEncryptionKeys(HashMap<Integer, List<GroupKeyEncrypted>> knownKeysWithIds, Map<Integer, byte[]> newKeys, byte[] masterKeyDigest) {
            this.newKeys = newKeys;
            this.masterKeyDigest = masterKeyDigest;
            if (F.isEmpty(knownKeysWithIds)) {
                return;
            }
            this.knownKeys = U.newHashMap(knownKeysWithIds.size());
            for (Map.Entry<Integer, List<GroupKeyEncrypted>> entry : knownKeysWithIds.entrySet()) {
                this.knownKeys.put(entry.getKey(), entry.getValue().get(0).key());
            }
            this.knownKeysWithIds = knownKeysWithIds;
        }
    }

    protected static class EmptyResult
    implements Serializable {
        private static final long serialVersionUID = 0L;

        protected EmptyResult() {
        }
    }

    private static class MasterKeyChangeRequest
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final UUID reqId;
        private final byte[] encKeyName;
        private final byte[] digest;

        private MasterKeyChangeRequest(UUID reqId, byte[] encKeyName, byte[] digest) {
            this.reqId = reqId;
            this.encKeyName = encKeyName;
            this.digest = digest;
        }

        UUID requestId() {
            return this.reqId;
        }

        byte[] encKeyName() {
            return this.encKeyName;
        }

        byte[] digest() {
            return this.digest;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MasterKeyChangeRequest)) {
                return false;
            }
            MasterKeyChangeRequest key = (MasterKeyChangeRequest)o;
            return Arrays.equals(this.encKeyName, key.encKeyName) && Arrays.equals(this.digest, key.digest) && Objects.equals(this.reqId, key.reqId);
        }

        public int hashCode() {
            int res = Objects.hash(this.reqId);
            res = 31 * res + Arrays.hashCode(this.encKeyName);
            res = 31 * res + Arrays.hashCode(this.digest);
            return res;
        }

        public String toString() {
            return S.toString(MasterKeyChangeRequest.class, this);
        }
    }
}

