/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.persistence;

import java.util.List;
import java.util.function.Consumer;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.persistence.PersistenceCleanCachesTaskArg;
import org.apache.ignite.internal.management.persistence.PersistenceCommand;
import org.apache.ignite.internal.management.persistence.PersistenceTask;
import org.apache.ignite.internal.management.persistence.PersistenceTaskResult;
import org.apache.ignite.lang.IgniteBiTuple;

public abstract class PersistenceAbstractCommand
implements ComputeCommand<PersistenceCommand.PersistenceTaskArg, PersistenceTaskResult> {
    @Override
    public Class<PersistenceTask> taskClass() {
        return PersistenceTask.class;
    }

    @Override
    public void printResult(PersistenceCommand.PersistenceTaskArg arg, PersistenceTaskResult res, Consumer<String> printer) {
        if (!res.inMaintenanceMode()) {
            printer.accept("Persistence command can be sent only to node in Maintenance Mode.");
        } else if (res.cachesInfo() != null) {
            printer.accept("Persistent caches found on node:");
            res.cachesInfo().entrySet().stream().sorted((ci0, ci1) -> {
                boolean corrupted1;
                IgniteBiTuple t0 = (IgniteBiTuple)ci0.getValue();
                IgniteBiTuple t1 = (IgniteBiTuple)ci1.getValue();
                boolean corrupted0 = (Boolean)t0.get1() != false || (Boolean)t0.get2() != false;
                boolean bl = corrupted1 = (Boolean)t1.get1() != false || (Boolean)t1.get2() != false;
                if (corrupted0 && corrupted1) {
                    return 0;
                }
                if (!corrupted0 && !corrupted1) {
                    return 0;
                }
                if (corrupted0 && !corrupted1) {
                    return -1;
                }
                return 1;
            }).forEach(e -> {
                IgniteBiTuple t = (IgniteBiTuple)e.getValue();
                String status = (Boolean)t.get1() == false ? "corrupted - WAL disabled globally." : ((Boolean)t.get2() == false ? "corrupted - WAL disabled locally." : "no corruption.");
                printer.accept("  cache name: " + (String)e.getKey() + ". Status: " + status);
            });
        } else if (arg instanceof PersistenceCommand.PersistenceCleanAllTaskArg || arg instanceof PersistenceCommand.PersistenceCleanCorruptedTaskArg || arg instanceof PersistenceCleanCachesTaskArg) {
            List<String> failedToHandleCaches;
            printer.accept("Maintenance task is " + (!res.maintenanceTaskCompleted() ? "not " : "") + "fixed.");
            List<String> cleanedCaches = res.handledCaches();
            if (cleanedCaches != null && !cleanedCaches.isEmpty()) {
                String cacheDirNames = String.join((CharSequence)", ", cleanedCaches);
                printer.accept("Cache directories were cleaned: [" + cacheDirNames + ']');
            }
            if ((failedToHandleCaches = res.failedCaches()) != null && !failedToHandleCaches.isEmpty()) {
                String failedToHandleCachesStr = String.join((CharSequence)", ", failedToHandleCaches);
                printer.accept("Failed to clean following directories: [" + failedToHandleCachesStr + ']');
            }
        } else {
            List<String> backupFailedCaches;
            List<String> backupCompletedCaches = res.handledCaches();
            if (backupCompletedCaches != null && !backupCompletedCaches.isEmpty()) {
                String cacheDirNames = String.join((CharSequence)", ", backupCompletedCaches);
                printer.accept("Cache data files was backed up to the following directories in node's work directory: [" + cacheDirNames + ']');
            }
            if ((backupFailedCaches = res.failedCaches()) != null && !backupFailedCaches.isEmpty()) {
                String backupFailedCachesStr = String.join((CharSequence)", ", backupFailedCaches);
                printer.accept("Failed to backup the following directories in node's work directory: [" + backupFailedCachesStr + ']');
            }
        }
    }
}

