/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.baseline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.management.baseline.BaselineAddCommandArg;
import org.apache.ignite.internal.management.baseline.BaselineAutoAdjustCommandArg;
import org.apache.ignite.internal.management.baseline.BaselineAutoAdjustSettings;
import org.apache.ignite.internal.management.baseline.BaselineCommand;
import org.apache.ignite.internal.management.baseline.BaselineRemoveCommandArg;
import org.apache.ignite.internal.management.baseline.BaselineSetCommandArg;
import org.apache.ignite.internal.management.baseline.BaselineTaskResult;
import org.apache.ignite.internal.management.baseline.BaselineVersionCommandArg;
import org.apache.ignite.internal.processors.cluster.baseline.autoadjust.BaselineAutoAdjustStatus;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.jetbrains.annotations.Nullable;

@GridInternal
@GridVisorManagementTask
public class BaselineTask
extends VisorOneNodeTask<BaselineCommand.BaselineTaskArg, BaselineTaskResult> {
    private static final long serialVersionUID = 0L;

    protected BaselineJob job(BaselineCommand.BaselineTaskArg arg) {
        return new BaselineJob(arg, this.debug);
    }

    private static class BaselineJob
    extends VisorJob<BaselineCommand.BaselineTaskArg, BaselineTaskResult> {
        private static final long serialVersionUID = 0L;

        private BaselineJob(BaselineCommand.BaselineTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        private BaselineTaskResult collect() {
            IgniteClusterEx cluster = this.ignite.cluster();
            Collection<BaselineNode> baseline = cluster.currentBaselineTopology();
            Collection<ClusterNode> srvrs = cluster.forServers().nodes();
            BaselineAutoAdjustSettings autoAdjustSettings = new BaselineAutoAdjustSettings(cluster.isBaselineAutoAdjustEnabled(), cluster.baselineAutoAdjustTimeout());
            BaselineAutoAdjustStatus adjustStatus = cluster.baselineAutoAdjustStatus();
            return new BaselineTaskResult(this.ignite.cluster().state().active(), cluster.topologyVersion(), F.isEmpty(baseline) ? null : baseline, srvrs, autoAdjustSettings, adjustStatus.getTimeUntilAutoAdjust(), adjustStatus.getTaskState() == BaselineAutoAdjustStatus.TaskState.IN_PROGRESS);
        }

        private BaselineTaskResult set0(Collection<BaselineNode> baselineTop) {
            this.ignite.cluster().setBaselineTopology(baselineTop);
            return this.collect();
        }

        private Map<String, BaselineNode> currentBaseLine() {
            HashMap<String, BaselineNode> nodes = new HashMap<String, BaselineNode>();
            Collection<BaselineNode> baseline = this.ignite.cluster().currentBaselineTopology();
            if (!F.isEmpty(baseline)) {
                for (BaselineNode node : baseline) {
                    nodes.put(node.consistentId().toString(), node);
                }
            }
            return nodes;
        }

        private Map<String, BaselineNode> currentServers() {
            HashMap<String, BaselineNode> nodes = new HashMap<String, BaselineNode>();
            for (ClusterNode node : this.ignite.cluster().forServers().nodes()) {
                nodes.put(node.consistentId().toString(), node);
            }
            return nodes;
        }

        private BaselineTaskResult set(List<String> consistentIds) {
            Map<String, BaselineNode> baseline = this.currentBaseLine();
            Map<String, BaselineNode> srvrs = this.currentServers();
            ArrayList<BaselineNode> baselineTop = new ArrayList<BaselineNode>();
            for (String consistentId : consistentIds) {
                if (srvrs.containsKey(consistentId)) {
                    baselineTop.add(srvrs.get(consistentId));
                    continue;
                }
                if (baseline.containsKey(consistentId)) {
                    baselineTop.add(baseline.get(consistentId));
                    continue;
                }
                throw new IllegalArgumentException("Check arguments. Node not found for consistent ID: " + consistentId);
            }
            return this.set0(baselineTop);
        }

        private BaselineTaskResult add(List<String> consistentIds) {
            Map<String, BaselineNode> baseline = this.currentBaseLine();
            Map<String, BaselineNode> srvrs = this.currentServers();
            for (String consistentId : consistentIds) {
                BaselineNode node = srvrs.get(consistentId);
                if (node == null) {
                    throw new IllegalArgumentException("Node not found for consistent ID: " + consistentId);
                }
                baseline.put(consistentId, node);
            }
            return this.set0(baseline.values());
        }

        private BaselineTaskResult remove(List<String> consistentIds) {
            Map<String, BaselineNode> baseline = this.currentBaseLine();
            if (F.isEmpty(baseline)) {
                return this.set0(Collections.emptyList());
            }
            for (String consistentId : consistentIds) {
                BaselineNode node = baseline.remove(consistentId);
                if (node != null) continue;
                throw new IllegalArgumentException("Node not found for consistent ID: " + consistentId);
            }
            return this.set0(baseline.values());
        }

        private BaselineTaskResult version(long targetVer) {
            IgniteClusterEx cluster = this.ignite.cluster();
            if (targetVer > cluster.topologyVersion()) {
                throw new IllegalArgumentException("Topology version is ahead of time: " + targetVer);
            }
            cluster.setBaselineTopology(targetVer);
            return this.collect();
        }

        private BaselineTaskResult updateAutoAdjustmentSettings(BaselineAutoAdjustCommandArg settings) {
            if (settings.timeout() != null) {
                this.ignite.cluster().baselineAutoAdjustTimeout(settings.timeout());
            }
            if (settings.enabled() != null) {
                this.ignite.cluster().baselineAutoAdjustEnabled(settings.enabled() == BaselineAutoAdjustCommandArg.Enabled.ENABLE);
            }
            return this.collect();
        }

        @Override
        protected BaselineTaskResult run(@Nullable BaselineCommand.BaselineTaskArg arg) throws IgniteException {
            if (arg instanceof BaselineRemoveCommandArg) {
                return this.remove(F.asList(((BaselineAddCommandArg)arg).consistentIDs()));
            }
            if (arg instanceof BaselineSetCommandArg) {
                return this.set(F.asList(((BaselineAddCommandArg)arg).consistentIDs()));
            }
            if (arg instanceof BaselineAddCommandArg) {
                return this.add(F.asList(((BaselineAddCommandArg)arg).consistentIDs()));
            }
            if (arg instanceof BaselineVersionCommandArg) {
                return this.version(((BaselineVersionCommandArg)arg).topologyVersion());
            }
            if (arg instanceof BaselineAutoAdjustCommandArg) {
                return this.updateAutoAdjustmentSettings((BaselineAutoAdjustCommandArg)arg);
            }
            return this.collect();
        }

        public String toString() {
            return S.toString(BaselineJob.class, this);
        }
    }
}

