/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.DistributedConfigurationUtils;
import org.apache.ignite.internal.processors.configuration.distributed.DistributePropertyListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedBooleanProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedDoubleProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedIntegerProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedLongProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedPropertyDispatcher;
import org.apache.ignite.internal.processors.metastorage.ReadableDistributedMetaStorage;
import org.apache.ignite.internal.util.future.GridFutureAdapter;

public class DistributedTransactionConfiguration {
    private static final String PROPERTY_UPDATE_MESSAGE = "Transactions parameter '%s' was changed from '%s' to '%s'";
    private final long dfltLongOpsDumpTimeout = IgniteSystemProperties.getLong("IGNITE_LONG_OPERATIONS_DUMP_TIMEOUT", 60000L);
    private final long dfltLongTransactionTimeDumpThreshold = IgniteSystemProperties.getLong("IGNITE_LONG_TRANSACTION_TIME_DUMP_THRESHOLD", 0L);
    private final double dfltTransactionTimeDumpSamplesCoefficient = IgniteSystemProperties.getFloat("IGNITE_TRANSACTION_TIME_DUMP_SAMPLES_COEFFICIENT", 0.0f);
    private final int dfltLongTransactionTimeDumpSamplesPerSecondLimit = IgniteSystemProperties.getInteger("IGNITE_TRANSACTION_TIME_DUMP_SAMPLES_PER_SECOND_LIMIT", 5);
    private final int dfltCollisionsDumpInterval = IgniteSystemProperties.getInteger("IGNITE_DUMP_TX_COLLISIONS_INTERVAL", 1000);
    private final boolean dfltTxOwnerDumpRequestsAllowed = IgniteSystemProperties.getBoolean("IGNITE_TX_OWNER_DUMP_REQUESTS_ALLOWED", true);
    private final DistributedChangeableProperty<Boolean> txOwnerDumpRequestsAllowed = DistributedBooleanProperty.detachedBooleanProperty("txOwnerDumpRequestsAllowed", "Shows if dump requests from local node to near node are allowed, when long running transaction is found. If allowed, the compute request to near node will be made to get thread dump of transaction owner thread.");
    private final DistributedChangeableProperty<Long> longOperationsDumpTimeout = DistributedLongProperty.detachedLongProperty("longOperationsDumpTimeout", "Cache operations that take more time than value of this property in milliseconds will be output to log. Set to 0 to disable.");
    private final DistributedChangeableProperty<Long> longTransactionTimeDumpThreshold = DistributedLongProperty.detachedLongProperty("longTransactionTimeDumpThreshold", "Threshold timeout for long transactions, if transaction exceeds it, it will be dumped in log with information about how much time did it spent in system time (time while acquiring locks, preparing, committing, etc) and user time (time when client node runs some code while holding transaction and not waiting it). Equals 0 if not set.");
    private final DistributedChangeableProperty<Double> transactionTimeDumpSamplesCoefficient = DistributedDoubleProperty.detachedDoubleProperty("transactionTimeDumpSamplesCoefficient", "The coefficient for samples of completed transactions that will be dumped in log. Must be float value between 0.0 and 1.0 inclusive.");
    private final DistributedChangeableProperty<Integer> longTransactionTimeDumpSamplesPerSecondLimit = DistributedIntegerProperty.detachedIntegerProperty("longTransactionTimeDumpSamplesPerSecondLimit", "The limit of samples of completed transactions that will be dumped in log per second, if IGNITE_TRANSACTION_TIME_DUMP_SAMPLES_COEFFICIENT is above 0.0. Must be integer value greater than 0.");
    private final DistributedChangeableProperty<Integer> collisionsDumpInterval = DistributedIntegerProperty.detachedIntegerProperty("collisionsDumpInterval", "When above zero, prints tx key collisions once per interval. Each transaction besides OPTIMISTIC SERIALIZABLE capture locks on all enlisted keys, for some reasons per key lock queue may rise. This property sets the interval in milliseconds during which statistics are collected.");

    public DistributedTransactionConfiguration(final GridKernalContext ctx, final IgniteLogger log, final DistributePropertyListener<Long> longOperationsDumpTimeoutLsnr, final DistributePropertyListener<Integer> collisionsDumpIntervalLsnr) {
        ctx.internalSubscriptionProcessor().registerDistributedConfigurationListener(new DistributedConfigurationLifecycleListener(){

            @Override
            public void onReadyToRegister(DistributedPropertyDispatcher dispatcher) {
                DistributedTransactionConfiguration.this.txOwnerDumpRequestsAllowed.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedTransactionConfiguration.PROPERTY_UPDATE_MESSAGE, log));
                DistributedTransactionConfiguration.this.longOperationsDumpTimeout.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedTransactionConfiguration.PROPERTY_UPDATE_MESSAGE, log));
                DistributedTransactionConfiguration.this.longTransactionTimeDumpThreshold.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedTransactionConfiguration.PROPERTY_UPDATE_MESSAGE, log));
                DistributedTransactionConfiguration.this.transactionTimeDumpSamplesCoefficient.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedTransactionConfiguration.PROPERTY_UPDATE_MESSAGE, log));
                DistributedTransactionConfiguration.this.longTransactionTimeDumpSamplesPerSecondLimit.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedTransactionConfiguration.PROPERTY_UPDATE_MESSAGE, log));
                DistributedTransactionConfiguration.this.collisionsDumpInterval.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedTransactionConfiguration.PROPERTY_UPDATE_MESSAGE, log));
                DistributedTransactionConfiguration.this.longOperationsDumpTimeout.addListener(longOperationsDumpTimeoutLsnr);
                DistributedTransactionConfiguration.this.collisionsDumpInterval.addListener(collisionsDumpIntervalLsnr);
                dispatcher.registerProperties(new DistributedChangeableProperty[]{DistributedTransactionConfiguration.this.txOwnerDumpRequestsAllowed, DistributedTransactionConfiguration.this.longOperationsDumpTimeout, DistributedTransactionConfiguration.this.longTransactionTimeDumpThreshold, DistributedTransactionConfiguration.this.transactionTimeDumpSamplesCoefficient, DistributedTransactionConfiguration.this.longTransactionTimeDumpSamplesPerSecondLimit, DistributedTransactionConfiguration.this.collisionsDumpInterval});
            }

            @Override
            public void onReadyToWrite() {
                if (ReadableDistributedMetaStorage.isSupported(ctx)) {
                    DistributedConfigurationUtils.setDefaultValue(DistributedTransactionConfiguration.this.longOperationsDumpTimeout, DistributedTransactionConfiguration.this.dfltLongOpsDumpTimeout, log);
                    DistributedConfigurationUtils.setDefaultValue(DistributedTransactionConfiguration.this.longTransactionTimeDumpThreshold, DistributedTransactionConfiguration.this.dfltLongTransactionTimeDumpThreshold, log);
                    DistributedConfigurationUtils.setDefaultValue(DistributedTransactionConfiguration.this.transactionTimeDumpSamplesCoefficient, DistributedTransactionConfiguration.this.dfltTransactionTimeDumpSamplesCoefficient, log);
                    DistributedConfigurationUtils.setDefaultValue(DistributedTransactionConfiguration.this.longTransactionTimeDumpSamplesPerSecondLimit, DistributedTransactionConfiguration.this.dfltLongTransactionTimeDumpSamplesPerSecondLimit, log);
                    DistributedConfigurationUtils.setDefaultValue(DistributedTransactionConfiguration.this.collisionsDumpInterval, DistributedTransactionConfiguration.this.dfltCollisionsDumpInterval, log);
                    DistributedConfigurationUtils.setDefaultValue(DistributedTransactionConfiguration.this.txOwnerDumpRequestsAllowed, DistributedTransactionConfiguration.this.dfltTxOwnerDumpRequestsAllowed, log);
                } else {
                    log.warning("Distributed metastorage is not supported. All distributed transaction configuration parameters are unavailable. Default values will be set.");
                    DistributedTransactionConfiguration.this.longOperationsDumpTimeout.localUpdate(Long.valueOf(DistributedTransactionConfiguration.this.dfltLongOpsDumpTimeout));
                    DistributedTransactionConfiguration.this.longTransactionTimeDumpThreshold.localUpdate(Long.valueOf(DistributedTransactionConfiguration.this.dfltLongTransactionTimeDumpThreshold));
                    DistributedTransactionConfiguration.this.transactionTimeDumpSamplesCoefficient.localUpdate(Double.valueOf(DistributedTransactionConfiguration.this.dfltTransactionTimeDumpSamplesCoefficient));
                    DistributedTransactionConfiguration.this.longTransactionTimeDumpSamplesPerSecondLimit.localUpdate(Integer.valueOf(DistributedTransactionConfiguration.this.dfltLongTransactionTimeDumpSamplesPerSecondLimit));
                    DistributedTransactionConfiguration.this.collisionsDumpInterval.localUpdate(Integer.valueOf(DistributedTransactionConfiguration.this.dfltCollisionsDumpInterval));
                    DistributedTransactionConfiguration.this.txOwnerDumpRequestsAllowed.localUpdate(Boolean.valueOf(DistributedTransactionConfiguration.this.dfltTxOwnerDumpRequestsAllowed));
                }
            }
        });
    }

    public GridFutureAdapter<?> updateLongOperationsDumpTimeoutAsync(long timeout) throws IgniteCheckedException {
        return this.longOperationsDumpTimeout.propagateAsync(timeout);
    }

    public void updateLongOperationsDumpTimeoutLocal(long timeout) {
        this.longOperationsDumpTimeout.localUpdate(Long.valueOf(timeout));
    }

    public Long longOperationsDumpTimeout() {
        return this.longOperationsDumpTimeout.getOrDefault(this.dfltLongOpsDumpTimeout);
    }

    public GridFutureAdapter<?> updateLongTransactionTimeDumpThresholdAsync(long longTransactionTimeDumpThreshold) throws IgniteCheckedException {
        return this.longTransactionTimeDumpThreshold.propagateAsync(longTransactionTimeDumpThreshold);
    }

    public void updateLongTransactionTimeDumpThresholdLocal(long longTransactionTimeDumpThreshold) {
        this.longTransactionTimeDumpThreshold.localUpdate(Long.valueOf(longTransactionTimeDumpThreshold));
    }

    public Long longTransactionTimeDumpThreshold() {
        return this.longTransactionTimeDumpThreshold.getOrDefault(this.dfltLongTransactionTimeDumpThreshold);
    }

    public GridFutureAdapter<?> updateTransactionTimeDumpSamplesCoefficientAsync(double transactionTimeDumpSamplesCoefficient) throws IgniteCheckedException {
        return this.transactionTimeDumpSamplesCoefficient.propagateAsync(transactionTimeDumpSamplesCoefficient);
    }

    public void updateTransactionTimeDumpSamplesCoefficientLocal(double transactionTimeDumpSamplesCoefficient) {
        this.transactionTimeDumpSamplesCoefficient.localUpdate(Double.valueOf(transactionTimeDumpSamplesCoefficient));
    }

    public Double transactionTimeDumpSamplesCoefficient() {
        return this.transactionTimeDumpSamplesCoefficient.getOrDefault(this.dfltTransactionTimeDumpSamplesCoefficient);
    }

    public GridFutureAdapter<?> updateLongTransactionTimeDumpSamplesPerSecondLimitAsync(int limit) throws IgniteCheckedException {
        return this.longTransactionTimeDumpSamplesPerSecondLimit.propagateAsync(limit);
    }

    public void updateLongTransactionTimeDumpSamplesPerSecondLimitLocal(int limit) {
        this.longTransactionTimeDumpSamplesPerSecondLimit.localUpdate(Integer.valueOf(limit));
    }

    public Integer longTransactionTimeDumpSamplesPerSecondLimit() {
        return this.longTransactionTimeDumpSamplesPerSecondLimit.getOrDefault(this.dfltLongTransactionTimeDumpSamplesPerSecondLimit);
    }

    public GridFutureAdapter<?> updateCollisionsDumpIntervalAsync(int collisionsDumpInterval) throws IgniteCheckedException {
        return this.collisionsDumpInterval.propagateAsync(collisionsDumpInterval);
    }

    public void updateCollisionsDumpIntervalLocal(int collisionsDumpInterval) {
        this.collisionsDumpInterval.localUpdate(Integer.valueOf(collisionsDumpInterval));
    }

    public Integer collisionsDumpInterval() {
        return this.collisionsDumpInterval.getOrDefault(this.dfltCollisionsDumpInterval);
    }

    public GridFutureAdapter<?> updateTxOwnerDumpRequestsAllowedAsync(boolean allowed) throws IgniteCheckedException {
        return this.txOwnerDumpRequestsAllowed.propagateAsync(allowed);
    }

    public void updateTxOwnerDumpRequestsAllowedLocal(boolean allowed) {
        this.txOwnerDumpRequestsAllowed.localUpdate(Boolean.valueOf(allowed));
    }

    public Boolean txOwnerDumpRequestsAllowed() {
        return this.txOwnerDumpRequestsAllowed.getOrDefault(this.dfltTxOwnerDumpRequestsAllowed);
    }
}

