/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.Collection;
import java.util.function.Consumer;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientReconnectedException;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientProtocolError;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.QueryPager;
import org.apache.ignite.internal.client.thin.ReliableChannel;

abstract class GenericQueryPager<T>
implements QueryPager<T> {
    private final ClientOperation qryOp;
    private final ClientOperation pageQryOp;
    private final Consumer<PayloadOutputChannel> qryWriter;
    private final ReliableChannel ch;
    private boolean hasNext = true;
    private boolean hasFirstPage = false;
    private Long cursorId = null;
    private ClientChannel clientCh;
    private final int cacheId;
    private final int part;

    GenericQueryPager(ReliableChannel ch, ClientOperation qryOp, ClientOperation pageQryOp, Consumer<PayloadOutputChannel> qryWriter, int cacheId, int part) {
        this.ch = ch;
        this.qryOp = qryOp;
        this.pageQryOp = pageQryOp;
        this.qryWriter = qryWriter;
        this.cacheId = cacheId;
        this.part = part;
    }

    GenericQueryPager(ReliableChannel ch, ClientOperation qryOp, ClientOperation pageQryOp, Consumer<PayloadOutputChannel> qryWriter) {
        this(ch, qryOp, pageQryOp, qryWriter, 0, -1);
    }

    @Override
    public Collection<T> next() throws ClientException {
        if (!this.hasNext) {
            throw new IllegalStateException("No more query results");
        }
        return this.hasFirstPage ? this.queryPage() : (this.part == -1 ? this.ch.service(this.qryOp, this.qryWriter, this::readResult) : this.ch.affinityService(this.cacheId, this.part, this.qryOp, this.qryWriter, this::readResult));
    }

    @Override
    public void close() throws Exception {
        if (this.cursorId != null && this.hasNext && !this.clientCh.closed()) {
            try {
                this.clientCh.service(ClientOperation.RESOURCE_CLOSE, req -> req.out().writeLong(this.cursorId), null);
            }
            catch (ClientConnectionException | ClientReconnectedException clientException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public boolean hasFirstPage() {
        return this.hasFirstPage;
    }

    @Override
    public void reset() {
        this.hasFirstPage = false;
        this.hasNext = true;
        this.cursorId = null;
        this.clientCh = null;
    }

    abstract Collection<T> readEntries(PayloadInputChannel var1);

    private Collection<T> readResult(PayloadInputChannel payloadCh) {
        if (!this.hasFirstPage) {
            long resCursorId = payloadCh.in().readLong();
            if (this.cursorId != null) {
                if (this.cursorId != resCursorId) {
                    throw new ClientProtocolError(String.format("Expected cursor [%s] but received cursor [%s]", this.cursorId, resCursorId));
                }
            } else {
                this.cursorId = resCursorId;
                this.clientCh = payloadCh.clientChannel();
            }
        }
        Collection<T> res = this.readEntries(payloadCh);
        this.hasNext = payloadCh.in().readBoolean();
        this.hasFirstPage = true;
        return res;
    }

    private Collection<T> queryPage() throws ClientException {
        return this.clientCh.service(this.pageQryOp, req -> req.out().writeLong(this.cursorId), this::readResult);
    }
}

