/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;

public class MetaPageInfo {
    private final int inlineSize;
    private final boolean useUnwrappedPk;
    private final boolean flagsSupported;
    private boolean inlineObjSupported;
    private boolean inlineObjHash;
    private final IgniteProductVersion createdVer;

    public MetaPageInfo(BPlusMetaIO io, long pageAddr) {
        this.inlineSize = io.getInlineSize(pageAddr);
        this.useUnwrappedPk = io.unwrappedPk(pageAddr);
        this.flagsSupported = io.supportFlags();
        if (this.flagsSupported) {
            this.inlineObjSupported = io.inlineObjectSupported(pageAddr);
            this.inlineObjHash = io.inlineObjectHash(pageAddr);
        }
        this.createdVer = io.createdVersion(pageAddr);
    }

    public int inlineSize() {
        return this.inlineSize;
    }

    public boolean useUnwrappedPk() {
        return this.useUnwrappedPk;
    }

    public boolean flagsSupported() {
        return this.flagsSupported;
    }

    public boolean inlineObjectSupported() {
        return this.inlineObjSupported;
    }

    public boolean inlineObjectHash() {
        return this.inlineObjHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetaPageInfo read(long metaPageId, int grpId, PageMemory pageMemory) throws IgniteCheckedException {
        long metaPage = pageMemory.acquirePage(grpId, metaPageId);
        try {
            MetaPageInfo metaPageInfo;
            long pageAddr = pageMemory.readLock(grpId, metaPageId, metaPage);
            assert (pageAddr != 0L) : "Failed to read lock meta page [metaPageId=" + U.hexLong(metaPageId) + ']';
            try {
                BPlusMetaIO io = BPlusMetaIO.VERSIONS.forPage(pageAddr);
                metaPageInfo = new MetaPageInfo(io, pageAddr);
            }
            catch (Throwable throwable) {
                pageMemory.readUnlock(grpId, metaPageId, metaPage);
                throw throwable;
            }
            pageMemory.readUnlock(grpId, metaPageId, metaPage);
            return metaPageInfo;
        }
        finally {
            pageMemory.releasePage(grpId, metaPageId, metaPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long metaPageId, int grpId, PageMemory pageMemory) throws IgniteCheckedException {
        long metaPage = pageMemory.acquirePage(grpId, metaPageId);
        try {
            long pageAddr = pageMemory.writeLock(grpId, metaPageId, metaPage);
            assert (pageAddr != 0L) : "Failed to write lock meta page [metaPageId=" + U.hexLong(metaPageId) + ']';
            try {
                BPlusMetaIO.setValues(pageAddr, this.inlineSize(), this.useUnwrappedPk(), this.inlineObjectSupported(), this.inlineObjectHash());
            }
            finally {
                pageMemory.writeUnlock(grpId, metaPageId, metaPage, null, true);
            }
        }
        finally {
            pageMemory.releasePage(grpId, metaPageId, metaPage);
        }
    }
}

