/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.colorspace.PDFColorSpace;
import com.sun.pdfview.decode.MyTracker;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DCTDecode {
    protected static ByteBuffer decode(PDFObject dict, ByteBuffer buf, PDFObject params) throws PDFParseException {
        byte[] output;
        block9: {
            BufferedImage bimg;
            int type;
            block10: {
                block8: {
                    buf.rewind();
                    byte[] ary = new byte[buf.remaining()];
                    buf.get(ary);
                    Image img = Toolkit.getDefaultToolkit().createImage(ary);
                    MyTracker mt = new MyTracker(img);
                    mt.waitForAll();
                    int numComponents = 3;
                    try {
                        PDFObject csObj = dict.getDictRef("ColorSpace");
                        if (csObj != null) {
                            PDFColorSpace cs = PDFColorSpace.getColorSpace(csObj, null);
                            numComponents = cs.getNumComponents();
                        }
                    }
                    catch (IOException csObj) {
                        // empty catch block
                    }
                    type = 1;
                    if (numComponents == 1) {
                        type = 10;
                    } else if (numComponents == 4) {
                        type = 2;
                    }
                    bimg = new BufferedImage(img.getWidth(null), img.getHeight(null), type);
                    Graphics bg = bimg.getGraphics();
                    bg.drawImage(img, 0, 0, null);
                    output = null;
                    if (type != 1) break block8;
                    DataBufferInt db = (DataBufferInt)bimg.getData().getDataBuffer();
                    int[] data = db.getData();
                    output = new byte[data.length * 3];
                    for (int i = 0; i < data.length; ++i) {
                        output[i * 3] = (byte)(data[i] >> 16);
                        output[i * 3 + 1] = (byte)(data[i] >> 8);
                        output[i * 3 + 2] = (byte)data[i];
                    }
                    break block9;
                }
                if (type != 10) break block10;
                DataBufferByte db = (DataBufferByte)bimg.getData().getDataBuffer();
                output = db.getData();
                break block9;
            }
            if (type != 2) break block9;
            DataBufferInt db = (DataBufferInt)bimg.getData().getDataBuffer();
            int[] data = db.getData();
            output = new byte[data.length * 4];
            for (int i = 0; i < data.length; ++i) {
                output[i * 4] = (byte)(data[i] >> 24);
                output[i * 4 + 1] = (byte)(data[i] >> 16);
                output[i * 4 + 2] = (byte)(data[i] >> 8);
                output[i * 4 + 3] = (byte)data[i];
            }
        }
        return ByteBuffer.wrap(output);
    }
}

