/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.internal.ComputeMXBeanImpl;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.QueryMXBeanImpl;
import org.apache.ignite.internal.ServiceMXBeanImpl;
import org.apache.ignite.internal.TransactionsMXBeanImpl;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.processors.query.schema.management.IndexDescriptor;
import org.apache.ignite.internal.processors.query.schema.management.SchemaManager;
import org.apache.ignite.internal.processors.query.schema.management.TableDescriptor;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.sql.command.SqlAlterTableCommand;
import org.apache.ignite.internal.sql.command.SqlAlterUserCommand;
import org.apache.ignite.internal.sql.command.SqlAnalyzeCommand;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlCreateIndexCommand;
import org.apache.ignite.internal.sql.command.SqlCreateUserCommand;
import org.apache.ignite.internal.sql.command.SqlDropIndexCommand;
import org.apache.ignite.internal.sql.command.SqlDropStatisticsCommand;
import org.apache.ignite.internal.sql.command.SqlDropUserCommand;
import org.apache.ignite.internal.sql.command.SqlIndexColumn;
import org.apache.ignite.internal.sql.command.SqlKillClientCommand;
import org.apache.ignite.internal.sql.command.SqlKillComputeTaskCommand;
import org.apache.ignite.internal.sql.command.SqlKillContinuousQueryCommand;
import org.apache.ignite.internal.sql.command.SqlKillQueryCommand;
import org.apache.ignite.internal.sql.command.SqlKillScanQueryCommand;
import org.apache.ignite.internal.sql.command.SqlKillServiceCommand;
import org.apache.ignite.internal.sql.command.SqlKillTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlRefreshStatitsicsCommand;
import org.apache.ignite.internal.sql.command.SqlStatisticsCommands;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.jetbrains.annotations.Nullable;

public class SqlCommandProcessor {
    protected final GridKernalContext ctx;
    protected final IgniteLogger log;
    protected final SchemaManager schemaMgr;

    public SqlCommandProcessor(GridKernalContext ctx) {
        this.ctx = ctx;
        this.schemaMgr = ctx.query().schemaManager();
        this.log = ctx.log(this.getClass());
    }

    @Nullable
    public FieldsQueryCursor<List<?>> runCommand(SqlCommand cmdNative) {
        assert (cmdNative != null);
        if (SqlCommandProcessor.isDdl(cmdNative)) {
            this.runCommandNativeDdl(cmdNative);
        } else if (cmdNative instanceof SqlKillClientCommand) {
            this.processKillClientCommand((SqlKillClientCommand)cmdNative);
        } else if (cmdNative instanceof SqlKillComputeTaskCommand) {
            this.processKillComputeTaskCommand((SqlKillComputeTaskCommand)cmdNative);
        } else if (cmdNative instanceof SqlKillTransactionCommand) {
            this.processKillTxCommand((SqlKillTransactionCommand)cmdNative);
        } else if (cmdNative instanceof SqlKillServiceCommand) {
            this.processKillServiceTaskCommand((SqlKillServiceCommand)cmdNative);
        } else if (cmdNative instanceof SqlKillScanQueryCommand) {
            this.processKillScanQueryCommand((SqlKillScanQueryCommand)cmdNative);
        } else if (cmdNative instanceof SqlKillContinuousQueryCommand) {
            this.processKillContinuousQueryCommand((SqlKillContinuousQueryCommand)cmdNative);
        } else if (cmdNative instanceof SqlKillQueryCommand) {
            this.processKillQueryCommand((SqlKillQueryCommand)cmdNative);
        } else if (cmdNative instanceof SqlAnalyzeCommand) {
            this.processAnalyzeCommand((SqlAnalyzeCommand)cmdNative);
        } else if (cmdNative instanceof SqlRefreshStatitsicsCommand) {
            this.processRefreshStatisticsCommand((SqlRefreshStatitsicsCommand)cmdNative);
        } else if (cmdNative instanceof SqlDropStatisticsCommand) {
            this.processDropStatisticsCommand((SqlDropStatisticsCommand)cmdNative);
        }
        return null;
    }

    public boolean isCommandSupported(SqlCommand cmd) {
        return cmd instanceof SqlCreateIndexCommand || cmd instanceof SqlDropIndexCommand || cmd instanceof SqlAlterTableCommand || cmd instanceof SqlCreateUserCommand || cmd instanceof SqlAlterUserCommand || cmd instanceof SqlDropUserCommand || cmd instanceof SqlKillClientCommand || cmd instanceof SqlKillComputeTaskCommand || cmd instanceof SqlKillServiceCommand || cmd instanceof SqlKillTransactionCommand || cmd instanceof SqlKillScanQueryCommand || cmd instanceof SqlKillContinuousQueryCommand || cmd instanceof SqlKillQueryCommand || cmd instanceof SqlStatisticsCommands;
    }

    private static boolean isDdl(SqlCommand cmd) {
        return cmd instanceof SqlCreateIndexCommand || cmd instanceof SqlDropIndexCommand || cmd instanceof SqlAlterTableCommand || cmd instanceof SqlCreateUserCommand || cmd instanceof SqlAlterUserCommand || cmd instanceof SqlDropUserCommand;
    }

    private void processKillQueryCommand(SqlKillQueryCommand cmd) {
        this.ctx.query().runningQueryManager().cancelQuery(cmd.nodeQueryId(), cmd.nodeId(), cmd.async());
    }

    private void processKillScanQueryCommand(SqlKillScanQueryCommand cmd) {
        new QueryMXBeanImpl(this.ctx).cancelScan(cmd.getOriginNodeId(), cmd.getCacheName(), cmd.getQryId());
    }

    private void processKillClientCommand(SqlKillClientCommand cmd) {
        if (cmd.connectionId() == null) {
            this.ctx.clientListener().mxBean().dropAllConnections();
        } else {
            this.ctx.clientListener().mxBean().dropConnection(cmd.connectionId());
        }
    }

    private void processKillComputeTaskCommand(SqlKillComputeTaskCommand cmd) {
        new ComputeMXBeanImpl(this.ctx).cancel(cmd.getSessionId());
    }

    private void processKillTxCommand(SqlKillTransactionCommand cmd) {
        new TransactionsMXBeanImpl(this.ctx).cancel(cmd.getXid());
    }

    private void processKillServiceTaskCommand(SqlKillServiceCommand cmd) {
        new ServiceMXBeanImpl(this.ctx).cancel(cmd.getName());
    }

    private void processKillContinuousQueryCommand(SqlKillContinuousQueryCommand cmd) {
        new QueryMXBeanImpl(this.ctx).cancelContinuous(cmd.getOriginNodeId(), cmd.getRoutineId());
    }

    private void processAnalyzeCommand(SqlAnalyzeCommand cmd) {
        this.ctx.security().authorize(SecurityPermission.CHANGE_STATISTICS);
        StatisticsObjectConfiguration[] objCfgs = (StatisticsObjectConfiguration[])cmd.configurations().stream().map(t -> {
            if (t.key().schema() == null) {
                StatisticsKey key = new StatisticsKey(cmd.schemaName(), t.key().obj());
                return new StatisticsObjectConfiguration(key, t.columns().values(), t.maxPartitionObsolescencePercent());
            }
            return t;
        }).toArray(StatisticsObjectConfiguration[]::new);
        try {
            this.ctx.query().statsManager().collectStatistics(objCfgs);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSQLException(e.getMessage(), e);
        }
    }

    private void processRefreshStatisticsCommand(SqlRefreshStatitsicsCommand cmd) {
        this.ctx.security().authorize(SecurityPermission.REFRESH_STATISTICS);
        StatisticsTarget[] targets = (StatisticsTarget[])cmd.targets().stream().map(t -> t.schema() == null ? new StatisticsTarget(cmd.schemaName(), t.obj(), t.columns()) : t).toArray(StatisticsTarget[]::new);
        try {
            this.ctx.query().statsManager().refreshStatistics(targets);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSQLException(e.getMessage(), e);
        }
    }

    private void processDropStatisticsCommand(SqlDropStatisticsCommand cmd) {
        this.ctx.security().authorize(SecurityPermission.CHANGE_STATISTICS);
        StatisticsTarget[] targets = (StatisticsTarget[])cmd.targets().stream().map(t -> t.schema() == null ? new StatisticsTarget(cmd.schemaName(), t.obj(), t.columns()) : t).toArray(StatisticsTarget[]::new);
        try {
            this.ctx.query().statsManager().dropStatistics(targets);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSQLException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runCommandNativeDdl(SqlCommand cmd) {
        Object var2_2 = null;
        try {
            void var2_8;
            QueryUtils.isDdlOnSchemaSupported(cmd.schemaName());
            this.finishActiveTxIfNecessary();
            if (cmd instanceof SqlCreateIndexCommand) {
                SqlCreateIndexCommand cmd0 = (SqlCreateIndexCommand)cmd;
                TableDescriptor tbl = this.schemaMgr.table(cmd0.schemaName(), cmd0.tableName());
                if (tbl == null) {
                    throw new SchemaOperationException(2, cmd0.tableName());
                }
                GridQueryTypeDescriptor typeDesc = tbl.type();
                GridCacheContextInfo<?, ?> cacheInfo = tbl.cacheInfo();
                QueryIndex newIdx = new QueryIndex();
                newIdx.setName(cmd0.indexName());
                newIdx.setIndexType(cmd0.spatial() ? QueryIndexType.GEOSPATIAL : QueryIndexType.SORTED);
                LinkedHashMap<String, Boolean> flds = new LinkedHashMap<String, Boolean>();
                for (SqlIndexColumn col : cmd0.columns()) {
                    GridQueryProperty prop = typeDesc.property(col.name());
                    if (prop == null) {
                        throw new SchemaOperationException(4, col.name());
                    }
                    flds.put(prop.name(), !col.descending());
                }
                newIdx.setFields(flds);
                newIdx.setInlineSize(cmd0.inlineSize());
                IgniteInternalFuture<?> igniteInternalFuture = this.ctx.query().dynamicIndexCreate(cacheInfo.name(), cmd.schemaName(), typeDesc.tableName(), newIdx, cmd0.ifNotExists(), cmd0.parallel());
            } else if (cmd instanceof SqlDropIndexCommand) {
                SqlDropIndexCommand cmd0 = (SqlDropIndexCommand)cmd;
                IndexDescriptor idxDesc = this.schemaMgr.index(cmd0.schemaName(), cmd0.indexName());
                if (!(idxDesc == null || idxDesc.isPk() || idxDesc.isAffinity() || idxDesc.isProxy())) {
                    GridCacheContextInfo<?, ?> cacheInfo = idxDesc.table().cacheInfo();
                    IgniteInternalFuture<?> igniteInternalFuture = this.ctx.query().dynamicIndexDrop(cacheInfo.name(), cmd0.schemaName(), cmd0.indexName(), cmd0.ifExists());
                } else {
                    if (!cmd0.ifExists()) throw new SchemaOperationException(6, cmd0.indexName());
                    GridFinishedFuture gridFinishedFuture = new GridFinishedFuture();
                }
            } else if (cmd instanceof SqlAlterTableCommand) {
                SqlAlterTableCommand cmd0 = (SqlAlterTableCommand)cmd;
                TableDescriptor tbl = this.schemaMgr.table(cmd0.schemaName(), cmd0.tableName());
                if (tbl == null) {
                    throw new SchemaOperationException(2, cmd0.tableName());
                }
                GridCacheContextInfo<?, ?> cacheInfo = tbl.cacheInfo();
                Boolean logging = cmd0.logging();
                assert (logging != null) : "Only LOGGING/NOLOGGING are supported at the moment.";
                IgniteClusterEx cluster = this.ctx.grid().cluster();
                if (logging.booleanValue()) {
                    boolean res = cluster.enableWal(cacheInfo.name());
                    if (!res) {
                        throw new IgniteSQLException("Logging already enabled for table: " + cmd0.tableName());
                    }
                } else {
                    boolean res = cluster.disableWal(cacheInfo.name());
                    if (!res) {
                        throw new IgniteSQLException("Logging already disabled for table: " + cmd0.tableName());
                    }
                }
                GridFinishedFuture gridFinishedFuture = new GridFinishedFuture();
            } else if (cmd instanceof SqlCreateUserCommand) {
                SqlCreateUserCommand addCmd = (SqlCreateUserCommand)cmd;
                this.ctx.security().createUser(addCmd.userName(), addCmd.password().toCharArray());
            } else if (cmd instanceof SqlAlterUserCommand) {
                SqlAlterUserCommand altCmd = (SqlAlterUserCommand)cmd;
                this.ctx.security().alterUser(altCmd.userName(), altCmd.password().toCharArray());
            } else {
                if (!(cmd instanceof SqlDropUserCommand)) throw new IgniteSQLException("Unsupported DDL operation: " + cmd, 1002);
                SqlDropUserCommand dropCmd = (SqlDropUserCommand)cmd;
                this.ctx.security().dropUser(dropCmd.userName());
            }
            if (var2_8 == null) return;
            var2_8.get();
            return;
        }
        catch (SchemaOperationException e) {
            throw QueryUtils.convert(e);
        }
        catch (IgniteSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteSQLException(e.getMessage(), e);
        }
    }

    protected void finishActiveTxIfNecessary() throws IgniteCheckedException {
        try (GridNearTxLocal tx = MvccUtils.tx(this.ctx);){
            if (tx == null) {
                return;
            }
            if (!tx.isRollbackOnly()) {
                tx.commit();
            } else {
                tx.rollback();
            }
        }
    }
}

