/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot.dump;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.ignite.internal.processors.cache.persistence.file.AbstractFileIO;
import org.apache.ignite.internal.util.typedef.internal.A;

public class WriteOnlyZipFileIO
extends AbstractFileIO {
    private final ZipOutputStream zos;
    private final WritableByteChannel ch;
    private long pos;

    public WriteOnlyZipFileIO(File file) throws IOException {
        A.ensure(file.getName().endsWith(".zip"), "File name should end with .zip");
        String entryName = file.getName().substring(0, file.getName().length() - ".zip".length());
        this.zos = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(Paths.get(file.getPath(), new String[0]), new OpenOption[0])));
        this.zos.setLevel(9);
        this.zos.putNextEntry(new ZipEntry(entryName));
        this.ch = Channels.newChannel(this.zos);
    }

    @Override
    public long position() throws IOException {
        return this.pos;
    }

    @Override
    public void position(long newPosition) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(ByteBuffer destBuf) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(ByteBuffer destBuf, long position) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int write(ByteBuffer srcBuf) throws IOException {
        int written = this.ch.write(srcBuf);
        this.pos += (long)written;
        return written;
    }

    @Override
    public int write(ByteBuffer srcBuf, long position) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int write(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MappedByteBuffer map(int sizeBytes) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void force(boolean withMetadata) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void force() throws IOException {
        this.force(false);
    }

    @Override
    public long size() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.zos.closeEntry();
        this.ch.close();
    }

    @Override
    public int getFileSystemBlockSize() {
        return -1;
    }

    @Override
    public int punchHole(long position, int len) {
        return -1;
    }

    @Override
    public long getSparseSize() {
        return -1L;
    }
}

