/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.CacheDistributedGetFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetRequest;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public final class GridNearGetFuture<K, V>
extends CacheDistributedGetFutureAdapter<K, V> {
    private final IgniteTxLocalEx tx;
    private GridCacheVersion ver;

    public GridNearGetFuture(GridCacheContext<K, V> cctx, Collection<KeyCacheObject> keys, boolean readThrough, boolean forcePrimary, @Nullable IgniteTxLocalEx tx, String taskName, boolean deserializeBinary, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer, boolean keepCacheObjects, boolean recovery) {
        super(cctx, keys, readThrough, forcePrimary, taskName, deserializeBinary, expiryPlc, skipVals, needVer, keepCacheObjects, recovery);
        assert (!F.isEmpty(keys));
        this.tx = tx;
        this.ver = tx == null ? cctx.cache().nextVersion() : tx.xidVersion();
        this.initLogger(GridNearGetFuture.class);
    }

    public void init(@Nullable AffinityTopologyVersion topVer) {
        AffinityTopologyVersion lockedTopVer = this.cctx.shared().lockedTopologyVersion(null);
        if (lockedTopVer != null) {
            this.canRemap = false;
            this.map(this.keys, Collections.emptyMap(), lockedTopVer);
        } else {
            AffinityTopologyVersion mapTopVer = topVer;
            if (mapTopVer == null) {
                mapTopVer = this.tx == null ? this.cctx.affinity().affinityTopologyVersion() : this.tx.topologyVersion();
            }
            this.map(this.keys, Collections.emptyMap(), mapTopVer);
        }
        this.markInitialized();
    }

    @Override
    public boolean onDone(Map<K, V> res, Throwable err) {
        if (super.onDone(res, err)) {
            if (this.trackable) {
                this.cctx.mvcc().removeFuture(this.futId);
            }
            this.cache().dht().sendTtlUpdateRequest(this.expiryPlc);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isMini(IgniteInternalFuture<?> f) {
        return f.getClass().equals(MiniFuture.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void map(Collection<KeyCacheObject> keys, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mapped, AffinityTopologyVersion topVer) {
        Collection<ClusterNode> affNodes = CU.affinityNodes(this.cctx, topVer);
        if (affNodes.isEmpty()) {
            assert (!this.cctx.affinityNode());
            this.onDone(new ClusterTopologyServerNotFoundException("Failed to map keys for near-only cache (all partition nodes left the grid)."));
            return;
        }
        HashMap<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mappings = U.newHashMap(affNodes.size());
        Map<KeyCacheObject, GridNearCacheEntry> savedEntries = null;
        boolean success = false;
        try {
            for (KeyCacheObject key : keys) {
                savedEntries = this.map(key, topVer, mappings, mapped, savedEntries);
            }
            success = true;
        }
        finally {
            if (!success) {
                GridCacheVersion obsolete = this.cctx.versions().next(topVer.topologyVersion());
                if (savedEntries != null) {
                    for (GridNearCacheEntry gridNearCacheEntry : savedEntries.values()) {
                        gridNearCacheEntry.releaseEviction();
                        if (!gridNearCacheEntry.markObsolete(obsolete)) continue;
                        gridNearCacheEntry.context().cache().removeEntry(gridNearCacheEntry);
                    }
                }
            }
        }
        if (this.isDone()) {
            return;
        }
        Map<KeyCacheObject, GridNearCacheEntry> saved = savedEntries != null ? savedEntries : Collections.emptyMap();
        int keysSize = keys.size();
        for (Map.Entry entry : mappings.entrySet()) {
            ClusterNode n = (ClusterNode)entry.getKey();
            LinkedHashMap mappedKeys = (LinkedHashMap)entry.getValue();
            assert (!mappedKeys.isEmpty());
            if (n.isLocal()) {
                GridDhtFuture<Collection<GridCacheEntryInfo>> fut = this.dht().getDhtAsync(n.id(), -1L, mappedKeys, false, this.readThrough, topVer, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc, this.skipVals, this.recovery, null, null);
                Collection<Integer> invalidParts = fut.invalidPartitions();
                if (!F.isEmpty(invalidParts)) {
                    ArrayList<KeyCacheObject> remapKeys = new ArrayList<KeyCacheObject>(keysSize);
                    for (KeyCacheObject key : keys) {
                        int part = this.cctx.affinity().partition(key);
                        if (key == null || !invalidParts.contains(part)) continue;
                        this.addNodeAsInvalid(n, part, topVer);
                        remapKeys.add(key);
                    }
                    AffinityTopologyVersion updTopVer = this.cctx.shared().exchange().readyAffinityVersion();
                    this.map(remapKeys, mappings, updTopVer);
                }
                this.add(fut.chain(() -> {
                    try {
                        return this.loadEntries(n.id(), mappedKeys.keySet(), (Collection)fut.get(), saved, topVer);
                    }
                    catch (Exception e) {
                        U.error(log, "Failed to get values from dht cache [fut=" + fut + "]", e);
                        this.onDone(e);
                        return Collections.emptyMap();
                    }
                }));
                continue;
            }
            this.registrateFutureInMvccManager(this);
            MiniFuture miniFut = new MiniFuture(n, mappedKeys, saved, topVer);
            GridNearGetRequest req = miniFut.createGetRequest(this.futId);
            this.add(miniFut);
            try {
                this.cctx.io().send(n, (GridCacheMessage)req, this.cctx.ioPolicy());
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    miniFut.onNodeLeft();
                    continue;
                }
                miniFut.onResult(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<KeyCacheObject, GridNearCacheEntry> map(KeyCacheObject key, AffinityTopologyVersion topVer, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mappings, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mapped, Map<KeyCacheObject, GridNearCacheEntry> saved) {
        int part = this.cctx.affinity().partition(key);
        List<ClusterNode> affNodes = this.cctx.affinity().nodesByPartition(part, topVer);
        if (affNodes.isEmpty()) {
            this.onDone(this.serverNotFoundError(part, topVer));
            return null;
        }
        GridNearCacheAdapter<K, V> near = this.cache();
        boolean allowLocRead = !this.forcePrimary || this.cctx.localNode().equals(affNodes.get(0));
        while (true) {
            GridNearCacheEntry entry;
            block32: {
                entry = allowLocRead ? (GridNearCacheEntry)near.peekEx(key) : null;
                try {
                    boolean isNear;
                    CacheObject v = null;
                    GridCacheVersion ver = null;
                    boolean bl = isNear = entry != null;
                    if (isNear) {
                        if (this.needVer) {
                            EntryGetResult res = entry.innerGetVersioned(null, null, true, !this.skipVals, null, this.taskName, this.expiryPlc, !this.deserializeBinary, null);
                            if (res != null) {
                                v = (CacheObject)res.value();
                                ver = res.version();
                            }
                        } else {
                            v = entry.innerGet(null, this.tx, false, true, !this.skipVals, null, this.taskName, this.expiryPlc, !this.deserializeBinary);
                        }
                    }
                    if (v == null) {
                        Set<ClusterNode> invalidNodesSet;
                        ClusterNode affNode;
                        boolean fastLocGet;
                        boolean bl2 = fastLocGet = allowLocRead && this.cctx.reserveForFastLocalGet(part, topVer);
                        if (fastLocGet) {
                            try {
                                if (this.localDhtGet(key, part, topVer, isNear)) {
                                    return saved;
                                }
                            }
                            catch (IgniteException ex) {
                                this.onDone(ex);
                                Map<KeyCacheObject, GridNearCacheEntry> map = saved;
                                return map;
                            }
                            finally {
                                this.cctx.releaseForFastLocalGet(part, topVer);
                            }
                        }
                        if ((affNode = this.cctx.selectAffinityNodeBalanced(affNodes, invalidNodesSet = this.getInvalidNodes(part, topVer), part, this.canRemap, this.forcePrimary)) != null) {
                            boolean addRdr;
                            if (this.cctx.statisticsEnabled() && !this.skipVals && !affNode.isLocal() && !isNear) {
                                this.cache().metrics0().onRead(false);
                            }
                            if (!this.checkRetryPermits(key, affNode, mapped)) {
                                Map<KeyCacheObject, GridNearCacheEntry> map = saved;
                                return map;
                            }
                            if (!affNodes.contains(this.cctx.localNode())) {
                                GridNearCacheEntry nearEntry = entry != null ? entry : near.entryExx(key, topVer);
                                nearEntry.reserveEviction();
                                entry = null;
                                if (saved == null) {
                                    saved = U.newHashMap(3);
                                }
                                saved.put(key, nearEntry);
                            }
                            boolean bl3 = addRdr = this.tx == null || this.tx.optimistic();
                            if (!addRdr && this.tx.readCommitted() && !this.tx.writeSet().contains(this.cctx.txKey(key))) {
                                addRdr = true;
                            }
                            LinkedHashMap old = mappings.computeIfAbsent(affNode, k -> new LinkedHashMap(3, 1.0f));
                            old.put(key, addRdr);
                            return saved;
                        }
                        break block32;
                    }
                    this.addResult(key, v, ver);
                    return saved;
                }
                catch (IgniteCheckedException e) {
                    this.onDone(e);
                    return saved;
                }
                catch (GridCacheEntryRemovedException gridCacheEntryRemovedException) {
                    continue;
                }
            }
            this.onDone(this.serverNotFoundError(part, topVer));
            return saved;
            finally {
                if (entry == null || this.tx != null) continue;
                entry.touch();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean localDhtGet(KeyCacheObject key, int part, AffinityTopologyVersion topVer, boolean nearRead) {
        GridDhtCacheAdapter<K, V> dht = this.cache().dht();
        assert (dht.context().affinityNode()) : this;
        while (true) {
            boolean bl;
            this.cctx.shared().database().checkpointReadLock();
            GridCacheEntryEx dhtEntry = null;
            try {
                boolean isNew;
                dhtEntry = dht.entryEx(key);
                CacheObject v = null;
                if (dhtEntry != null) {
                    boolean bl2 = isNew = dhtEntry.isNewLocked() || !dhtEntry.valid(topVer);
                    if (this.needVer) {
                        EntryGetResult res = dhtEntry.innerGetVersioned(null, null, false, !nearRead && !this.skipVals, null, this.taskName, this.expiryPlc, !this.deserializeBinary, null);
                        if (res != null) {
                            v = (CacheObject)res.value();
                            this.ver = res.version();
                        }
                    } else {
                        v = dhtEntry.innerGet(null, this.tx, false, false, !nearRead && !this.skipVals, null, this.taskName, this.expiryPlc, !this.deserializeBinary);
                    }
                    if (v == null && isNew && dhtEntry.markObsoleteIfEmpty(this.ver)) {
                        dht.removeEntry(dhtEntry);
                    }
                }
                if (v != null) {
                    if (this.cctx.statisticsEnabled() && !this.skipVals) {
                        this.cache().metrics0().onRead(true);
                    }
                    this.addResult(key, v, this.ver);
                    isNew = true;
                    return isNew;
                }
                boolean topStable = this.cctx.isReplicated() || topVer.equals(this.cctx.topology().lastTopologyChangeVersion());
                boolean bl3 = !this.cctx.readThroughConfigured() && (topStable || this.partitionOwned(part));
                return bl3;
            }
            catch (GridCacheEntryRemovedException v) {
                continue;
            }
            catch (GridDhtInvalidPartitionException ignored) {
                bl = false;
                return bl;
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
                bl = false;
                return bl;
            }
            finally {
                this.cctx.shared().database().checkpointReadUnlock();
                if (dhtEntry == null) continue;
                dhtEntry.touch();
                continue;
            }
            break;
        }
    }

    private void addResult(KeyCacheObject key, CacheObject v, GridCacheVersion ver) {
        if (this.keepCacheObjects) {
            KeyCacheObject key0 = key;
            Object val0 = this.needVer ? new EntryGetResult(this.skipVals ? Boolean.valueOf(true) : v, ver) : (this.skipVals ? Boolean.valueOf(true) : v);
            this.add(new GridFinishedFuture<Map<KeyCacheObject, Object>>(Collections.singletonMap(key0, val0)));
        } else {
            Object key0 = this.cctx.unwrapBinaryIfNeeded(key, !this.deserializeBinary, false, null);
            Object val0 = this.needVer ? new EntryGetResult(!this.skipVals ? this.cctx.unwrapBinaryIfNeeded(v, !this.deserializeBinary, false, null) : Boolean.TRUE, ver) : (!this.skipVals ? this.cctx.unwrapBinaryIfNeeded(v, !this.deserializeBinary, false, null) : Boolean.TRUE);
            this.add(new GridFinishedFuture<Map<Object, Object>>(Collections.singletonMap(key0, val0)));
        }
    }

    private GridNearCacheAdapter<K, V> cache() {
        return (GridNearCacheAdapter)this.cctx.cache();
    }

    private GridDhtCacheAdapter<K, V> dht() {
        return this.cache().dht();
    }

    private Map<K, V> loadEntries(UUID nodeId, Collection<KeyCacheObject> keys, Collection<GridCacheEntryInfo> infos, Map<KeyCacheObject, GridNearCacheEntry> savedEntries, AffinityTopologyVersion topVer) {
        GridLeanMap map;
        boolean empty = F.isEmpty(keys);
        GridLeanMap gridLeanMap = map = empty ? Collections.emptyMap() : new GridLeanMap(keys.size());
        if (!empty) {
            boolean atomic = this.cctx.atomic();
            GridCacheVersion ver = atomic ? null : (F.isEmpty(infos) ? null : this.cctx.cache().nextVersion());
            for (GridCacheEntryInfo info : infos) {
                try {
                    info.unmarshalValue(this.cctx, this.cctx.deploy().globalLoader());
                    if (!this.cctx.affinity().keyLocalNode(info.key(), this.cctx.affinity().affinityTopologyVersion())) {
                        GridNearCacheEntry entry = savedEntries.get(info.key());
                        if (entry == null) {
                            entry = this.cache().entryExx(info.key(), topVer);
                        }
                        entry.loadedValue(this.tx, nodeId, info.value(), atomic ? info.version() : ver, info.version(), info.ttl(), info.expireTime(), true, !this.deserializeBinary, topVer);
                    }
                    CacheObject val = info.value();
                    KeyCacheObject key = info.key();
                    assert (this.skipVals == (info.value() == null));
                    this.cctx.addResult(map, key, val, this.skipVals, this.keepCacheObjects, this.deserializeBinary, false, this.needVer ? info.version() : null, 0L, 0L, U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
                }
                catch (GridCacheEntryRemovedException ignore) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Got removed entry while processing get response (will not retry).");
                }
                catch (Exception e) {
                    this.onDone(e);
                    return Collections.emptyMap();
                }
            }
        }
        return map;
    }

    private void releaseEvictions(Collection<KeyCacheObject> keys, Map<KeyCacheObject, GridNearCacheEntry> saved) {
        for (KeyCacheObject key : keys) {
            GridNearCacheEntry entry = saved.get(key);
            if (entry == null) continue;
            entry.releaseEviction();
            if (this.tx != null) continue;
            entry.touch();
        }
    }

    @Override
    public String toString() {
        return S.toString(GridNearGetFuture.class, this, "super", (Object)super.toString());
    }

    private class MiniFuture
    extends CacheDistributedGetFutureAdapter.AbstractMiniFuture {
        private final Map<KeyCacheObject, GridNearCacheEntry> savedEntries;

        MiniFuture(ClusterNode node, LinkedHashMap<KeyCacheObject, Boolean> keys, Map<KeyCacheObject, GridNearCacheEntry> savedEntries, AffinityTopologyVersion topVer) {
            super(node, keys, topVer);
            this.savedEntries = savedEntries;
        }

        @Override
        protected GridNearGetRequest createGetRequest0(IgniteUuid rootFutId, IgniteUuid futId) {
            return new GridNearGetRequest(GridNearGetFuture.this.cctx.cacheId(), rootFutId, futId, GridNearGetFuture.this.ver, this.keys, GridNearGetFuture.this.readThrough, this.topVer, GridNearGetFuture.this.taskName == null ? 0 : GridNearGetFuture.this.taskName.hashCode(), GridNearGetFuture.this.expiryPlc != null ? GridNearGetFuture.this.expiryPlc.forCreate() : -1L, GridNearGetFuture.this.expiryPlc != null ? GridNearGetFuture.this.expiryPlc.forAccess() : -1L, true, GridNearGetFuture.this.skipVals, GridNearGetFuture.this.cctx.deploymentEnabled(), GridNearGetFuture.this.recovery, null, null);
        }

        @Override
        protected Map<K, V> createResultMap(Collection<GridCacheEntryInfo> entries) {
            return GridNearGetFuture.this.loadEntries(this.node.id(), this.keys.keySet(), entries, this.savedEntries, this.topVer);
        }

        @Override
        public boolean onDone(@Nullable Map<K, V> res, @Nullable Throwable err) {
            if (super.onDone(res, err)) {
                GridNearGetFuture.this.releaseEvictions(this.keys.keySet(), this.savedEntries);
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this);
        }
    }
}

