/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import org.apache.ignite.IgniteException;
import org.apache.ignite.client.ClientAtomicLong;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.ReliableChannel;
import org.jetbrains.annotations.Nullable;

public class ClientAtomicLongImpl
implements ClientAtomicLong {
    private final String name;
    private final String groupName;
    private final ReliableChannel ch;
    private final int cacheId;

    public ClientAtomicLongImpl(String name, @Nullable String groupName, ReliableChannel ch) {
        this.name = name;
        this.groupName = groupName;
        this.ch = ch;
        String groupNameInternal = groupName == null ? "default-ds-group" : groupName;
        this.cacheId = ClientUtils.cacheId("ignite-sys-atomic-cache@" + groupNameInternal);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public long get() throws IgniteException {
        return this.ch.affinityService(this.cacheId, this.affinityKey(), ClientOperation.ATOMIC_LONG_VALUE_GET, this::writeName, in -> in.in().readLong());
    }

    @Override
    public long incrementAndGet() throws IgniteException {
        return this.addAndGet(1L);
    }

    @Override
    public long getAndIncrement() throws IgniteException {
        return this.incrementAndGet() - 1L;
    }

    @Override
    public long addAndGet(long l) throws IgniteException {
        return this.ch.affinityService(this.cacheId, this.affinityKey(), ClientOperation.ATOMIC_LONG_VALUE_ADD_AND_GET, out -> {
            this.writeName((PayloadOutputChannel)out);
            out.out().writeLong(l);
        }, in -> in.in().readLong());
    }

    @Override
    public long getAndAdd(long l) throws IgniteException {
        return this.addAndGet(l) - l;
    }

    @Override
    public long decrementAndGet() throws IgniteException {
        return this.addAndGet(-1L);
    }

    @Override
    public long getAndDecrement() throws IgniteException {
        return this.decrementAndGet() + 1L;
    }

    @Override
    public long getAndSet(long l) throws IgniteException {
        return this.ch.affinityService(this.cacheId, this.affinityKey(), ClientOperation.ATOMIC_LONG_VALUE_GET_AND_SET, out -> {
            this.writeName((PayloadOutputChannel)out);
            out.out().writeLong(l);
        }, in -> in.in().readLong());
    }

    @Override
    public boolean compareAndSet(long expVal, long newVal) throws IgniteException {
        return this.ch.affinityService(this.cacheId, this.affinityKey(), ClientOperation.ATOMIC_LONG_VALUE_COMPARE_AND_SET, out -> {
            this.writeName((PayloadOutputChannel)out);
            out.out().writeLong(expVal);
            out.out().writeLong(newVal);
        }, in -> in.in().readBoolean());
    }

    @Override
    public boolean removed() {
        return this.ch.affinityService(this.cacheId, this.affinityKey(), ClientOperation.ATOMIC_LONG_EXISTS, this::writeName, in -> !in.in().readBoolean());
    }

    @Override
    public void close() {
        this.ch.affinityService(this.cacheId, this.affinityKey(), ClientOperation.ATOMIC_LONG_REMOVE, this::writeName, null);
    }

    private void writeName(PayloadOutputChannel out) {
        try (BinaryWriterExImpl w = new BinaryWriterExImpl(null, out.out(), null, null);){
            w.writeString(this.name);
            w.writeString(this.groupName);
        }
    }

    private String affinityKey() {
        return this.name;
    }
}

