/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.impl;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFuture;
import org.apache.ignite.internal.client.GridClientFutureListener;
import org.apache.ignite.internal.client.GridClientFutureTimeoutException;
import org.apache.ignite.internal.client.impl.GridClientFutureCallback;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.jetbrains.annotations.Nullable;

public class GridClientFutureAdapter<R>
extends AbstractQueuedSynchronizer
implements GridClientFuture<R> {
    private static final long serialVersionUID = 0L;
    private static final int INIT = 0;
    private static final int DONE = 1;
    private static final Logger log = Logger.getLogger(GridClientFutureAdapter.class.getName());
    private final ConcurrentLinkedQueue<DoneCallback> cbs = new ConcurrentLinkedQueue();
    private R res;
    private Throwable err;
    private volatile boolean done;

    public GridClientFutureAdapter() {
    }

    public GridClientFutureAdapter(R res) {
        this.onDone(res, null);
    }

    public GridClientFutureAdapter(Throwable err) {
        this.onDone(null, err);
    }

    @Override
    public R get() throws GridClientException {
        try {
            if (!this.done) {
                this.acquireSharedInterruptibly(0);
            }
            return this.getResult();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GridClientException("Operation was interrupted.", e);
        }
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws GridClientException {
        A.ensure(timeout >= 0L, "timeout >= 0");
        try {
            if (!this.done && !this.tryAcquireSharedNanos(0, unit.toNanos(timeout))) {
                throw new GridClientFutureTimeoutException("Failed to get future result due to waiting timed out.");
            }
        }
        catch (InterruptedException e) {
            throw new GridClientException("Operation was interrupted.", e);
        }
        return this.getResult();
    }

    private R getResult() throws GridClientException {
        assert (this.getState() == 1);
        if (this.err == null) {
            return this.res;
        }
        if (this.err instanceof Error) {
            throw (Error)this.err;
        }
        if (this.err instanceof GridClientException) {
            throw (GridClientException)this.err;
        }
        throw new GridClientException(this.err);
    }

    @Override
    public boolean isDone() {
        return this.getState() != 0;
    }

    public void onDone(@Nullable R res) {
        this.onDone(res, null);
    }

    public void onDone(Throwable err) {
        assert (err != null);
        this.onDone(null, err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onDone(@Nullable R res, @Nullable Throwable err) {
        boolean notify = false;
        try {
            if (this.compareAndSetState(0, 1)) {
                this.res = res;
                this.err = err;
                notify = true;
                this.releaseShared(0);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (notify) {
                this.fireDone();
            }
        }
    }

    @Override
    protected final int tryAcquireShared(int ignore) {
        return this.done ? 1 : -1;
    }

    @Override
    protected final boolean tryReleaseShared(int ignore) {
        this.done = true;
        return true;
    }

    @Override
    public void listen(GridClientFutureListener<R> ... lsnrs) {
        assert (lsnrs != null);
        for (GridClientFutureListener<R> lsnr : lsnrs) {
            this.cbs.add(new DoneCallback(null, lsnr, null));
        }
        if (this.isDone()) {
            this.fireDone();
        }
    }

    public <T> GridClientFutureAdapter<T> chain(GridClientFutureCallback<R, T> cb) {
        GridClientFutureAdapter<R> fut = new GridClientFutureAdapter<R>();
        this.cbs.add(new DoneCallback(cb, null, fut));
        if (this.isDone()) {
            this.fireDone();
        }
        return fut;
    }

    private void fireDone() {
        DoneCallback cb;
        assert (this.isDone());
        Error err = null;
        while ((cb = this.cbs.poll()) != null) {
            try {
                cb.proceed();
            }
            catch (Error e) {
                if (err == null) {
                    err = e;
                    continue;
                }
                log.log(Level.WARNING, "Failed to notify future callback due to unhandled error.", e);
            }
        }
        if (err != null) {
            throw err;
        }
    }

    private class DoneCallback<T> {
        private final GridClientFutureCallback<R, T> cb;
        private final GridClientFutureListener<R> lsnr;
        private final GridClientFutureAdapter<T> chainedFut;

        private DoneCallback(GridClientFutureCallback<R, T> cb, GridClientFutureListener<R> lsnr, GridClientFutureAdapter<T> chainedFut) {
            this.cb = cb;
            this.lsnr = lsnr;
            this.chainedFut = chainedFut;
        }

        public void proceed() {
            GridClientFutureAdapter fut = GridClientFutureAdapter.this;
            assert (fut.isDone());
            try {
                if (this.lsnr != null) {
                    this.lsnr.onDone(fut);
                }
                Object res = null;
                if (this.cb != null) {
                    res = this.cb.onComplete(fut);
                }
                if (this.chainedFut != null) {
                    this.chainedFut.onDone(res);
                }
            }
            catch (GridClientException e) {
                if (this.chainedFut != null) {
                    this.chainedFut.onDone(e);
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Failed to notify chained callback due to unhandled client exception [fut=" + fut + ", cb=" + this.cb + ", chainedFut=" + this.chainedFut + ']', e);
                }
            }
            catch (RuntimeException e) {
                if (this.chainedFut != null) {
                    this.chainedFut.onDone(e);
                }
                log.log(Level.WARNING, "Failed to notify chained callback due to unhandled runtime exception [fut=" + fut + ", cb=" + this.cb + ", chainedFut=" + this.chainedFut + ']', e);
            }
            catch (Error e) {
                if (this.chainedFut != null) {
                    this.chainedFut.onDone(e);
                }
                throw e;
            }
        }
    }
}

