/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.as4p.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

public abstract class AbstractValidator
extends InputVerifier
implements KeyListener {
    private JDialog popup;
    private Object parent;
    private JLabel messageLabel;
    private JLabel image;
    private Point point;
    private Dimension cDim;
    private Color color = new Color(243, 255, 159);

    private AbstractValidator() {
    }

    private AbstractValidator(JComponent c, String message) {
        this();
        c.addKeyListener(this);
        this.messageLabel = new JLabel(message + " ");
        this.image = new JLabel(new ImageIcon("exception_16x16.png"));
    }

    public AbstractValidator(JDialog parent, JComponent c, String message) {
        this(c, message);
        this.parent = parent;
        this.popup = new JDialog(parent);
        this.initComponents();
    }

    public AbstractValidator(JFrame parent, JComponent c, String message) {
        this(c, message);
        this.parent = parent;
        this.popup = new JDialog(parent);
        this.initComponents();
    }

    protected abstract boolean validationCriteria(JComponent var1);

    @Override
    public boolean verify(JComponent c) {
        if (!this.validationCriteria(c)) {
            c.setBackground(Color.PINK);
            this.popup.setSize(0, 0);
            this.popup.setLocationRelativeTo(c);
            this.point = this.popup.getLocation();
            this.cDim = c.getSize();
            this.popup.setLocation(this.point.x - (int)this.cDim.getWidth() / 2, this.point.y + (int)this.cDim.getHeight() / 2);
            this.popup.pack();
            this.popup.setVisible(true);
            return false;
        }
        c.setBackground(Color.WHITE);
        return true;
    }

    protected void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.popup.setVisible(false);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void initComponents() {
        this.popup.getContentPane().setLayout(new FlowLayout());
        this.popup.setUndecorated(true);
        this.popup.getContentPane().setBackground(this.color);
        this.popup.getContentPane().add(this.image);
        this.popup.getContentPane().add(this.messageLabel);
        this.popup.setFocusableWindowState(false);
    }
}

