/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.ai;

import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.Key;
import java.security.KeyStore;
import java.security.PublicKey;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class Security {
    public static void encryptFile(String key, String inputFile, String outputFile) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, secretKey);
        Path inputPath = Paths.get(inputFile, new String[0]);
        byte[] fileBytes = Files.readAllBytes(inputPath);
        byte[] encryptedBytes = cipher.doFinal(fileBytes);
        Path outputPath = Paths.get(outputFile, new String[0]);
        Files.write(outputPath, Base64.getEncoder().encode(encryptedBytes), StandardOpenOption.CREATE);
        System.out.println("Archivo cifrado exitosamente.");
    }

    public static String encryptText(String key, String text) throws Exception {
        String outputText = "";
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, secretKey);
        byte[] encryptedBytes = cipher.doFinal(text.getBytes());
        outputText = new String(Base64.getEncoder().encode(encryptedBytes));
        System.out.println("Archivo cifrado exitosamente.");
        return outputText;
    }

    public static String decryptText(String key, String text) throws Exception {
        String outputText = "";
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, secretKey);
        byte[] decryptedBytes = cipher.doFinal(Base64.getDecoder().decode(text.getBytes()));
        outputText = new String(decryptedBytes);
        System.out.println("Archivo descifrado exitosamente.");
        return outputText;
    }

    public static void decryptFile(String key, String inputFile, String outputFile) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, secretKey);
        Path inputPath = Paths.get(inputFile, new String[0]);
        byte[] encryptedBytes = Base64.getDecoder().decode(Files.readAllBytes(inputPath));
        byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
        Path outputPath = Paths.get(outputFile, new String[0]);
        Files.write(outputPath, decryptedBytes, StandardOpenOption.CREATE);
        System.out.println("Archivo descifrado exitosamente.");
    }

    public static String getPublicKeyFromKeystore(String keystoreFile, String keystorePassword, String alias, String keyStoreType) throws Exception {
        KeyStore keystore = KeyStore.getInstance(keyStoreType.toUpperCase());
        try (FileInputStream fis = new FileInputStream(keystoreFile);){
            keystore.load(fis, keystorePassword.toCharArray());
        }
        Key key = keystore.getKey(alias, keystorePassword.toCharArray());
        PublicKey pKey = keystore.getCertificate(alias).getPublicKey();
        return Base64.getEncoder().encodeToString(pKey.getEncoded());
    }
}

