/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.ai;

import cl.mc3d.ai.Security;
import cl.mc3d.gpt4all.LLModel;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.lang.IgniteBiTuple;

public class GridSuscribeFile
implements Runnable {
    private Thread thread = null;
    private IgniteCache igniteCache = null;
    private String cacheName = null;
    private LLModel model;
    private LLModel.GenerationConfig config;
    private String modelPromptTemplate;
    private String hostname = "";
    private String cipherMessage = "";
    private String keyStorePass = "";
    private String locationStart;

    public GridSuscribeFile(String locationStart, IgniteCache igniteCache, String cacheName, LLModel model, LLModel.GenerationConfig config, String modelPromptTemplate, String cipherMessage, String keyStorePass) {
        this.locationStart = locationStart;
        this.igniteCache = igniteCache;
        this.cacheName = cacheName;
        this.model = model;
        this.cipherMessage = cipherMessage;
        this.keyStorePass = keyStorePass;
        this.config = config;
        this.modelPromptTemplate = modelPromptTemplate;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.hostname = addr.getHostName();
        }
        catch (UnknownHostException ex) {
            System.out.println("Hostname can not be resolved");
        }
    }

    public void createFolderIfNotExists(String folder) {
        File fQuestionsFolder = new File(folder);
        if (!fQuestionsFolder.exists()) {
            fQuestionsFolder.mkdirs();
        }
    }

    public synchronized String response(String sPreProcessedFolder, String questionsProcessedFolder, String responseFolder) {
        String data = "";
        Iterator iCache = this.igniteCache.iterator();
        while (iCache.hasNext()) {
            try {
                long leasing;
                long lLock;
                long lCurrent;
                IgniteBiTuple igniteBiTuple = (IgniteBiTuple)iCache.next();
                String uuid = igniteBiTuple.get1().toString();
                if (this.igniteCache.get((Object)(uuid + "-lock")) != null && (lCurrent = System.currentTimeMillis()) - (lLock = ((Long)this.igniteCache.get((Object)(uuid + "-lock"))).longValue()) >= (leasing = 300000L)) {
                    String sStep = uuid + "-lock, timeout 300000";
                    System.out.println(sStep);
                    this.igniteCache.remove((Object)(uuid + "-lock"));
                }
                if (!uuid.endsWith(")") || this.igniteCache.get((Object)(uuid + "-lock")) != null) continue;
                this.igniteCache.put((Object)(uuid + "-lock"), (Object)System.currentTimeMillis());
                Properties pData = (Properties)igniteBiTuple.get2();
                String sQuestion = pData.getProperty(uuid);
                if (this.cipherMessage.equals("true")) {
                    try {
                        String publicKey;
                        String sKey = publicKey = Security.getPublicKeyFromKeystore(this.cacheName + ".pfx", this.keyStorePass, this.cacheName, "PKCS12");
                        if (sKey.lastIndexOf("==") != -1) {
                            sKey = sKey.substring(0, sKey.lastIndexOf("=="));
                            sKey = sKey.substring(sKey.length() - 32, sKey.length());
                            sQuestion = Security.decryptText(sKey, sQuestion);
                        }
                    }
                    catch (Exception publicKey) {
                        // empty catch block
                    }
                }
                String sStep = new Date() + ", Take event: " + uuid + ", data:" + sQuestion;
                System.out.println(sStep);
                if (sQuestion.length() > 3) {
                    try {
                        System.out.println("GPU available: " + this.model.llmodel_has_gpu_device());
                        System.out.println("Model Loaded: " + this.model.llmodel_isModelLoaded());
                        String fullGeneration = this.model.generate(sQuestion, this.config, this.modelPromptTemplate, false, true, null);
                        if (this.cipherMessage.equals("true")) {
                            try {
                                String publicKey;
                                String sKey = publicKey = Security.getPublicKeyFromKeystore(this.cacheName + ".pfx", this.keyStorePass, this.cacheName, "PKCS12");
                                if (sKey.lastIndexOf("==") != -1) {
                                    sKey = sKey.substring(0, sKey.lastIndexOf("=="));
                                    sKey = sKey.substring(sKey.length() - 32, sKey.length());
                                    fullGeneration = Security.encryptText(sKey, fullGeneration);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.igniteCache.put((Object)(uuid + "-rsp"), (Object)fullGeneration);
                        sStep = new Date() + ", Response to event: " + uuid + "-rsp, fullGeneration: " + fullGeneration;
                        System.out.println(sStep);
                    }
                    catch (Exception ex) {
                        sStep = "Error in process lLM: " + ex.toString();
                        Logger.getLogger(GridSuscribeFile.class.getName()).log(Level.SEVERE, sStep);
                    }
                } else {
                    sStep = "\rEvent empty detected uuid: " + uuid;
                    System.out.println(sStep);
                }
                this.igniteCache.remove((Object)uuid);
                this.igniteCache.remove((Object)(uuid + "-lock"));
            }
            catch (Exception e) {
                String sStep = "\nResponse error: " + e.toString();
                System.out.println(sStep);
            }
        }
        return data;
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
        }
        this.thread.start();
    }

    @Override
    public void run() {
        String sPreProcessedFolder = "questions_pre-processed";
        String sQuestionsProcessedFolder = "questions_processed";
        String sResponsesFolder = "responses";
        while (true) {
            try {
                while (true) {
                    this.createFolderIfNotExists(sQuestionsProcessedFolder);
                    this.createFolderIfNotExists(sResponsesFolder);
                    this.response(sPreProcessedFolder, sQuestionsProcessedFolder, sResponsesFolder);
                    Thread.sleep(50L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

