/*
 * Decompiled with CFR 0.152.
 */
package cl.mc3d.ai;

import cl.mc3d.ai.Security;
import cl.mc3d.gpt4all.LLModel;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.lang.IgniteBiTuple;

public class GridDownloadResponse
implements Runnable {
    private Thread thread = null;
    private IgniteCache igniteCache = null;
    private String cacheName = null;
    private LLModel model;
    private LLModel.GenerationConfig config;
    private String modelPromptTemplate;
    private String hostname = "";
    private String cipherMessage = "";
    private String keyStorePass = "";
    private String locationStart;

    public GridDownloadResponse(String locationStart, IgniteCache igniteCache, String cacheName, LLModel model, LLModel.GenerationConfig config, String modelPromptTemplate, String cipherMessage, String keyStorePass) {
        this.locationStart = locationStart;
        this.igniteCache = igniteCache;
        this.cacheName = cacheName;
        this.model = model;
        this.cipherMessage = cipherMessage;
        this.keyStorePass = keyStorePass;
        this.config = config;
        this.modelPromptTemplate = modelPromptTemplate;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.hostname = addr.getHostName();
        }
        catch (UnknownHostException ex) {
            System.out.println("Hostname can not be resolved");
        }
    }

    public void createFolderIfNotExists(String folder) {
        File fQuestionsFolder = new File(folder);
        if (!fQuestionsFolder.exists()) {
            fQuestionsFolder.mkdirs();
        }
    }

    public synchronized String DownloadResponse(String sPreProcessedFolder, String questionsProcessedFolder, String responseFolder) {
        String data = "";
        Iterator iCache = this.igniteCache.iterator();
        while (iCache.hasNext()) {
            try {
                IgniteBiTuple igniteBiTuple = (IgniteBiTuple)iCache.next();
                String uuid = igniteBiTuple.get1().toString();
                if (!uuid.endsWith("-rsp") || !uuid.contains("-" + this.hostname + "_" + this.locationStart.hashCode() + "-(")) continue;
                String sStep = "\r\nLocal file detected, download: " + uuid;
                System.out.println(sStep);
                RandomAccessFile fResult = new RandomAccessFile(responseFolder + "/" + uuid + ".txt", "rw");
                String sResponse = "" + this.igniteCache.get((Object)uuid);
                if (this.cipherMessage.equals("true")) {
                    try {
                        String publicKey;
                        String sKey = publicKey = Security.getPublicKeyFromKeystore(this.cacheName + ".pfx", this.keyStorePass, this.cacheName, "PKCS12");
                        if (sKey.lastIndexOf("==") != -1) {
                            sKey = sKey.substring(0, sKey.lastIndexOf("=="));
                            sKey = sKey.substring(sKey.length() - 32, sKey.length());
                            sResponse = Security.decryptText(sKey, sResponse);
                        }
                    }
                    catch (Exception publicKey) {
                        // empty catch block
                    }
                }
                fResult.writeBytes("" + sResponse);
                fResult.close();
                File fFile = new File(sPreProcessedFolder + "/" + uuid + ".txt");
                fFile.renameTo(new File(questionsProcessedFolder + "/" + uuid + ".txt"));
                this.igniteCache.remove((Object)uuid);
            }
            catch (Exception e) {
                String sStep = "\nResponse error: " + e.toString();
                System.out.println(sStep);
            }
        }
        return data;
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
        }
        this.thread.start();
    }

    @Override
    public void run() {
        String sPreProcessedFolder = "questions_pre-processed";
        String sQuestionsProcessedFolder = "questions_processed";
        String sResponsesFolder = "responses";
        while (true) {
            try {
                while (true) {
                    this.createFolderIfNotExists(sQuestionsProcessedFolder);
                    this.createFolderIfNotExists(sResponsesFolder);
                    this.DownloadResponse(sPreProcessedFolder, sQuestionsProcessedFolder, sResponsesFolder);
                    Thread.sleep(50L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

