/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi;

import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiOperationTimeoutException;

public class IgniteSpiOperationTimeoutHelper {
    private final boolean timeoutEnabled;
    private final long timeoutThreshold;

    public IgniteSpiOperationTimeoutHelper(IgniteSpiAdapter adapter, boolean srvOp) {
        this(adapter, srvOp, -1L, -1L);
    }

    public IgniteSpiOperationTimeoutHelper(IgniteSpiAdapter adapter, boolean srvOp, long lastRelatedOperationTime, long absoluteThreshold) {
        this.timeoutEnabled = adapter.failureDetectionTimeoutEnabled();
        if (this.timeoutEnabled) {
            long timeout = (lastRelatedOperationTime > 0L ? lastRelatedOperationTime : System.nanoTime()) + U.millisToNanos(srvOp ? adapter.failureDetectionTimeout() : adapter.clientFailureDetectionTimeout());
            if (absoluteThreshold > 0L && timeout > absoluteThreshold) {
                timeout = absoluteThreshold;
            }
            this.timeoutThreshold = timeout;
        } else {
            this.timeoutThreshold = absoluteThreshold > 0L ? absoluteThreshold : 0L;
        }
    }

    public long nextTimeoutChunk(long dfltTimeout) throws IgniteSpiOperationTimeoutException {
        long left;
        long now = System.nanoTime();
        if (this.timeoutEnabled) {
            left = this.timeoutThreshold - now;
        } else {
            left = U.millisToNanos(dfltTimeout);
            if (this.timeoutThreshold > 0L && now + left >= this.timeoutThreshold) {
                left = this.timeoutThreshold - now;
            }
        }
        if (left <= 0L) {
            throw new IgniteSpiOperationTimeoutException("Network operation timed out.");
        }
        return U.nanosToMillis(left);
    }

    public boolean checkFailureTimeoutReached(Exception e) {
        return X.hasCause((Throwable)e, IgniteSpiOperationTimeoutException.class, SocketTimeoutException.class, SocketException.class);
    }
}

