/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.offheap.unsafe;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.offheap.GridOffHeapEvent;
import org.apache.ignite.internal.util.offheap.GridOffHeapEventListener;
import org.apache.ignite.internal.util.offheap.GridOffHeapOutOfMemoryException;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;

public class GridUnsafeMemory {
    private static final byte FREE = 0;
    private static final boolean SAFE_RELEASE = IgniteSystemProperties.getBoolean("IGNITE_OFFHEAP_SAFE_RELEASE");
    @GridToStringInclude
    private final long total;
    @GridToStringInclude
    private final AtomicLong allocated;
    @GridToStringInclude
    private final AtomicLong sysAllocated;
    private GridOffHeapEventListener lsnr;

    public GridUnsafeMemory(long total) {
        assert (total >= 0L);
        this.total = total;
        this.allocated = new AtomicLong();
        this.sysAllocated = new AtomicLong();
    }

    public void listen(GridOffHeapEventListener lsnr) {
        this.lsnr = lsnr;
    }

    public boolean reserve(long size) {
        long max;
        if (this.total == 0L) {
            this.allocated.addAndGet(size);
            return true;
        }
        long mem = this.allocated.addAndGet(size);
        return mem <= (max = this.total);
    }

    public long allocate(long size) throws GridOffHeapOutOfMemoryException {
        return this.allocate(size, false, false);
    }

    public long allocate(long size, boolean init) throws GridOffHeapOutOfMemoryException {
        return this.allocate(size, init, false);
    }

    public long allocate(long size, boolean init, boolean reserved) throws GridOffHeapOutOfMemoryException {
        return this.allocate0(size, init, reserved, this.allocated);
    }

    public long allocateSystem(long size, boolean init) throws GridOffHeapOutOfMemoryException {
        return this.allocate0(size, init, false, this.sysAllocated);
    }

    private long allocate0(long size, boolean init, boolean reserved, AtomicLong cnt) throws GridOffHeapOutOfMemoryException {
        assert (size > 0L);
        if (!reserved) {
            cnt.addAndGet(size);
        }
        try {
            long ptr = GridUnsafe.allocateMemory(size);
            if (init) {
                GridUnsafe.zeroMemory(ptr, size);
            }
            if (this.lsnr != null) {
                this.lsnr.onEvent(GridOffHeapEvent.ALLOCATE);
            }
            return ptr;
        }
        catch (OutOfMemoryError ignore) {
            if (!reserved) {
                cnt.addAndGet(-size);
            }
            throw new GridOffHeapOutOfMemoryException(this.totalSize(), size);
        }
    }

    public void fill(long ptr, long size, byte b) {
        GridUnsafe.setMemory(ptr, size, b);
    }

    public void release(long ptr, long size) {
        this.release0(ptr, size, this.allocated);
    }

    public void releaseSystem(long ptr, long size) {
        this.release0(ptr, size, this.sysAllocated);
    }

    private void release0(long ptr, long size, AtomicLong cnt) {
        if (ptr != 0L) {
            if (SAFE_RELEASE) {
                this.fill(ptr, size, (byte)-85);
            }
            GridUnsafe.freeMemory(ptr);
            cnt.addAndGet(-size);
            if (this.lsnr != null) {
                this.lsnr.onEvent(GridOffHeapEvent.RELEASE);
            }
        }
    }

    public long readLong(long ptr) {
        return GridUnsafe.getLong(ptr);
    }

    public void writeLong(long ptr, long v) {
        GridUnsafe.putLong(ptr, v);
    }

    public long readLongVolatile(long ptr) {
        return GridUnsafe.getLongVolatile(null, ptr);
    }

    public void writeLongVolatile(long ptr, long v) {
        GridUnsafe.putLongVolatile(null, ptr, v);
    }

    public boolean casLong(long ptr, long exp, long v) {
        return GridUnsafe.compareAndSwapLong(null, ptr, exp, v);
    }

    public int readInt(long ptr) {
        return GridUnsafe.getInt(ptr);
    }

    public void writeInt(long ptr, int v) {
        GridUnsafe.putInt(ptr, v);
    }

    public int readIntVolatile(long ptr) {
        return GridUnsafe.getIntVolatile(null, ptr);
    }

    public void writeIntVolatile(long ptr, int v) {
        GridUnsafe.putIntVolatile(null, ptr, v);
    }

    public boolean casInt(long ptr, int exp, int v) {
        return GridUnsafe.compareAndSwapInt(null, ptr, exp, v);
    }

    public float readFloat(long ptr) {
        return GridUnsafe.getFloat(ptr);
    }

    public void writeFloat(long ptr, float v) {
        GridUnsafe.putFloat(ptr, v);
    }

    public double readDouble(long ptr) {
        return GridUnsafe.getDouble(ptr);
    }

    public void writeDouble(long ptr, double v) {
        GridUnsafe.putDouble(ptr, v);
    }

    public short readShort(long ptr) {
        return GridUnsafe.getShort(ptr);
    }

    public void writeShort(long ptr, short v) {
        GridUnsafe.putShort(ptr, v);
    }

    public byte readByte(long ptr) {
        return GridUnsafe.getByte(ptr);
    }

    public byte readByteVolatile(long ptr) {
        return GridUnsafe.getByteVolatile(null, ptr);
    }

    public void writeByte(long ptr, byte v) {
        GridUnsafe.putByte(ptr, v);
    }

    public void writeByteVolatile(long ptr, byte v) {
        GridUnsafe.putByteVolatile(null, ptr, v);
    }

    public long putOffHeap(long ptr, byte[] val, byte type) {
        int allocated;
        int size = val.length;
        assert (size != 0);
        int n = allocated = ptr == 0L ? 0 : this.readInt(ptr);
        if (allocated != size) {
            if (ptr != 0L) {
                this.release(ptr, allocated + 5);
            }
            ptr = this.allocate(size + 5);
            this.writeInt(ptr, size);
        }
        this.writeByte(ptr + 4L, type);
        this.writeBytes(ptr + 5L, val);
        return ptr;
    }

    public void removeOffHeap(long ptr) {
        if (ptr != 0L) {
            this.release(ptr, this.readInt(ptr) + 5);
        }
    }

    public IgniteBiTuple<byte[], Byte> get(long ptr) {
        assert (ptr != 0L);
        int size = this.readInt(ptr);
        byte type = this.readByte(ptr + 4L);
        byte[] bytes = this.readBytes(ptr + 5L, size);
        return new IgniteBiTuple<byte[], Byte>(bytes, type);
    }

    public static boolean compare(long ptr1, long ptr2, int size) {
        assert (ptr1 > 0L) : ptr1;
        assert (ptr2 > 0L) : ptr2;
        assert (size > 0) : size;
        if (ptr1 == ptr2) {
            return true;
        }
        int words = size / 8;
        for (int i = 0; i < words; ++i) {
            long w2;
            long w1 = GridUnsafe.getLong(ptr1);
            if (w1 != (w2 = GridUnsafe.getLong(ptr2))) {
                return false;
            }
            ptr1 += 8L;
            ptr2 += 8L;
        }
        int left = size % 8;
        for (int i = 0; i < left; ++i) {
            byte b2;
            byte b1 = GridUnsafe.getByte(ptr1);
            if (b1 != (b2 = GridUnsafe.getByte(ptr2))) {
                return false;
            }
            ++ptr1;
            ++ptr2;
        }
        return true;
    }

    public static boolean compare(long ptr, byte[] bytes) {
        return GridUnsafeMemory.compare(ptr, bytes, 0, bytes.length);
    }

    public static boolean compare(long ptr, byte[] bytes, int bytesOff, int len) {
        int i;
        assert (bytesOff + len <= bytes.length) : "Check compare bounds: [offset=" + bytesOff + ", len=" + len + ", bytes.length=" + bytes.length + ']';
        int addrSize = GridUnsafe.ADDR_SIZE;
        int off = (int)(ptr % (long)addrSize);
        int align = addrSize - off;
        if (align != addrSize) {
            int i2 = 0;
            int tmpOff = bytesOff;
            while (i2 < align && i2 < len) {
                if (GridUnsafe.getByte(ptr) != bytes[tmpOff]) {
                    return false;
                }
                ++i2;
                ++tmpOff;
                ++ptr;
            }
        } else {
            align = 0;
        }
        if (len <= align) {
            return true;
        }
        assert (ptr % (long)addrSize == 0L) : "Invalid alignment [ptr=" + ptr + ", addrSize=" + addrSize + ", mod=" + ptr % (long)addrSize + ']';
        int words = (len - align) / addrSize;
        int left = (len - align) % addrSize;
        switch (addrSize) {
            case 4: {
                int step;
                for (i = 0; i < words; ++i) {
                    int comp;
                    step = i * addrSize + align;
                    int word = GridUnsafe.getInt(ptr);
                    if (word != (comp = GridUnsafe.getInt(bytes, GridUnsafe.BYTE_ARR_OFF + (long)step + (long)bytesOff))) {
                        return false;
                    }
                    ptr += (long)GridUnsafe.ADDR_SIZE;
                }
                break;
            }
            default: {
                int step;
                for (i = 0; i < words; ++i) {
                    long comp;
                    step = i * addrSize + align;
                    long word = GridUnsafe.getLong(ptr);
                    if (word != (comp = GridUnsafe.getLong(bytes, GridUnsafe.BYTE_ARR_OFF + (long)step + (long)bytesOff))) {
                        return false;
                    }
                    ptr += (long)GridUnsafe.ADDR_SIZE;
                }
            }
        }
        if (left != 0) {
            for (i = 0; i < left; ++i) {
                if (GridUnsafe.getByte(ptr + (long)i) == bytes[bytesOff + i + align + words * GridUnsafe.ADDR_SIZE]) continue;
                return false;
            }
        }
        return true;
    }

    public byte[] readBytes(long ptr, int cnt) {
        return this.readBytes(ptr, new byte[cnt]);
    }

    public byte[] readBytes(long ptr, byte[] arr) {
        GridUnsafe.copyOffheapHeap(ptr, arr, GridUnsafe.BYTE_ARR_OFF, arr.length);
        return arr;
    }

    public byte[] readBytes(long ptr, byte[] arr, int off, int len) {
        GridUnsafe.copyOffheapHeap(ptr, arr, GridUnsafe.BYTE_ARR_OFF + (long)off, len);
        return arr;
    }

    public void writeBytes(long ptr, byte[] arr) {
        GridUnsafe.copyHeapOffheap(arr, GridUnsafe.BYTE_ARR_OFF, ptr, arr.length);
    }

    public void writeBytes(long ptr, byte[] arr, int off, int len) {
        GridUnsafe.copyHeapOffheap(arr, GridUnsafe.BYTE_ARR_OFF + (long)off, ptr, len);
    }

    public void copyMemory(long srcPtr, long destPtr, long len) {
        GridUnsafe.copyOffheapOffheap(srcPtr, destPtr, len);
    }

    public boolean unlimited() {
        return this.totalSize() == 0L;
    }

    public long totalSize() {
        return this.total;
    }

    public long freeSize() {
        if (this.total == 0L) {
            return 0L;
        }
        long diff = this.total - this.allocated.get();
        return diff < 0L ? 0L : diff;
    }

    public long allocatedSize() {
        return this.allocated.get();
    }

    public long systemAllocatedSize() {
        return this.sysAllocated.get();
    }

    public String toString() {
        return S.toString(GridUnsafeMemory.class, this);
    }
}

