/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class GridStripedSpinBusyLock {
    private static int WRITER_MASK = 0x40000000;
    private static final int DFLT_STRIPE_CNT = Runtime.getRuntime().availableProcessors() * 4;
    private static ThreadLocal<Integer> THREAD_IDX = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return new Random().nextInt(Integer.MAX_VALUE);
        }
    };
    private final AtomicInteger[] states;

    public GridStripedSpinBusyLock() {
        this(DFLT_STRIPE_CNT);
    }

    public GridStripedSpinBusyLock(int stripeCnt) {
        this.states = new AtomicInteger[stripeCnt];
        for (int i = 0; i < stripeCnt; ++i) {
            this.states[i] = new AtomicInteger();
        }
    }

    public boolean enterBusy() {
        int val = this.state().incrementAndGet();
        if ((val & WRITER_MASK) == WRITER_MASK) {
            this.leaveBusy();
            return false;
        }
        return true;
    }

    public void leaveBusy() {
        this.state().decrementAndGet();
    }

    public void block() {
        for (AtomicInteger state : this.states) {
            int oldVal;
            while (!state.compareAndSet(oldVal = state.get(), oldVal | WRITER_MASK)) {
            }
        }
        boolean interrupt = false;
        for (AtomicInteger state : this.states) {
            while (state.get() != WRITER_MASK) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignored) {
                    interrupt = true;
                }
            }
        }
        if (interrupt) {
            Thread.currentThread().interrupt();
        }
    }

    private AtomicInteger state() {
        return this.states[THREAD_IDX.get() % this.states.length];
    }
}

