/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.handlers.query.CacheQueryFieldsMetaResult;
import org.apache.ignite.internal.processors.rest.handlers.query.CacheQueryResult;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.processors.rest.request.RestQueryRequest;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;

public class QueryCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> SUPPORTED_COMMANDS = U.sealList(GridRestCommand.EXECUTE_SQL_QUERY, GridRestCommand.EXECUTE_SQL_FIELDS_QUERY, GridRestCommand.EXECUTE_SCAN_QUERY, GridRestCommand.FETCH_SQL_QUERY, GridRestCommand.CLOSE_SQL_QUERY);
    private static final AtomicLong qryIdGen = new AtomicLong();
    private final ConcurrentHashMap<Long, QueryCursorIterator> qryCurs = new ConcurrentHashMap();

    public QueryCommandHandler(GridKernalContext ctx) {
        super(ctx);
        final long idleQryCurTimeout = ctx.config().getConnectorConfiguration().getIdleQueryCursorTimeout();
        long idleQryCurCheckFreq = ctx.config().getConnectorConfiguration().getIdleQueryCursorCheckFrequency();
        ctx.timeout().schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long time = U.currentTimeMillis();
                for (Map.Entry e : QueryCommandHandler.this.qryCurs.entrySet()) {
                    QueryCursorIterator qryCurIt = (QueryCursorIterator)e.getValue();
                    long createTime = qryCurIt.timestamp();
                    if (time <= createTime + idleQryCurTimeout || !qryCurIt.tryLock()) continue;
                    try {
                        qryCurIt.timestamp(-1L);
                        QueryCommandHandler.this.qryCurs.remove(e.getKey(), qryCurIt);
                        qryCurIt.close();
                    }
                    finally {
                        qryCurIt.unlock();
                    }
                }
            }
        }, idleQryCurCheckFreq, idleQryCurCheckFreq);
    }

    private static CacheQueryResult createQueryResult(Iterator cur, RestQueryRequest req, Long qryId, ConcurrentHashMap<Long, QueryCursorIterator> qryCurs) {
        CacheQueryResult res = new CacheQueryResult();
        ArrayList items = new ArrayList();
        for (int i = 0; i < req.pageSize() && cur.hasNext(); ++i) {
            items.add(cur.next());
        }
        res.setItems(items);
        res.setLast(!cur.hasNext());
        res.setQueryId(qryId);
        if (!cur.hasNext()) {
            QueryCommandHandler.removeQueryCursor(qryId, qryCurs);
        }
        return res;
    }

    private static void removeQueryCursor(Long qryId, ConcurrentHashMap<Long, QueryCursorIterator> qryCurs) {
        QueryCursorIterator qryCurIt = qryCurs.get(qryId);
        if (qryCurIt == null) {
            return;
        }
        qryCurIt.lock();
        try {
            if (qryCurIt.timestamp() == -1L) {
                return;
            }
            qryCurIt.close();
            qryCurs.remove(qryId);
        }
        finally {
            qryCurIt.unlock();
        }
    }

    private static <T> T instance(Class<? extends T> cls, String clsName) throws IgniteException {
        try {
            Class<?> implCls = Class.forName(clsName);
            if (!cls.isAssignableFrom(implCls)) {
                throw new IgniteException("Failed to create instance (target class does not extend or implement required class or interface) [cls=" + cls.getName() + ", clsName=" + clsName + ']');
            }
            Constructor<?> ctor = implCls.getConstructor(new Class[0]);
            return (T)ctor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IgniteException("Failed to find target class: " + clsName, e);
        }
        catch (NoSuchMethodException e) {
            throw new IgniteException("Failed to find constructor for provided arguments [clsName=" + clsName + ']', e);
        }
        catch (InstantiationException e) {
            throw new IgniteException("Failed to instantiate target class [clsName=" + clsName + ']', e);
        }
        catch (IllegalAccessException e) {
            throw new IgniteException("Failed to instantiate class (constructor is not available) [clsName=" + clsName + ']', e);
        }
        catch (InvocationTargetException e) {
            throw new IgniteException("Failed to instantiate class (constructor threw an exception) [clsName=" + clsName + ']', e.getCause());
        }
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest req) {
        Integer pageSize;
        assert (req != null);
        assert (SUPPORTED_COMMANDS.contains((Object)req.command()));
        assert (req instanceof RestQueryRequest) : "Invalid type of query request.";
        if (req.command() != GridRestCommand.CLOSE_SQL_QUERY && (pageSize = ((RestQueryRequest)req).pageSize()) == null) {
            return new GridFinishedFuture<GridRestResponse>(new IgniteCheckedException(GridRestCommandHandlerAdapter.missingParameter("pageSize")));
        }
        if (req.command() != GridRestCommand.FETCH_SQL_QUERY && req.command() != GridRestCommand.CLOSE_SQL_QUERY && ((RestQueryRequest)req).cacheName() == null) {
            return new GridFinishedFuture<GridRestResponse>(new IgniteCheckedException(GridRestCommandHandlerAdapter.missingParameter("cacheName")));
        }
        switch (req.command()) {
            case EXECUTE_SQL_QUERY: 
            case EXECUTE_SQL_FIELDS_QUERY: 
            case EXECUTE_SCAN_QUERY: {
                return this.ctx.closure().callLocalSafe(new ExecuteQueryCallable(this.ctx, (RestQueryRequest)req, this.qryCurs), false);
            }
            case FETCH_SQL_QUERY: {
                return this.ctx.closure().callLocalSafe(new FetchQueryCallable((RestQueryRequest)req, this.qryCurs), false);
            }
            case CLOSE_SQL_QUERY: {
                return this.ctx.closure().callLocalSafe(new CloseQueryCallable((RestQueryRequest)req, this.qryCurs), false);
            }
        }
        return new GridFinishedFuture<GridRestResponse>();
    }

    private static class QueryCursorIterator
    extends ReentrantLock {
        private static final long serialVersionUID = 0L;
        private QueryCursor cur;
        private Iterator it;
        private volatile long ts;

        public QueryCursorIterator(QueryCursor cur, Iterator it) {
            this.cur = cur;
            this.it = it;
            this.ts = U.currentTimeMillis();
        }

        public Iterator iterator() {
            return this.it;
        }

        public long timestamp() {
            return this.ts;
        }

        public void timestamp(long time) {
            this.ts = time;
        }

        public void close() {
            this.cur.close();
        }
    }

    private static class FetchQueryCallable
    implements GridPlainCallable<GridRestResponse> {
        private final ConcurrentHashMap<Long, QueryCursorIterator> qryCurs;
        private RestQueryRequest req;

        public FetchQueryCallable(RestQueryRequest req, ConcurrentHashMap<Long, QueryCursorIterator> qryCurs) {
            this.req = req;
            this.qryCurs = qryCurs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public GridRestResponse call() throws Exception {
            try {
                QueryCursorIterator qryCurIt = this.qryCurs.get(this.req.queryId());
                if (qryCurIt == null) {
                    return new GridRestResponse(1, "Failed to find query with ID: " + this.req.queryId() + ". Possible reasons: wrong query ID, no more data to fetch from query, query was closed by timeout or node where query was executed is not found.");
                }
                qryCurIt.lock();
                try {
                    if (qryCurIt.timestamp() == -1L) {
                        GridRestResponse gridRestResponse = new GridRestResponse(1, "Query with ID: " + this.req.queryId() + " was closed by timeout");
                        return gridRestResponse;
                    }
                    qryCurIt.timestamp(U.currentTimeMillis());
                    Iterator cur = qryCurIt.iterator();
                    CacheQueryResult res = QueryCommandHandler.createQueryResult(cur, this.req, this.req.queryId(), this.qryCurs);
                    GridRestResponse gridRestResponse = new GridRestResponse(res);
                    return gridRestResponse;
                }
                finally {
                    qryCurIt.unlock();
                }
            }
            catch (Exception e) {
                QueryCommandHandler.removeQueryCursor(this.req.queryId(), this.qryCurs);
                return new GridRestResponse(1, e.getMessage());
            }
        }
    }

    private static class CloseQueryCallable
    implements GridPlainCallable<GridRestResponse> {
        private final ConcurrentHashMap<Long, QueryCursorIterator> qryCurs;
        private RestQueryRequest req;

        public CloseQueryCallable(RestQueryRequest req, ConcurrentHashMap<Long, QueryCursorIterator> qryCurs) {
            this.req = req;
            this.qryCurs = qryCurs;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public GridRestResponse call() throws Exception {
            try {
                QueryCursorIterator qryCurIt = this.qryCurs.get(this.req.queryId());
                if (qryCurIt == null) {
                    return new GridRestResponse(true);
                }
                qryCurIt.lock();
                try {
                    if (qryCurIt.timestamp() == -1L) {
                        GridRestResponse gridRestResponse = new GridRestResponse(true);
                        return gridRestResponse;
                    }
                    qryCurIt.close();
                    this.qryCurs.remove(this.req.queryId());
                    return new GridRestResponse(true);
                }
                finally {
                    qryCurIt.unlock();
                }
            }
            catch (Exception e) {
                QueryCommandHandler.removeQueryCursor(this.req.queryId(), this.qryCurs);
                return new GridRestResponse(1, e.getMessage());
            }
        }
    }

    private static class ExecuteQueryCallable
    implements GridPlainCallable<GridRestResponse> {
        private GridKernalContext ctx;
        private RestQueryRequest req;
        private final ConcurrentHashMap<Long, QueryCursorIterator> qryCurs;

        public ExecuteQueryCallable(GridKernalContext ctx, RestQueryRequest req, ConcurrentHashMap<Long, QueryCursorIterator> qryCurs) {
            this.ctx = ctx;
            this.req = req;
            this.qryCurs = qryCurs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GridRestResponse call() throws Exception {
            GridRestResponse gridRestResponse;
            Query qry;
            long qryId = qryIdGen.getAndIncrement();
            switch (this.req.queryType()) {
                case SQL: {
                    qry = new SqlQuery(this.req.typeName(), this.req.sqlQuery());
                    ((SqlQuery)qry).setArgs(this.req.arguments());
                    ((SqlQuery)qry).setDistributedJoins(this.req.distributedJoins());
                    break;
                }
                case SQL_FIELDS: {
                    qry = new SqlFieldsQuery(this.req.sqlQuery());
                    ((SqlFieldsQuery)qry).setArgs(this.req.arguments());
                    ((SqlFieldsQuery)qry).setDistributedJoins(this.req.distributedJoins());
                    break;
                }
                case SCAN: {
                    IgniteBiPredicate pred = null;
                    if (this.req.className() != null) {
                        pred = (IgniteBiPredicate)QueryCommandHandler.instance(IgniteBiPredicate.class, this.req.className());
                    }
                    qry = new ScanQuery(pred);
                    break;
                }
                default: {
                    throw new IgniteException("Incorrect query type [type=" + (Object)((Object)this.req.queryType()) + "]");
                }
            }
            IgniteCache<Object, Object> cache = this.ctx.grid().cache(this.req.cacheName());
            if (cache == null) {
                return new GridRestResponse(1, "Failed to find cache with name: " + this.req.cacheName());
            }
            if (this.req.keepBinary()) {
                cache = cache.withKeepBinary();
            }
            QueryCursor qryCur = cache.query(qry);
            Iterator cur = qryCur.iterator();
            QueryCursorIterator qryCurIt = new QueryCursorIterator(qryCur, cur);
            qryCurIt.lock();
            try {
                this.qryCurs.put(qryId, qryCurIt);
                CacheQueryResult res = QueryCommandHandler.createQueryResult(cur, this.req, qryId, this.qryCurs);
                switch (this.req.queryType()) {
                    case SQL: 
                    case SQL_FIELDS: {
                        List<GridQueryFieldMetadata> fieldsMeta = ((QueryCursorImpl)qryCur).fieldsMeta();
                        res.setFieldsMetadata(this.convertMetadata(fieldsMeta));
                        break;
                    }
                    case SCAN: {
                        CacheQueryFieldsMetaResult keyField = new CacheQueryFieldsMetaResult();
                        keyField.setFieldName("key");
                        CacheQueryFieldsMetaResult valField = new CacheQueryFieldsMetaResult();
                        valField.setFieldName("value");
                        res.setFieldsMetadata(U.sealList(keyField, valField));
                    }
                }
                gridRestResponse = new GridRestResponse(res);
            }
            catch (Throwable throwable) {
                try {
                    qryCurIt.unlock();
                    throw throwable;
                }
                catch (Exception e) {
                    QueryCommandHandler.removeQueryCursor(qryId, this.qryCurs);
                    SQLException sqlErr = X.cause(e, SQLException.class);
                    return new GridRestResponse(1, sqlErr != null ? sqlErr.getMessage() : e.getMessage());
                }
            }
            qryCurIt.unlock();
            return gridRestResponse;
        }

        private Collection<CacheQueryFieldsMetaResult> convertMetadata(Collection<GridQueryFieldMetadata> meta) {
            ArrayList<CacheQueryFieldsMetaResult> res = new ArrayList<CacheQueryFieldsMetaResult>();
            if (meta != null) {
                for (GridQueryFieldMetadata info : meta) {
                    res.add(new CacheQueryFieldsMetaResult(info));
                }
            }
            return res;
        }
    }
}

