/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.auth;

import java.util.Collection;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.internal.U;

public class AuthenticationCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> SUPPORTED_COMMANDS = U.sealList(GridRestCommand.AUTHENTICATE);

    public AuthenticationCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest req) {
        assert (req != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handling topology REST request: " + req);
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Handled topology REST request [req=" + req + ']');
            }
            return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(true));
        }
        catch (Throwable e) {
            this.log.error("Failed to handle REST request [req=" + req + ']', e);
            return new GridFinishedFuture<GridRestResponse>(e);
        }
    }
}

