/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounter;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.jetbrains.annotations.Nullable;

public class PartitionUpdateCounterTrackingImpl
implements PartitionUpdateCounter {
    public static final int MAX_MISSED_UPDATES = 10000;
    private static final byte VERSION = 1;
    protected NavigableMap<Long, Item> queue = new TreeMap<Long, Item>();
    protected final AtomicLong lwm = new AtomicLong();
    protected final AtomicLong reservedCntr = new AtomicLong();
    protected boolean first = true;
    protected final CacheGroupContext grp;
    @Deprecated
    protected volatile long initCntr;

    public PartitionUpdateCounterTrackingImpl(CacheGroupContext grp) {
        this.grp = grp;
    }

    @Override
    public void init(long initUpdCntr, @Nullable byte[] cntrUpdData) {
        this.lwm.set(initUpdCntr);
        this.initCntr = initUpdCntr;
        this.queue = this.fromBytes(cntrUpdData);
        this.reservedCntr.set(this.highestAppliedCounter());
    }

    @Override
    public long initial() {
        return this.initCntr;
    }

    @Override
    public long get() {
        return this.lwm.get();
    }

    @Override
    public synchronized long highestAppliedCounter() {
        return this.queue.isEmpty() ? this.lwm.get() : this.queue.lastEntry().getValue().absolute();
    }

    @Override
    public long next() {
        long next = this.lwm.incrementAndGet();
        this.reservedCntr.set(next);
        return next;
    }

    @Override
    public synchronized void update(long val) throws IgniteCheckedException {
        long curLwm = this.lwm.get();
        long max = Math.max(val, curLwm);
        long reserved = this.reservedCntr.get();
        if (reserved < max) {
            this.reservedCntr.set(max);
        }
        if (val < curLwm) {
            return;
        }
        if (val < this.highestAppliedCounter()) {
            throw new IgniteCheckedException("Failed to update the counter [newVal=" + val + ", prevReserved=" + reserved + ", curState=" + this + ']');
        }
        this.lwm.set(val);
        if (this.first) {
            this.queue.clear();
            this.first = false;
        }
    }

    @Override
    public synchronized boolean update(long start, long delta) {
        long cur = this.lwm.get();
        if (cur > start) {
            return false;
        }
        if (cur < start) {
            Map.Entry<Long, Item> prev;
            long next = start + delta;
            Item nextItem = (Item)this.queue.remove(next);
            if (nextItem != null) {
                delta += nextItem.delta;
            }
            if ((prev = this.queue.lowerEntry(start)) != null) {
                Item prevItem = prev.getValue();
                if (prevItem.absolute() == start) {
                    Item item = prevItem;
                    item.delta = item.delta + delta;
                    return true;
                }
                if (prevItem.within(next - 1L)) {
                    return false;
                }
            }
            if (this.queue.size() >= 10000) {
                throw new IgniteException("Too many gaps [cntr=" + this + ']');
            }
            return this.queue.putIfAbsent(start, new Item(start, delta)) == null;
        }
        long next = start + delta;
        Item nextItem = (Item)this.queue.remove(next);
        if (nextItem != null) {
            next += nextItem.delta;
        }
        boolean res = this.lwm.compareAndSet(cur, next);
        assert (res);
        return true;
    }

    @Override
    public void updateInitial(long start, long delta) {
        this.update(start, delta);
        this.initCntr = this.get();
        long highestAppliedCounter = this.highestAppliedCounter();
        if (this.reservedCntr.get() < highestAppliedCounter) {
            this.reservedCntr.set(highestAppliedCounter);
        }
    }

    @Override
    public synchronized GridLongList finalizeUpdateCounters() {
        Map.Entry<Long, Item> item = this.queue.pollFirstEntry();
        GridLongList gaps = null;
        while (item != null) {
            if (gaps == null) {
                gaps = new GridLongList((this.queue.size() + 1) * 2);
            }
            long start = this.lwm.get() + 1L;
            long end = item.getValue().start;
            gaps.add(start);
            gaps.add(end);
            this.lwm.set(item.getValue().absolute());
            item = this.queue.pollFirstEntry();
        }
        this.reservedCntr.set(this.get());
        return gaps;
    }

    @Override
    public synchronized long reserve(long delta) {
        long lwm = this.get();
        long reserved = this.reservedCntr.getAndAdd(delta);
        assert (reserved >= lwm) : "LWM after reserved: lwm=" + lwm + ", reserved=" + reserved + ", cntr=" + this;
        return reserved;
    }

    @Override
    public long next(long delta) {
        return this.lwm.getAndAdd(delta);
    }

    @Override
    public synchronized boolean sequential() {
        return this.queue.isEmpty();
    }

    @Override
    @Nullable
    public synchronized byte[] getBytes() {
        if (this.queue.isEmpty()) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(1);
            int size = this.queue.size();
            dos.writeInt(size);
            for (Item item : this.queue.values()) {
                dos.writeLong(item.start);
                dos.writeLong(item.delta);
            }
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    @Nullable
    private NavigableMap<Long, Item> fromBytes(@Nullable byte[] raw) {
        TreeMap<Long, Item> ret = new TreeMap<Long, Item>();
        if (raw == null) {
            return ret;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(raw);
            DataInputStream dis = new DataInputStream(bis);
            dis.readByte();
            int cnt = dis.readInt();
            while (cnt-- > 0) {
                Item item = new Item(dis.readLong(), dis.readLong());
                ret.put(item.start, item);
            }
            return ret;
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public synchronized void reset() {
        this.initCntr = 0L;
        this.lwm.set(0L);
        this.reservedCntr.set(0L);
        this.queue.clear();
    }

    @Override
    public void resetInitialCounter() {
        this.initCntr = 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionUpdateCounterTrackingImpl cntr = (PartitionUpdateCounterTrackingImpl)o;
        if (!this.queue.equals(cntr.queue)) {
            return false;
        }
        return this.lwm.get() == cntr.lwm.get();
    }

    @Override
    public long reserved() {
        return this.reservedCntr.get();
    }

    @Override
    public synchronized boolean empty() {
        return this.get() == 0L && this.sequential();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Iterator<long[]> iterator() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String missed() {
        ArrayList<String> missed = new ArrayList<String>();
        long prev = this.lwm.get();
        for (Item item : this.queue.values()) {
            if (prev + 1L == item.start) {
                missed.add(String.valueOf(item.start));
            } else {
                missed.add(prev + 1L + " - " + item.start);
            }
            prev = item.start + item.delta;
        }
        return ((Object)missed).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object comparableState() {
        long hwm;
        long lwm;
        String missed;
        PartitionUpdateCounterTrackingImpl partitionUpdateCounterTrackingImpl = this;
        synchronized (partitionUpdateCounterTrackingImpl) {
            missed = this.missed();
            lwm = this.get();
            hwm = this.highestAppliedCounter();
        }
        return new SB().a("[lwm=").a(lwm).a(", missed=").a(missed).a(", hwm=").a(hwm).a(']').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long reserved;
        long hwm;
        long lwm;
        String missed;
        PartitionUpdateCounterTrackingImpl partitionUpdateCounterTrackingImpl = this;
        synchronized (partitionUpdateCounterTrackingImpl) {
            missed = this.missed();
            lwm = this.get();
            hwm = this.highestAppliedCounter();
            reserved = this.reservedCntr.get();
        }
        return new SB().a("Counter [lwm=").a(lwm).a(", missed=").a(missed).a(", hwm=").a(hwm).a(", reserved=").a(reserved).a(']').toString();
    }

    @Override
    public CacheGroupContext context() {
        return this.grp;
    }

    @Override
    public PartitionUpdateCounter copy() {
        PartitionUpdateCounterTrackingImpl copy = this.createInstance();
        copy.lwm.set(this.lwm.get());
        copy.first = this.first;
        copy.queue = new TreeMap<Long, Item>((SortedMap<Long, Item>)this.queue);
        copy.initCntr = this.initCntr;
        copy.reservedCntr.set(this.reservedCntr.get());
        return copy;
    }

    protected PartitionUpdateCounterTrackingImpl createInstance() {
        return new PartitionUpdateCounterTrackingImpl(this.grp);
    }

    private static class Item {
        private final long start;
        private long delta;

        private Item(long start, long delta) {
            this.start = start;
            this.delta = delta;
        }

        public String toString() {
            return "Item [start=" + this.start + ", delta=" + this.delta + ']';
        }

        public long start() {
            return this.start;
        }

        public long delta() {
            return this.delta;
        }

        public long absolute() {
            return this.start + this.delta;
        }

        public boolean within(long cntr) {
            return cntr - this.start < this.delta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (this.start != item.start) {
                return false;
            }
            return this.delta == item.delta;
        }
    }
}

