/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.snapshot;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.management.SystemViewCommand;
import org.apache.ignite.internal.management.SystemViewTask;
import org.apache.ignite.internal.management.api.NoArg;
import org.apache.ignite.internal.management.snapshot.AbstractSnapshotCommand;
import org.apache.ignite.internal.management.snapshot.SnapshotStatusTask;
import org.apache.ignite.internal.management.snapshot.SnapshotTaskResult;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T5;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;

public class SnapshotStatusCommand
extends AbstractSnapshotCommand<NoArg> {
    @Override
    public String description() {
        return "Get the status of the current snapshot operation";
    }

    @Override
    public Class<NoArg> argClass() {
        return NoArg.class;
    }

    @Override
    public Class<SnapshotStatusTask> taskClass() {
        return SnapshotStatusTask.class;
    }

    @Override
    public void printResult(NoArg arg, SnapshotTaskResult res0, Consumer<String> printer) {
        Object res;
        try {
            res = res0.result();
        }
        catch (Exception e2) {
            throw new IgniteException(e2);
        }
        if (res == null) {
            printer.accept("There is no create or restore snapshot operation in progress.");
            return;
        }
        SnapshotStatusTask.SnapshotStatus status = (SnapshotStatusTask.SnapshotStatus)res;
        boolean isCreating = status.operation() == SnapshotStatusTask.SnapshotOperation.CREATE;
        boolean isIncremental = status.incrementIndex() > 0;
        GridStringBuilder s = new GridStringBuilder();
        if (isCreating) {
            s.a("Create snapshot operation is in progress.").nl();
        } else {
            s.a("Restore snapshot operation is in progress.").nl();
        }
        s.a("Snapshot name: ").a(status.name()).nl();
        s.a("Incremental: ").a(isIncremental).nl();
        if (isIncremental) {
            s.a("Increment index: ").a(status.incrementIndex()).nl();
        }
        s.a("Operation request ID: ").a(status.requestId()).nl();
        s.a("Started at: ").a(DateFormat.getDateTimeInstance().format(new Date(status.startTime()))).nl();
        s.a("Duration: ").a(X.timeSpan2DHMSM(System.currentTimeMillis() - status.startTime())).nl().nl();
        s.a("Estimated operation progress:").nl();
        printer.accept(s.toString());
        SnapshotTaskProgressDesc desc = isCreating && isIncremental ? new CreateIncrementalSnapshotTaskProgressDesc() : (isCreating ? new CreateFullSnapshotTaskProgressDesc() : (isIncremental ? new RestoreIncrementalSnapshotTaskProgressDesc() : new RestoreFullSnapshotTaskProgressDesc()));
        List<List<?>> rows = status.progress().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> desc.buildRow((UUID)e.getKey(), (T5)e.getValue())).collect(Collectors.toList());
        SystemViewCommand.printTable(desc.titles(), desc.types(), rows, printer);
        printer.accept(U.nl());
    }

    private static class RestoreIncrementalSnapshotTaskProgressDesc
    extends SnapshotTaskProgressDesc {
        RestoreIncrementalSnapshotTaskProgressDesc() {
            super(F.asList(new String[]{"Node ID", "Processed, partitions", "Total, partitions", "Percent", "Processed, WAL segments", "Total, WAL segments", "Percent", "Processed, WAL entries"}));
        }

        @Override
        public List<?> buildRow(UUID nodeId, T5<Long, Long, Long, Long, Long> progress) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(nodeId);
            long processedParts = (Long)progress.get1();
            long totalParts = (Long)progress.get2();
            if (totalParts <= 0L) {
                result.addAll(F.asList(new String[]{"unknown", "unknown", "unknown"}));
            } else {
                String partsPercent = (int)(processedParts * 100L / totalParts) + "%";
                result.add(F.asList(new Serializable[]{Long.valueOf(processedParts), Long.valueOf(totalParts), partsPercent}));
            }
            long processedWalSegs = (Long)progress.get3();
            long totalWalSegs = (Long)progress.get4();
            if (processedWalSegs <= 0L) {
                result.addAll(F.asList(new String[]{"unknown", "unknown", "unknown"}));
            } else {
                String walSegsPercent = (int)(processedWalSegs * 100L / totalWalSegs) + "%";
                result.add(F.asList(new Serializable[]{Long.valueOf(processedWalSegs), Long.valueOf(totalWalSegs), walSegsPercent}));
            }
            long processedWalEntries = (Long)progress.get5();
            if (processedWalEntries <= 0L) {
                result.add("unknown");
            } else {
                result.add(processedWalEntries);
            }
            return result;
        }
    }

    private static class RestoreFullSnapshotTaskProgressDesc
    extends SnapshotTaskProgressDesc {
        RestoreFullSnapshotTaskProgressDesc() {
            super(F.asList(new String[]{"Node ID", "Processed, partitions", "Total, partitions", "Percent"}));
        }

        @Override
        public List<?> buildRow(UUID nodeId, T5<Long, Long, Long, Long, Long> progress) {
            long processed = (Long)progress.get1();
            long total = (Long)progress.get2();
            if (total <= 0L) {
                return F.asList(new Serializable[]{nodeId, "unknown", "unknown", "unknown"});
            }
            String percent = (int)(processed * 100L / total) + "%";
            return F.asList(new Serializable[]{nodeId, Long.valueOf(processed), Long.valueOf(total), percent});
        }
    }

    private static class CreateIncrementalSnapshotTaskProgressDesc
    extends SnapshotTaskProgressDesc {
        CreateIncrementalSnapshotTaskProgressDesc() {
            super(F.asList(new String[]{"Node ID", "Progress"}));
        }

        @Override
        public List<?> buildRow(UUID nodeId, T5<Long, Long, Long, Long, Long> progress) {
            return F.asList(new Serializable[]{nodeId, "unknown"});
        }
    }

    private static class CreateFullSnapshotTaskProgressDesc
    extends SnapshotTaskProgressDesc {
        CreateFullSnapshotTaskProgressDesc() {
            super(F.asList(new String[]{"Node ID", "Processed, bytes", "Total, bytes", "Percent"}));
        }

        @Override
        public List<?> buildRow(UUID nodeId, T5<Long, Long, Long, Long, Long> progress) {
            long processed = (Long)progress.get1();
            long total = (Long)progress.get2();
            if (total <= 0L) {
                return F.asList(new Serializable[]{nodeId, "unknown", "unknown", "unknown"});
            }
            String percent = (int)(processed * 100L / total) + "%";
            return F.asList(new Serializable[]{nodeId, U.humanReadableByteCount(processed), U.humanReadableByteCount(total), percent});
        }
    }

    private static abstract class SnapshotTaskProgressDesc {
        private final List<String> titles;

        SnapshotTaskProgressDesc(List<String> titles) {
            this.titles = Collections.unmodifiableList(titles);
        }

        List<String> titles() {
            return this.titles;
        }

        List<SystemViewTask.SimpleType> types() {
            ArrayList<SystemViewTask.SimpleType> types = new ArrayList<SystemViewTask.SimpleType>();
            types.add(SystemViewTask.SimpleType.STRING);
            for (int i = 0; i < this.titles().size() - 1; ++i) {
                types.add(SystemViewTask.SimpleType.NUMBER);
            }
            return types;
        }

        abstract List<?> buildRow(UUID var1, T5<Long, Long, Long, Long, Long> var2);
    }
}

