/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.kill;

import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.management.kill.KillClientCommandArg;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.mxbean.ClientProcessorMXBean;
import org.jetbrains.annotations.Nullable;

@GridInternal
@GridVisorManagementTask
public class ClientConnectionDropTask
extends VisorMultiNodeTask<KillClientCommandArg, Void, Boolean> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<KillClientCommandArg, Boolean> job(KillClientCommandArg arg) {
        return new ClientConnectionDropJob(arg, this.debug);
    }

    @Override
    protected Void reduce0(List<ComputeJobResult> results) throws IgniteException {
        boolean res = false;
        for (ComputeJobResult jobRes : results) {
            if (jobRes.getException() != null) {
                throw jobRes.getException();
            }
            res |= ((Boolean)jobRes.getData()).booleanValue();
        }
        if (!res) {
            throw new IgniteException("No connection was dropped");
        }
        return null;
    }

    private static class ClientConnectionDropJob
    extends VisorJob<KillClientCommandArg, Boolean> {
        private static final long serialVersionUID = 0L;

        protected ClientConnectionDropJob(@Nullable KillClientCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Boolean run(@Nullable KillClientCommandArg arg) throws IgniteException {
            if (arg == null) {
                return false;
            }
            ClientProcessorMXBean bean = this.ignite.context().clientListener().mxBean();
            if (!"ALL".equals(arg.connectionId())) {
                return bean.dropConnection(Long.parseLong(arg.connectionId()));
            }
            bean.dropAllConnections();
            return true;
        }
    }
}

