/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.io.Serializable;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.jdbc.thin.ConnectionProperties;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcThinFeature;
import org.apache.ignite.internal.processors.query.NestedTxMode;
import org.apache.ignite.internal.util.HostAndPortRange;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class ConnectionPropertiesImpl
implements ConnectionProperties,
Serializable {
    private static final long serialVersionUID = 0L;
    public static final String PROP_PREFIX = "ignite.jdbc.";
    private static final int DFLT_SOCK_BUFFER_SIZE = 65536;
    private static final String PROP_SCHEMA = "schema";
    private String url;
    private HostAndPortRange[] addrs;
    private StringProperty schema = new StringProperty("schema", "Schema name of the connection", "PUBLIC", null, false, null);
    private BooleanProperty distributedJoins = new BooleanProperty("distributedJoins", "Enable distributed joins", false, false);
    private BooleanProperty enforceJoinOrder = new BooleanProperty("enforceJoinOrder", "Enable enforce join order", false, false);
    private BooleanProperty collocated = new BooleanProperty("collocated", "Enable collocated query", false, false);
    private BooleanProperty replicatedOnly = new BooleanProperty("replicatedOnly", "Specify if the all queries contain only replicated tables", false, false);
    private BooleanProperty autoCloseServerCursor = new BooleanProperty("autoCloseServerCursor", "Enable auto close server cursors when last piece of result set is retrieved. If the server-side cursor is already closed, you may get an exception when trying to call `ResultSet.getMetadata()` method.", false, false);
    private BooleanProperty tcpNoDelay = new BooleanProperty("tcpNoDelay", "TCP no delay flag", true, false);
    private BooleanProperty lazy = new BooleanProperty("lazy", "Enable lazy query execution", SqlFieldsQuery.DFLT_LAZY, false);
    private IntegerProperty socketSendBuffer = new IntegerProperty("socketSendBuffer", "Socket send buffer size", (Number)65536, false, 0, Integer.MAX_VALUE);
    private IntegerProperty socketReceiveBuffer = new IntegerProperty("socketReceiveBuffer", "Socket send buffer size", (Number)65536, false, 0, Integer.MAX_VALUE);
    private BooleanProperty skipReducerOnUpdate = new BooleanProperty("skipReducerOnUpdate", "Enable execution update queries on ignite server nodes", false, false);
    private StringProperty nestedTxMode = new StringProperty("nestedTransactionsMode", "Way to handle nested transactions", NestedTxMode.ERROR.name(), new String[]{NestedTxMode.COMMIT.name(), NestedTxMode.ERROR.name(), NestedTxMode.IGNORE.name()}, false, new PropertyValidator(){
        private static final long serialVersionUID = 0L;

        @Override
        public void validate(String mode) throws SQLException {
            if (!F.isEmpty(mode)) {
                try {
                    NestedTxMode.valueOf(mode.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new SQLException("Invalid nested transactions handling mode, allowed values: " + Arrays.toString(((ConnectionPropertiesImpl)ConnectionPropertiesImpl.this).nestedTxMode.choices), "08001");
                }
            }
        }
    });
    private StringProperty sslMode = new StringProperty("sslMode", "The SSL mode of the connection", "disable", new String[]{"disable", "require"}, false, null);
    private StringProperty sslProtocol = new StringProperty("sslProtocol", "SSL protocol name", null, null, false, null);
    private StringProperty sslCipherSuites = new StringProperty("sslCipherSuites", "Supported SSL ciphers", null, null, false, null);
    private StringProperty sslKeyAlgorithm = new StringProperty("sslKeyAlgorithm", "SSL key algorithm name", null, null, false, null);
    private StringProperty sslClientCertificateKeyStoreUrl = new StringProperty("sslClientCertificateKeyStoreUrl", "Client certificate key store URL", null, null, false, null);
    private StringProperty sslClientCertificateKeyStorePassword = new StringProperty("sslClientCertificateKeyStorePassword", "Client certificate key store password", null, null, false, null);
    private StringProperty sslClientCertificateKeyStoreType = new StringProperty("sslClientCertificateKeyStoreType", "Client certificate key store type", null, null, false, null);
    private StringProperty sslTrustCertificateKeyStoreUrl = new StringProperty("sslTrustCertificateKeyStoreUrl", "Trusted certificate key store URL", null, null, false, null);
    private StringProperty sslTrustCertificateKeyStorePassword = new StringProperty("sslTrustCertificateKeyStorePassword", "Trusted certificate key store password", null, null, false, null);
    private StringProperty sslTrustCertificateKeyStoreType = new StringProperty("sslTrustCertificateKeyStoreType", "Trusted certificate key store type", null, null, false, null);
    private BooleanProperty sslTrustAll = new BooleanProperty("sslTrustAll", "Trust all certificates", false, false);
    private StringProperty sslFactory = new StringProperty("sslFactory", "Custom class name that implements Factory<SSLSocketFactory>", null, null, false, null);
    private StringProperty userAttrsFactory = new StringProperty("userAttributesFactory", "Custom class name that implements Factory<Map<String, String>> (user attributes)", null, null, false, null);
    private StringProperty user = new StringProperty("user", "User name to authenticate the client on the server side", null, null, false, null);
    private StringProperty passwd = new StringProperty("password", "User's password", null, null, false, null);
    private BooleanProperty dataPageScanEnabled = new BooleanProperty("dataPageScanEnabled", "Whether data page scan for queries is allowed. If not specified, server defines the default behaviour.", null, false);
    private BooleanProperty partitionAwareness = new BooleanProperty("partitionAwareness", "Whether jdbc thin partition awareness is enabled.", false, false);
    private IntegerProperty updateBatchSize = new IntegerProperty("updateBatchSize", "Update bach size (the size of internal batches are used for INSERT/UPDATE/DELETE operation). Set to 1 to prevent deadlock on update where keys sequence are different in several concurrent updates.", null, false, 1, Integer.MAX_VALUE);
    private IntegerProperty partitionAwarenessSQLCacheSize = new IntegerProperty("partitionAwarenessSQLCacheSize", "The size of sql cache that is used within partition awareness optimization.", (Number)1000, false, 1, Integer.MAX_VALUE);
    private IntegerProperty partitionAwarenessPartDistributionsCacheSize = new IntegerProperty("partitionAwarenessPartitionDistributionsCacheSize", "The size of partition distributions cache that is used within partition awareness optimization.", (Number)1000, false, 1, Integer.MAX_VALUE);
    private IntegerProperty qryTimeout = new IntegerProperty("queryTimeout", "Sets the number of seconds the driver will wait for a <code>Statement</code> object to execute. Zero means there is no limits.", null, false, 0, Integer.MAX_VALUE);
    private IntegerProperty connTimeout = new IntegerProperty("connectionTimeout", "Sets the number of milliseconds JDBC client will waits for server to response. Zero means there is no limits.", (Number)0, false, 0, Integer.MAX_VALUE);
    private StringProperty disabledFeatures = new StringProperty("disabledFeatures", "Sets enumeration of features to force disable its.", null, null, false, new PropertyValidator(){

        @Override
        public void validate(String val) throws SQLException {
            String[] features;
            if (val == null) {
                return;
            }
            for (String f : features = val.split("\\W+")) {
                try {
                    JdbcThinFeature.valueOf(f.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new SQLException("Unknown feature: " + f);
                }
            }
        }
    });
    private BooleanProperty keepBinary = new BooleanProperty("keepBinary", "Whether to keep binary objects in binary form.", false, false);
    private final StringProperty qryEngine = new StringProperty("queryEngine", "Use specified SQL query engine for a connection.", null, null, false, null);
    private final ConnectionProperty[] propsArray = new ConnectionProperty[]{this.distributedJoins, this.enforceJoinOrder, this.collocated, this.replicatedOnly, this.autoCloseServerCursor, this.tcpNoDelay, this.lazy, this.socketSendBuffer, this.socketReceiveBuffer, this.skipReducerOnUpdate, this.nestedTxMode, this.sslMode, this.sslCipherSuites, this.sslProtocol, this.sslKeyAlgorithm, this.sslClientCertificateKeyStoreUrl, this.sslClientCertificateKeyStorePassword, this.sslClientCertificateKeyStoreType, this.sslTrustCertificateKeyStoreUrl, this.sslTrustCertificateKeyStorePassword, this.sslTrustCertificateKeyStoreType, this.sslTrustAll, this.sslFactory, this.userAttrsFactory, this.user, this.passwd, this.dataPageScanEnabled, this.partitionAwareness, this.updateBatchSize, this.partitionAwarenessSQLCacheSize, this.partitionAwarenessPartDistributionsCacheSize, this.qryTimeout, this.connTimeout, this.disabledFeatures, this.keepBinary, this.qryEngine};

    @Override
    public String getSchema() {
        return this.schema.value();
    }

    @Override
    public void setSchema(String schema) {
        this.schema.setValue(schema);
    }

    @Override
    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        if (F.isEmpty(this.getAddresses())) {
            return null;
        }
        StringBuilder sbUrl = new StringBuilder("jdbc:ignite:thin://");
        HostAndPortRange[] addrs = this.getAddresses();
        for (int i = 0; i < addrs.length; ++i) {
            if (i > 0) {
                sbUrl.append(',');
            }
            sbUrl.append(addrs[i].toString());
        }
        if (!F.isEmpty(this.getSchema())) {
            sbUrl.append('/').append(this.getSchema());
        }
        return sbUrl.toString();
    }

    @Override
    public void setUrl(String url) throws SQLException {
        this.url = url;
        this.init(url, new Properties());
    }

    @Override
    public HostAndPortRange[] getAddresses() {
        return this.addrs;
    }

    @Override
    public void setAddresses(HostAndPortRange[] addrs) {
        this.addrs = addrs;
    }

    @Override
    public boolean isDistributedJoins() {
        return this.distributedJoins.value();
    }

    @Override
    public void setDistributedJoins(boolean val) {
        this.distributedJoins.setValue(val);
    }

    @Override
    public boolean isEnforceJoinOrder() {
        return this.enforceJoinOrder.value();
    }

    @Override
    public void setEnforceJoinOrder(boolean val) {
        this.enforceJoinOrder.setValue(val);
    }

    @Override
    public boolean isCollocated() {
        return this.collocated.value();
    }

    @Override
    public void setCollocated(boolean val) {
        this.collocated.setValue(val);
    }

    @Override
    public boolean isReplicatedOnly() {
        return this.replicatedOnly.value();
    }

    @Override
    public void setReplicatedOnly(boolean val) {
        this.replicatedOnly.setValue(val);
    }

    @Override
    public boolean isAutoCloseServerCursor() {
        return this.autoCloseServerCursor.value();
    }

    @Override
    public void setAutoCloseServerCursor(boolean val) {
        this.autoCloseServerCursor.setValue(val);
    }

    @Override
    public int getSocketSendBuffer() {
        return this.socketSendBuffer.value();
    }

    @Override
    public void setSocketSendBuffer(int size) throws SQLException {
        this.socketSendBuffer.setValue(size);
    }

    @Override
    public int getSocketReceiveBuffer() {
        return this.socketReceiveBuffer.value();
    }

    @Override
    public void setSocketReceiveBuffer(int size) throws SQLException {
        this.socketReceiveBuffer.setValue(size);
    }

    @Override
    public boolean isTcpNoDelay() {
        return this.tcpNoDelay.value();
    }

    @Override
    public void setTcpNoDelay(boolean val) {
        this.tcpNoDelay.setValue(val);
    }

    @Override
    public boolean isLazy() {
        return this.lazy.value();
    }

    @Override
    public void setLazy(boolean val) {
        this.lazy.setValue(val);
    }

    @Override
    public boolean isSkipReducerOnUpdate() {
        return this.skipReducerOnUpdate.value();
    }

    @Override
    public void setSkipReducerOnUpdate(boolean val) {
        this.skipReducerOnUpdate.setValue(val);
    }

    @Override
    public String getSslMode() {
        return this.sslMode.value();
    }

    @Override
    public void setSslMode(String mode) {
        this.sslMode.setValue(mode);
    }

    @Override
    public String getSslProtocol() {
        return this.sslProtocol.value();
    }

    @Override
    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol.setValue(sslProtocol);
    }

    @Override
    public String getSslCipherSuites() {
        return this.sslCipherSuites.value();
    }

    @Override
    public void setSslCipherSuites(String sslCipherSuites) {
        this.sslCipherSuites.setValue(sslCipherSuites);
    }

    @Override
    public String getSslKeyAlgorithm() {
        return this.sslKeyAlgorithm.value();
    }

    @Override
    public void setSslKeyAlgorithm(String keyAlgorithm) {
        this.sslKeyAlgorithm.setValue(keyAlgorithm);
    }

    @Override
    public String getSslClientCertificateKeyStoreUrl() {
        return this.sslClientCertificateKeyStoreUrl.value();
    }

    @Override
    public void setSslClientCertificateKeyStoreUrl(String url) {
        this.sslClientCertificateKeyStoreUrl.setValue(url);
    }

    @Override
    public String getSslClientCertificateKeyStorePassword() {
        return this.sslClientCertificateKeyStorePassword.value();
    }

    @Override
    public void setSslClientCertificateKeyStorePassword(String passwd) {
        this.sslClientCertificateKeyStorePassword.setValue(passwd);
    }

    @Override
    public String getSslClientCertificateKeyStoreType() {
        return this.sslClientCertificateKeyStoreType.value();
    }

    @Override
    public void setSslClientCertificateKeyStoreType(String ksType) {
        this.sslClientCertificateKeyStoreType.setValue(ksType);
    }

    @Override
    public String getSslTrustCertificateKeyStoreUrl() {
        return this.sslTrustCertificateKeyStoreUrl.value();
    }

    @Override
    public void setSslTrustCertificateKeyStoreUrl(String url) {
        this.sslTrustCertificateKeyStoreUrl.setValue(url);
    }

    @Override
    public String getSslTrustCertificateKeyStorePassword() {
        return this.sslTrustCertificateKeyStorePassword.value();
    }

    @Override
    public void setSslTrustCertificateKeyStorePassword(String passwd) {
        this.sslTrustCertificateKeyStorePassword.setValue(passwd);
    }

    @Override
    public String getSslTrustCertificateKeyStoreType() {
        return this.sslTrustCertificateKeyStoreType.value();
    }

    @Override
    public void setSslTrustCertificateKeyStoreType(String ksType) {
        this.sslTrustCertificateKeyStoreType.setValue(ksType);
    }

    @Override
    public boolean isSslTrustAll() {
        return this.sslTrustAll.value();
    }

    @Override
    public void setSslTrustAll(boolean trustAll) {
        this.sslTrustAll.setValue(trustAll);
    }

    @Override
    public String getSslFactory() {
        return this.sslFactory.value();
    }

    @Override
    public void setSslFactory(String sslFactory) {
        this.sslFactory.setValue(sslFactory);
    }

    @Override
    public String nestedTxMode() {
        return this.nestedTxMode.value();
    }

    @Override
    public void nestedTxMode(String val) {
        this.nestedTxMode.setValue(val);
    }

    @Override
    public void setUsername(String name) {
        this.user.setValue(name);
    }

    @Override
    public String getUsername() {
        return this.user.value();
    }

    @Override
    public void setPassword(String passwd) {
        this.passwd.setValue(passwd);
    }

    @Override
    public String getPassword() {
        return this.passwd.value();
    }

    @Override
    @Nullable
    public Boolean isDataPageScanEnabled() {
        return this.dataPageScanEnabled.value();
    }

    @Override
    public void setDataPageScanEnabled(@Nullable Boolean dataPageScanEnabled) {
        this.dataPageScanEnabled.setValue(dataPageScanEnabled);
    }

    @Override
    public boolean isPartitionAwareness() {
        return this.partitionAwareness.value();
    }

    @Override
    public void setPartitionAwareness(boolean partitionAwareness) {
        this.partitionAwareness.setValue(partitionAwareness);
    }

    @Override
    @Nullable
    public Integer getUpdateBatchSize() {
        return this.updateBatchSize.value();
    }

    @Override
    public void setUpdateBatchSize(@Nullable Integer updateBatchSize) throws SQLException {
        this.updateBatchSize.setValue(updateBatchSize);
    }

    @Override
    public int getPartitionAwarenessSqlCacheSize() {
        return this.partitionAwarenessSQLCacheSize.value();
    }

    @Override
    public void setPartitionAwarenessSqlCacheSize(int partitionAwarenessSqlCacheSize) throws SQLException {
        this.partitionAwarenessSQLCacheSize.setValue(partitionAwarenessSqlCacheSize);
    }

    @Override
    public int getPartitionAwarenessPartitionDistributionsCacheSize() {
        return this.partitionAwarenessPartDistributionsCacheSize.value();
    }

    @Override
    public void setPartitionAwarenessPartitionDistributionsCacheSize(int partitionAwarenessPartDistributionsCacheSize) throws SQLException {
        this.partitionAwarenessPartDistributionsCacheSize.setValue(partitionAwarenessPartDistributionsCacheSize);
    }

    @Override
    public Integer getQueryTimeout() {
        return this.qryTimeout.value();
    }

    @Override
    public void setQueryTimeout(@Nullable Integer timeout) throws SQLException {
        this.qryTimeout.setValue(timeout);
    }

    @Override
    public int getConnectionTimeout() {
        return this.connTimeout.value();
    }

    @Override
    public void setConnectionTimeout(@Nullable Integer timeout) throws SQLException {
        this.connTimeout.setValue(timeout);
    }

    @Override
    public String getUserAttributesFactory() {
        return this.userAttrsFactory.value();
    }

    @Override
    public void setUserAttributesFactory(String cls) {
        this.userAttrsFactory.setValue(cls);
    }

    @Override
    public String disabledFeatures() {
        return this.disabledFeatures.value();
    }

    @Override
    public void disabledFeatures(String features) {
        this.disabledFeatures.setValue(features);
    }

    @Override
    public boolean isKeepBinary() {
        return this.keepBinary.value();
    }

    @Override
    public void setKeepBinary(boolean keepBinary) {
        this.keepBinary.setValue(keepBinary);
    }

    @Override
    public String getQueryEngine() {
        return this.qryEngine.value();
    }

    @Override
    public void setQueryEngine(String qryEngine) {
        this.qryEngine.setValue(qryEngine);
    }

    public void init(String url, Properties props) throws SQLException {
        Properties props0 = (Properties)props.clone();
        if (!F.isEmpty(url)) {
            this.parseUrl(url, props0);
        }
        for (ConnectionProperty aPropsArray : this.propsArray) {
            aPropsArray.init(props0);
        }
        if (!F.isEmpty(props.getProperty("user"))) {
            this.setUsername(props.getProperty("user"));
            this.setPassword(props.getProperty("password"));
        }
    }

    private void parseUrl(String url, Properties props) throws SQLException {
        if (F.isEmpty(url)) {
            throw new SQLException("URL cannot be null or empty.");
        }
        if (!url.startsWith("jdbc:ignite:thin://")) {
            throw new SQLException("URL must start with \"jdbc:ignite:thin://\"");
        }
        String nakedUrl = url.substring("jdbc:ignite:thin://".length()).trim();
        this.parseUrl0(nakedUrl, props);
    }

    private void parseUrl0(String url, Properties props) throws SQLException {
        int semicolonPos = url.indexOf(";");
        int slashPos = url.indexOf("/");
        int queryPos = url.indexOf("?");
        boolean semicolonMode = semicolonPos == -1 && slashPos == -1 && queryPos == -1 ? true : (semicolonPos != -1 ? !(slashPos != -1 && semicolonPos >= slashPos || queryPos != -1 && semicolonPos >= queryPos) : false);
        if (semicolonMode) {
            this.parseUrlWithSemicolon(url, props);
        } else {
            this.parseUrlWithQuery(url, props);
        }
    }

    private void parseUrlWithSemicolon(String url, Properties props) throws SQLException {
        int pathPartEndPos = url.indexOf(59);
        if (pathPartEndPos == -1) {
            pathPartEndPos = url.length();
        }
        String pathPart = url.substring(0, pathPartEndPos);
        String paramPart = null;
        if (pathPartEndPos > 0 && pathPartEndPos < url.length()) {
            paramPart = url.substring(pathPartEndPos + 1, url.length());
        }
        this.parseEndpoints(pathPart);
        if (!F.isEmpty(paramPart)) {
            this.parseParameters(paramPart, props, ";");
        }
    }

    private void parseUrlWithQuery(String url, Properties props) throws SQLException {
        int pathPartEndPos = url.indexOf(63);
        if (pathPartEndPos == -1) {
            pathPartEndPos = url.length();
        }
        String pathPart = url.substring(0, pathPartEndPos);
        String paramPart = null;
        if (pathPartEndPos > 0 && pathPartEndPos < url.length()) {
            paramPart = url.substring(pathPartEndPos + 1, url.length());
        }
        String[] pathParts = pathPart.split("/");
        this.parseEndpoints(pathParts[0]);
        if (pathParts.length > 2) {
            throw new SQLException("Invalid URL format (only schema name is allowed in URL path parameter 'host:port[/schemaName]'): " + this.url, "08001");
        }
        this.setSchema(pathParts.length == 2 ? pathParts[1] : null);
        if (!F.isEmpty(paramPart)) {
            this.parseParameters(paramPart, props, "&");
        }
    }

    private void parseEndpoints(String endpointStr) throws SQLException {
        String[] endpoints = endpointStr.split(",");
        if (endpoints.length > 0) {
            this.addrs = new HostAndPortRange[endpoints.length];
        }
        for (int i = 0; i < endpoints.length; ++i) {
            try {
                this.addrs[i] = HostAndPortRange.parse(endpoints[i], 10800, 10800, "Invalid endpoint format (should be \"host[:portRangeFrom[..portRangeTo]]\")");
                continue;
            }
            catch (IgniteCheckedException e) {
                throw new SQLException(e.getMessage(), "08001", e);
            }
        }
        if (F.isEmpty(this.addrs) || F.isEmpty(this.addrs[0].host())) {
            throw new SQLException("Host name is empty", "08001");
        }
    }

    private void parseParameters(String paramStr, Properties props, String delimChar) throws SQLException {
        StringTokenizer st = new StringTokenizer(paramStr, delimChar);
        boolean insideBrace = false;
        String key = null;
        String val = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!insideBrace) {
                int eqSymPos = token.indexOf(61);
                if (eqSymPos < 0) {
                    throw new SQLException("Invalid parameter format (should be \"key1=val1" + delimChar + "key2=val2" + delimChar + "...\"): " + token);
                }
                if (eqSymPos == token.length()) {
                    throw new SQLException("Invalid parameter format (key and value cannot be empty): " + token);
                }
                key = token.substring(0, eqSymPos);
                val = token.substring(eqSymPos + 1, token.length());
                if (val.startsWith("{")) {
                    val = val.substring(1);
                    insideBrace = true;
                }
            } else {
                val = val + delimChar + token;
            }
            if (val.endsWith("}")) {
                insideBrace = false;
                val = val.substring(0, val.length() - 1);
            }
            if (val.contains("{") || val.contains("}")) {
                throw new SQLException("Braces cannot be escaped in the value. Please use the connection Properties for such values. [property=" + key + ']');
            }
            if (insideBrace) continue;
            if (key.isEmpty() || val.isEmpty()) {
                throw new SQLException("Invalid parameter format (key and value cannot be empty): " + token);
            }
            if (PROP_SCHEMA.equalsIgnoreCase(key)) {
                this.setSchema(val);
                continue;
            }
            props.setProperty(PROP_PREFIX + key, val);
        }
    }

    public DriverPropertyInfo[] getDriverPropertyInfo() {
        DriverPropertyInfo[] infos = new DriverPropertyInfo[this.propsArray.length];
        for (int i = 0; i < this.propsArray.length; ++i) {
            infos[i] = this.propsArray[i].getDriverPropertyInfo();
        }
        return infos;
    }

    public Properties storeToProperties() {
        Properties props = new Properties();
        for (ConnectionProperty prop : this.propsArray) {
            if (prop.valueObject() == null) continue;
            props.setProperty(PROP_PREFIX + prop.getName(), prop.valueObject());
        }
        return props;
    }

    private static class StringProperty
    extends ConnectionProperty {
        private static final long serialVersionUID = 0L;
        private String val;

        StringProperty(String name, String desc, String dfltVal, String[] choices, boolean required, PropertyValidator validator) {
            super(name, desc, dfltVal, choices, required, validator);
            this.val = dfltVal;
        }

        void setValue(String val) {
            this.val = val;
        }

        String value() {
            return this.val;
        }

        @Override
        void init(String str) throws SQLException {
            if (this.validator != null) {
                this.validator.validate(str);
            }
            this.val = str == null ? (String)this.dfltVal : str;
        }

        @Override
        String valueObject() {
            return this.val;
        }
    }

    private static class IntegerProperty
    extends NumberProperty {
        private static final long serialVersionUID = 0L;

        IntegerProperty(String name, String desc, Number dfltVal, boolean required, int min, int max) {
            super(name, desc, dfltVal, required, min, max);
        }

        @Override
        protected Number parse(String str) throws NumberFormatException {
            return Integer.parseInt(str);
        }

        Integer value() {
            return this.val != null ? Integer.valueOf(this.val.intValue()) : null;
        }
    }

    private static abstract class NumberProperty
    extends ConnectionProperty {
        private static final long serialVersionUID = 0L;
        protected Number val;
        private Number[] range;

        NumberProperty(String name, String desc, Number dfltVal, boolean required, Number min, Number max) {
            super(name, desc, dfltVal, null, required);
            this.val = dfltVal;
            this.range = new Number[]{min, max};
        }

        @Override
        void init(String str) throws SQLException {
            if (str == null) {
                this.val = this.dfltVal != null ? (Number)((Number)this.dfltVal) : (Number)null;
            } else {
                try {
                    this.setValue(this.parse(str));
                }
                catch (NumberFormatException e) {
                    throw new SQLException("Failed to parse int property [name=" + this.name + ", value=" + str + ']', "08001");
                }
            }
        }

        protected abstract Number parse(String var1) throws NumberFormatException;

        @Override
        String valueObject() {
            return this.val != null ? String.valueOf(this.val) : null;
        }

        void setValue(Number val) throws SQLException {
            if (this.range != null) {
                if (val.doubleValue() < this.range[0].doubleValue()) {
                    throw new SQLException("Property cannot be lower than " + this.range[0].toString() + " [name=" + this.name + ", value=" + val.toString() + ']', "08001");
                }
                if (val.doubleValue() > this.range[1].doubleValue()) {
                    throw new SQLException("Property cannot be upper than " + this.range[1].toString() + " [name=" + this.name + ", value=" + val.toString() + ']', "08001");
                }
            }
            this.val = val;
        }
    }

    private static class BooleanProperty
    extends ConnectionProperty {
        private static final long serialVersionUID = 0L;
        private static final String[] boolChoices = new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};
        private Boolean val;

        BooleanProperty(String name, String desc, @Nullable Boolean dfltVal, boolean required) {
            super(name, desc, dfltVal, boolChoices, required);
            this.val = dfltVal;
        }

        @Nullable
        Boolean value() {
            return this.val;
        }

        @Override
        void init(String str) throws SQLException {
            if (str == null) {
                this.val = (Boolean)this.dfltVal;
            } else if (Boolean.TRUE.toString().equalsIgnoreCase(str)) {
                this.val = true;
            } else if (Boolean.FALSE.toString().equalsIgnoreCase(str)) {
                this.val = false;
            } else {
                throw new SQLException("Failed to parse boolean property [name=" + this.name + ", value=" + str + ']', "08001");
            }
        }

        @Override
        String valueObject() {
            if (this.val == null) {
                return null;
            }
            return Boolean.toString(this.val);
        }

        void setValue(Boolean val) {
            this.val = val;
        }
    }

    private static abstract class ConnectionProperty
    implements Serializable {
        private static final long serialVersionUID = 0L;
        protected String name;
        protected String desc;
        protected Object dfltVal;
        protected String[] choices;
        protected boolean required;
        protected PropertyValidator validator;

        ConnectionProperty(String name, String desc, Object dfltVal, String[] choices, boolean required) {
            this.name = name;
            this.desc = desc;
            this.dfltVal = dfltVal;
            this.choices = choices;
            this.required = required;
        }

        ConnectionProperty(String name, String desc, Object dfltVal, String[] choices, boolean required, PropertyValidator validator) {
            this.name = name;
            this.desc = desc;
            this.dfltVal = dfltVal;
            this.choices = choices;
            this.required = required;
            this.validator = validator;
        }

        Object getDfltVal() {
            return this.dfltVal;
        }

        String getName() {
            return this.name;
        }

        String[] choices() {
            return this.choices;
        }

        void init(Properties props) throws SQLException {
            String strVal = props.getProperty(ConnectionPropertiesImpl.PROP_PREFIX + this.name);
            if (this.required && strVal == null) {
                throw new SQLException("Property '" + this.name + "' is required but not defined", "08001");
            }
            if (this.validator != null) {
                this.validator.validate(strVal);
            }
            this.checkChoices(strVal);
            props.remove(this.name);
            this.init(strVal);
        }

        protected void checkChoices(String strVal) throws SQLException {
            if (strVal == null) {
                return;
            }
            if (this.choices != null) {
                for (String ch : this.choices) {
                    if (!ch.equalsIgnoreCase(strVal)) continue;
                    return;
                }
                throw new SQLException("Invalid property value. [name=" + this.name + ", val=" + strVal + ", choices=" + Arrays.toString(this.choices) + ']', "08001");
            }
        }

        abstract void init(String var1) throws SQLException;

        abstract String valueObject();

        DriverPropertyInfo getDriverPropertyInfo() {
            DriverPropertyInfo dpi = new DriverPropertyInfo(ConnectionPropertiesImpl.PROP_PREFIX + this.name, this.valueObject());
            dpi.choices = this.choices();
            dpi.required = this.required;
            dpi.description = this.desc;
            return dpi;
        }
    }

    private static interface PropertyValidator
    extends Serializable {
        public void validate(String var1) throws SQLException;
    }
}

