/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.ContinuousQuery;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.ClientDisconnectListener;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientFeatureNotSupportedByServerException;
import org.apache.ignite.client.IgniteClientFuture;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.cache.query.InIndexQueryCriterion;
import org.apache.ignite.internal.cache.query.RangeIndexQueryCriterion;
import org.apache.ignite.internal.client.thin.ClientBinaryMarshaller;
import org.apache.ignite.internal.client.thin.ClientCacheEntryListenerHandler;
import org.apache.ignite.internal.client.thin.ClientCacheEntryListenersRegistry;
import org.apache.ignite.internal.client.thin.ClientContinuousQueryCursor;
import org.apache.ignite.internal.client.thin.ClientFieldsQueryCursor;
import org.apache.ignite.internal.client.thin.ClientFieldsQueryPager;
import org.apache.ignite.internal.client.thin.ClientJCacheAdapter;
import org.apache.ignite.internal.client.thin.ClientJCacheEntryListenerAdapter;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientProtocolError;
import org.apache.ignite.internal.client.thin.ClientQueryCursor;
import org.apache.ignite.internal.client.thin.ClientQueryPager;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.IgniteClientFutureImpl;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.ProtocolBitmaskFeature;
import org.apache.ignite.internal.client.thin.ProtocolContext;
import org.apache.ignite.internal.client.thin.ProtocolVersionFeature;
import org.apache.ignite.internal.client.thin.ReliableChannel;
import org.apache.ignite.internal.client.thin.TcpClientTransactions;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.platform.cache.expiry.PlatformExpiryPolicy;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class TcpClientCache<K, V>
implements ClientCache<K, V> {
    private static final byte KEEP_BINARY_FLAG_MASK = 1;
    private static final byte TRANSACTIONAL_FLAG_MASK = 2;
    private static final byte WITH_EXPIRY_POLICY_FLAG_MASK = 4;
    static final byte JAVA_PLATFORM = 1;
    private final int cacheId;
    private final ReliableChannel ch;
    private final String name;
    private final ClientBinaryMarshaller marsh;
    private final TcpClientTransactions transactions;
    private final ClientUtils serDes;
    private final boolean keepBinary;
    private final ExpiryPolicy expiryPlc;
    private final ClientCacheEntryListenersRegistry lsnrsRegistry;
    private final Cache<K, V> jCacheAdapter;

    TcpClientCache(String name, ReliableChannel ch, ClientBinaryMarshaller marsh, TcpClientTransactions transactions, ClientCacheEntryListenersRegistry lsnrsRegistry) {
        this(name, ch, marsh, transactions, lsnrsRegistry, false, null);
    }

    TcpClientCache(String name, ReliableChannel ch, ClientBinaryMarshaller marsh, TcpClientTransactions transactions, ClientCacheEntryListenersRegistry lsnrsRegistry, boolean keepBinary, ExpiryPolicy expiryPlc) {
        this.name = name;
        this.cacheId = ClientUtils.cacheId(name);
        this.ch = ch;
        this.marsh = marsh;
        this.transactions = transactions;
        this.lsnrsRegistry = lsnrsRegistry;
        this.serDes = new ClientUtils(marsh);
        this.keepBinary = keepBinary;
        this.expiryPlc = expiryPlc;
        this.jCacheAdapter = new ClientJCacheAdapter(this);
        this.ch.registerCacheIfCustomAffinity(this.name);
    }

    @Override
    public V get(K key) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return (V)this.cacheSingleKeyOperation(key, ClientOperation.CACHE_GET, null, this::readObject);
    }

    @Override
    public IgniteClientFuture<V> getAsync(K key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.cacheSingleKeyOperationAsync(key, ClientOperation.CACHE_GET, null, this::readObject);
    }

    @Override
    public void put(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        this.cacheSingleKeyOperation(key, ClientOperation.CACHE_PUT, req -> this.writeObject((PayloadOutputChannel)req, val), null);
    }

    @Override
    public IgniteClientFuture<Void> putAsync(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        return this.cacheSingleKeyOperationAsync(key, ClientOperation.CACHE_PUT, req -> this.writeObject((PayloadOutputChannel)req, val), null);
    }

    @Override
    public boolean containsKey(K key) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.cacheSingleKeyOperation(key, ClientOperation.CACHE_CONTAINS_KEY, null, res -> res.in().readBoolean());
    }

    @Override
    public IgniteClientFuture<Boolean> containsKeyAsync(K key) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.cacheSingleKeyOperationAsync(key, ClientOperation.CACHE_CONTAINS_KEY, null, res -> res.in().readBoolean());
    }

    @Override
    public boolean containsKeys(Set<? extends K> keys) throws ClientException {
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        if (keys.isEmpty()) {
            return true;
        }
        TcpClientTransactions.TcpClientTransaction tx = this.transactions.tx();
        return this.txAwareService(null, tx, ClientOperation.CACHE_CONTAINS_KEYS, req -> this.writeKeys((Set<? extends K>)keys, (PayloadOutputChannel)req, tx), res -> res.in().readBoolean());
    }

    @Override
    public IgniteClientFuture<Boolean> containsKeysAsync(Set<? extends K> keys) throws ClientException {
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        if (keys.isEmpty()) {
            return IgniteClientFutureImpl.completedFuture(true);
        }
        TcpClientTransactions.TcpClientTransaction tx = this.transactions.tx();
        return this.txAwareServiceAsync(null, tx, ClientOperation.CACHE_CONTAINS_KEYS, req -> this.writeKeys((Set<? extends K>)keys, (PayloadOutputChannel)req, tx), res -> res.in().readBoolean());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ClientCacheConfiguration getConfiguration() throws ClientException {
        return this.ch.service(ClientOperation.CACHE_GET_CONFIGURATION, this::writeCacheInfo, this::getClientCacheConfiguration);
    }

    @Override
    public IgniteClientFuture<ClientCacheConfiguration> getConfigurationAsync() throws ClientException {
        return this.ch.serviceAsync(ClientOperation.CACHE_GET_CONFIGURATION, this::writeCacheInfo, this::getClientCacheConfiguration);
    }

    @Override
    public int size(CachePeekMode ... peekModes) throws ClientException {
        return this.ch.service(ClientOperation.CACHE_GET_SIZE, req -> {
            this.writeCacheInfo((PayloadOutputChannel)req);
            ClientUtils.collection(peekModes, req.out(), (out, m) -> out.writeByte((byte)m.ordinal()));
        }, res -> (int)res.in().readLong());
    }

    @Override
    public IgniteClientFuture<Integer> sizeAsync(CachePeekMode ... peekModes) throws ClientException {
        return this.ch.serviceAsync(ClientOperation.CACHE_GET_SIZE, req -> {
            this.writeCacheInfo((PayloadOutputChannel)req);
            ClientUtils.collection(peekModes, req.out(), (out, m) -> out.writeByte((byte)m.ordinal()));
        }, res -> (int)res.in().readLong());
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) throws ClientException {
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        if (keys.isEmpty()) {
            return new HashMap();
        }
        TcpClientTransactions.TcpClientTransaction tx = this.transactions.tx();
        return this.txAwareService(null, tx, ClientOperation.CACHE_GET_ALL, req -> this.writeKeys((Set<? extends K>)keys, (PayloadOutputChannel)req, tx), this::readEntries);
    }

    @Override
    public IgniteClientFuture<Map<K, V>> getAllAsync(Set<? extends K> keys) throws ClientException {
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        if (keys.isEmpty()) {
            return IgniteClientFutureImpl.completedFuture(new HashMap());
        }
        TcpClientTransactions.TcpClientTransaction tx = this.transactions.tx();
        return this.txAwareServiceAsync(null, tx, ClientOperation.CACHE_GET_ALL, req -> this.writeKeys((Set<? extends K>)keys, (PayloadOutputChannel)req, tx), this::readEntries);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) throws ClientException {
        if (map == null) {
            throw new NullPointerException("map");
        }
        if (map.isEmpty()) {
            return;
        }
        TcpClientTransactions.TcpClientTransaction tx = this.transactions.tx();
        this.txAwareService(null, tx, ClientOperation.CACHE_PUT_ALL, req -> this.writeEntries((Map<? extends K, ? extends V>)map, (PayloadOutputChannel)req, tx), null);
    }

    @Override
    public IgniteClientFuture<Void> putAllAsync(Map<? extends K, ? extends V> map) throws ClientException {
        if (map == null) {
            throw new NullPointerException("map");
        }
        if (map.isEmpty()) {
            return IgniteClientFutureImpl.completedFuture(null);
        }
        TcpClientTransactions.TcpClientTransaction tx = this.transactions.tx();
        return this.txAwareServiceAsync(null, tx, ClientOperation.CACHE_PUT_ALL, req -> this.writeEntries((Map<? extends K, ? extends V>)map, (PayloadOutputChannel)req, tx), null);
    }

    @Override
    public boolean replace(K key, V oldVal, V newVal) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (oldVal == null) {
            throw new NullPointerException("oldVal");
        }
        if (newVal == null) {
            throw new NullPointerException("newVal");
        }
        return this.cacheSingleKeyOperation(key, ClientOperation.CACHE_REPLACE_IF_EQUALS, req -> {
            this.writeObject((PayloadOutputChannel)req, oldVal);
            this.writeObject((PayloadOutputChannel)req, newVal);
        }, res -> res.in().readBoolean());
    }

    @Override
    public IgniteClientFuture<Boolean> replaceAsync(K key, V oldVal, V newVal) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (oldVal == null) {
            throw new NullPointerException("oldVal");
        }
        if (newVal == null) {
            throw new NullPointerException("newVal");
        }
        return this.cacheSingleKeyOperationAsync(key, ClientOperation.CACHE_REPLACE_IF_EQUALS, req -> {
            this.writeObject((PayloadOutputChannel)req, oldVal);
            this.writeObject((PayloadOutputChannel)req, newVal);
        }, res -> res.in().readBoolean());
    }

    @Override
    public boolean replace(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        return this.cacheSingleKeyOperation(key, ClientOperation.CACHE_REPLACE, req -> this.writeObject((PayloadOutputChannel)req, val), res -> res.in().readBoolean());
    }

    @Override
    public IgniteClientFuture<Boolean> replaceAsync(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        return this.cacheSingleKeyOperationAsync(key, ClientOperation.CACHE_REPLACE, req -> this.writeObject((PayloadOutputChannel)req, val), res -> res.in().readBoolean());
    }

    @Override
    public boolean remove(K key) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.cacheSingleKeyOperation(key, ClientOperation.CACHE_REMOVE_KEY, null, res -> res.in().readBoolean());
    }

    @Override
    public IgniteClientFuture<Boolean> removeAsync(K key) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.cacheSingleKeyOperationAsync(key, ClientOperation.CACHE_REMOVE_KEY, null, res -> res.in().readBoolean());
    }

    @Override
    public boolean remove(K key, V oldVal) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (oldVal == null) {
            throw new NullPointerException("oldVal");
        }
        return this.cacheSingleKeyOperation(key, ClientOperation.CACHE_REMOVE_IF_EQUALS, req -> this.writeObject((PayloadOutputChannel)req, oldVal), res -> res.in().readBoolean());
    }

    @Override
    public IgniteClientFuture<Boolean> removeAsync(K key, V oldVal) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (oldVal == null) {
            throw new NullPointerException("oldVal");
        }
        return this.cacheSingleKeyOperationAsync(key, ClientOperation.CACHE_REMOVE_IF_EQUALS, req -> this.writeObject((PayloadOutputChannel)req, oldVal), res -> res.in().readBoolean());
    }

    @Override
    public void removeAll(Set<? extends K> keys) throws ClientException {
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        if (keys.isEmpty()) {
            return;
        }
        TcpClientTransactions.TcpClientTransaction tx = this.transactions.tx();
        this.txAwareService(null, tx, ClientOperation.CACHE_REMOVE_KEYS, req -> this.writeKeys((Set<? extends K>)keys, (PayloadOutputChannel)req, tx), null);
    }

    @Override
    public IgniteClientFuture<Void> removeAllAsync(Set<? extends K> keys) throws ClientException {
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        if (keys.isEmpty()) {
            return IgniteClientFutureImpl.completedFuture(null);
        }
        TcpClientTransactions.TcpClientTransaction tx = this.transactions.tx();
        return this.txAwareServiceAsync(null, tx, ClientOperation.CACHE_REMOVE_KEYS, req -> this.writeKeys((Set<? extends K>)keys, (PayloadOutputChannel)req, tx), null);
    }

    @Override
    public void removeAll() throws ClientException {
        this.ch.request(ClientOperation.CACHE_REMOVE_ALL, this::writeCacheInfo);
    }

    @Override
    public IgniteClientFuture<Void> removeAllAsync() throws ClientException {
        return this.ch.requestAsync(ClientOperation.CACHE_REMOVE_ALL, this::writeCacheInfo);
    }

    @Override
    public V getAndPut(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        return (V)this.cacheSingleKeyOperation(key, ClientOperation.CACHE_GET_AND_PUT, req -> this.writeObject((PayloadOutputChannel)req, val), this::readObject);
    }

    @Override
    public IgniteClientFuture<V> getAndPutAsync(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        return this.cacheSingleKeyOperationAsync(key, ClientOperation.CACHE_GET_AND_PUT, req -> this.writeObject((PayloadOutputChannel)req, val), this::readObject);
    }

    @Override
    public V getAndRemove(K key) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return (V)this.cacheSingleKeyOperation(key, ClientOperation.CACHE_GET_AND_REMOVE, null, this::readObject);
    }

    @Override
    public IgniteClientFuture<V> getAndRemoveAsync(K key) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.cacheSingleKeyOperationAsync(key, ClientOperation.CACHE_GET_AND_REMOVE, null, this::readObject);
    }

    @Override
    public V getAndReplace(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        return (V)this.cacheSingleKeyOperation(key, ClientOperation.CACHE_GET_AND_REPLACE, req -> this.writeObject((PayloadOutputChannel)req, val), this::readObject);
    }

    @Override
    public IgniteClientFuture<V> getAndReplaceAsync(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        return this.cacheSingleKeyOperationAsync(key, ClientOperation.CACHE_GET_AND_REPLACE, req -> this.writeObject((PayloadOutputChannel)req, val), this::readObject);
    }

    @Override
    public boolean putIfAbsent(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        return this.cacheSingleKeyOperation(key, ClientOperation.CACHE_PUT_IF_ABSENT, req -> this.writeObject((PayloadOutputChannel)req, val), res -> res.in().readBoolean());
    }

    @Override
    public IgniteClientFuture<Boolean> putIfAbsentAsync(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        return this.cacheSingleKeyOperationAsync(key, ClientOperation.CACHE_PUT_IF_ABSENT, req -> this.writeObject((PayloadOutputChannel)req, val), res -> res.in().readBoolean());
    }

    @Override
    public V getAndPutIfAbsent(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        return (V)this.cacheSingleKeyOperation(key, ClientOperation.CACHE_GET_AND_PUT_IF_ABSENT, req -> this.writeObject((PayloadOutputChannel)req, val), this::readObject);
    }

    @Override
    public IgniteClientFuture<V> getAndPutIfAbsentAsync(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        return this.cacheSingleKeyOperationAsync(key, ClientOperation.CACHE_GET_AND_PUT_IF_ABSENT, req -> this.writeObject((PayloadOutputChannel)req, val), this::readObject);
    }

    @Override
    public void clear() throws ClientException {
        this.ch.request(ClientOperation.CACHE_CLEAR, this::writeCacheInfo);
    }

    @Override
    public IgniteClientFuture<Void> clearAsync() throws ClientException {
        return this.ch.requestAsync(ClientOperation.CACHE_CLEAR, this::writeCacheInfo);
    }

    @Override
    public void clear(K key) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.cacheSingleKeyOperation(key, ClientOperation.CACHE_CLEAR_KEY, null, null);
    }

    @Override
    public IgniteClientFuture<Void> clearAsync(K key) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.cacheSingleKeyOperationAsync(key, ClientOperation.CACHE_CLEAR_KEY, null, null);
    }

    @Override
    public void clearAll(Set<? extends K> keys) throws ClientException {
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        if (keys.isEmpty()) {
            return;
        }
        TcpClientTransactions.TcpClientTransaction tx = this.transactions.tx();
        this.txAwareService(null, tx, ClientOperation.CACHE_CLEAR_KEYS, req -> this.writeKeys((Set<? extends K>)keys, (PayloadOutputChannel)req, tx), null);
    }

    @Override
    public IgniteClientFuture<Void> clearAllAsync(Set<? extends K> keys) throws ClientException {
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        if (keys.isEmpty()) {
            return IgniteClientFutureImpl.completedFuture(null);
        }
        TcpClientTransactions.TcpClientTransaction tx = this.transactions.tx();
        return this.txAwareServiceAsync(null, tx, ClientOperation.CACHE_CLEAR_KEYS, req -> this.writeKeys((Set<? extends K>)keys, (PayloadOutputChannel)req, tx), null);
    }

    @Override
    public <K1, V1> ClientCache<K1, V1> withKeepBinary() {
        return this.keepBinary ? this : new TcpClientCache<K, V>(this.name, this.ch, this.marsh, this.transactions, this.lsnrsRegistry, true, this.expiryPlc);
    }

    @Override
    public <K1, V1> ClientCache<K1, V1> withExpirePolicy(ExpiryPolicy expirePlc) {
        return new TcpClientCache<K, V>(this.name, this.ch, this.marsh, this.transactions, this.lsnrsRegistry, this.keepBinary, expirePlc);
    }

    @Override
    public <R> QueryCursor<R> query(Query<R> qry) {
        QueryCursor<Object> res;
        if (qry == null) {
            throw new NullPointerException("qry");
        }
        if (qry instanceof ScanQuery) {
            res = this.scanQuery((ScanQuery)qry);
        } else if (qry instanceof SqlQuery) {
            res = this.sqlQuery((SqlQuery)qry);
        } else if (qry instanceof SqlFieldsQuery) {
            res = this.query((SqlFieldsQuery)qry);
        } else if (qry instanceof ContinuousQuery) {
            res = this.query((ContinuousQuery)qry, null);
        } else if (qry instanceof IndexQuery) {
            res = this.indexQuery((IndexQuery)qry);
        } else {
            throw new IllegalArgumentException(String.format("Query of type [%s] is not supported", qry.getClass().getSimpleName()));
        }
        return res;
    }

    @Override
    public FieldsQueryCursor<List<?>> query(SqlFieldsQuery qry) {
        if (qry == null) {
            throw new NullPointerException("qry");
        }
        Consumer<PayloadOutputChannel> qryWriter = payloadCh -> {
            this.writeCacheInfo((PayloadOutputChannel)payloadCh);
            this.serDes.write(qry, payloadCh.out());
        };
        return new ClientFieldsQueryCursor(new ClientFieldsQueryPager(this.ch, ClientOperation.QUERY_SQL_FIELDS, ClientOperation.QUERY_SQL_FIELDS_CURSOR_GET_PAGE, qryWriter, this.keepBinary, this.marsh));
    }

    @Override
    public <R> QueryCursor<R> query(ContinuousQuery<K, V> qry, ClientDisconnectListener disconnectLsnr) {
        A.ensure(!(qry.getInitialQuery() instanceof ContinuousQuery), "Initial query for continuous query can't be an instance of another continuous query");
        A.notNull(qry.getLocalListener(), "Local listener");
        A.ensure(!qry.isLocal(), "Local query is not supported by thin client");
        A.ensure(qry.isAutoUnsubscribe(), "AutoUnsubscribe flag is not supported by thin client");
        A.ensure(qry.getRemoteFilterFactory() == null || qry.getRemoteFilter() == null, "RemoteFilter and RemoteFilterFactory can't be used together");
        ClientCacheEntryListenerHandler<K, V> hnd = new ClientCacheEntryListenerHandler<K, V>(this.jCacheAdapter, this.ch, this.marsh, this.keepBinary);
        hnd.startListen(qry.getLocalListener(), disconnectLsnr, (Factory<CacheEntryEventFilter<K, V>>)(qry.getRemoteFilterFactory() != null ? qry.getRemoteFilterFactory() : (qry.getRemoteFilter() != null ? FactoryBuilder.factoryOf(qry.getRemoteFilter()) : null)), qry.getPageSize(), qry.getTimeInterval(), qry.isIncludeExpired());
        if (qry.getInitialQuery() != null) {
            try {
                QueryCursor cur = this.query(qry.getInitialQuery());
                return new ClientContinuousQueryCursor(cur, hnd);
            }
            catch (Exception e) {
                U.closeQuiet(hnd);
                throw e;
            }
        }
        return new ClientContinuousQueryCursor(null, hnd);
    }

    @Override
    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cfg) {
        this.registerCacheEntryListener(cfg, null);
    }

    @Override
    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cfg, ClientDisconnectListener disconnectLsnr) {
        A.ensure(!cfg.isSynchronous(), "Unsupported cfg.isSynchronous() flag value");
        A.notNull(cfg.getCacheEntryListenerFactory(), "cfg.getCacheEntryListenerFactory()");
        ClientCacheEntryListenerHandler hnd = new ClientCacheEntryListenerHandler(this.jCacheAdapter, this.ch, this.marsh, this.keepBinary);
        if (!this.lsnrsRegistry.registerCacheEntryListener(this.name, cfg, hnd)) {
            throw new IllegalStateException("Listener is already registered for configuration: " + cfg);
        }
        CacheEntryListener locLsnr = (CacheEntryListener)cfg.getCacheEntryListenerFactory().create();
        ClientDisconnectListener disconnectLsnr0 = e -> {
            if (disconnectLsnr != null) {
                disconnectLsnr.onDisconnected(e);
            }
            this.lsnrsRegistry.deregisterCacheEntryListener(this.name, cfg);
        };
        hnd.startListen(new ClientJCacheEntryListenerAdapter(locLsnr), disconnectLsnr0, cfg.getCacheEntryEventFilterFactory(), 1, 0L, locLsnr instanceof CacheEntryExpiredListener);
    }

    @Override
    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cfg) {
        ClientCacheEntryListenerHandler<?, ?> hnd = this.lsnrsRegistry.deregisterCacheEntryListener(this.name, cfg);
        U.closeQuiet(hnd);
    }

    public void putAllConflict(Map<? extends K, ? extends T3<? extends V, GridCacheVersion, Long>> drMap) throws ClientException {
        A.notNull(drMap, "drMap");
        this.ch.request(ClientOperation.CACHE_PUT_ALL_CONFLICT, req -> this.writePutAllConflict(drMap, (PayloadOutputChannel)req));
    }

    public IgniteClientFuture<Void> putAllConflictAsync(Map<? extends K, T3<? extends V, GridCacheVersion, Long>> drMap) throws ClientException {
        A.notNull(drMap, "drMap");
        return this.ch.requestAsync(ClientOperation.CACHE_PUT_ALL_CONFLICT, req -> this.writePutAllConflict((Map<? extends K, ? extends T3<? extends V, GridCacheVersion, Long>>)drMap, (PayloadOutputChannel)req));
    }

    public void removeAllConflict(Map<? extends K, GridCacheVersion> drMap) throws ClientException {
        A.notNull(drMap, "drMap");
        this.ch.request(ClientOperation.CACHE_REMOVE_ALL_CONFLICT, req -> this.writeRemoveAllConflict(drMap, (PayloadOutputChannel)req));
    }

    public IgniteClientFuture<Void> removeAllConflictAsync(Map<? extends K, GridCacheVersion> drMap) throws ClientException {
        A.notNull(drMap, "drMap");
        return this.ch.requestAsync(ClientOperation.CACHE_REMOVE_ALL_CONFLICT, req -> this.writeRemoveAllConflict(drMap, (PayloadOutputChannel)req));
    }

    private QueryCursor<Cache.Entry<K, V>> scanQuery(ScanQuery<K, V> qry) {
        Consumer<PayloadOutputChannel> qryWriter = payloadCh -> {
            this.writeCacheInfo((PayloadOutputChannel)payloadCh);
            BinaryOutputStream out = payloadCh.out();
            if (qry.getFilter() == null) {
                out.writeByte((byte)101);
            } else {
                this.serDes.writeObject(out, qry.getFilter());
                out.writeByte((byte)1);
            }
            out.writeInt(qry.getPageSize());
            out.writeInt(qry.getPartition() == null ? -1 : qry.getPartition());
            out.writeBoolean(qry.isLocal());
        };
        return new ClientQueryCursor<Cache.Entry<K, V>>(new ClientQueryPager(this.ch, ClientOperation.QUERY_SCAN, ClientOperation.QUERY_SCAN_CURSOR_GET_PAGE, qryWriter, this.keepBinary, this.marsh, this.cacheId, qry.getPartition() == null ? -1 : qry.getPartition()));
    }

    private QueryCursor<Cache.Entry<K, V>> indexQuery(IndexQuery<K, V> qry) {
        Consumer<PayloadOutputChannel> qryWriter = payloadCh -> {
            BinaryOutputStream out;
            block23: {
                if (!payloadCh.clientChannel().protocolCtx().isFeatureSupported(ProtocolBitmaskFeature.INDEX_QUERY)) {
                    throw new ClientFeatureNotSupportedByServerException(ProtocolBitmaskFeature.INDEX_QUERY);
                }
                this.writeCacheInfo((PayloadOutputChannel)payloadCh);
                out = payloadCh.out();
                try (BinaryWriterExImpl w = new BinaryWriterExImpl(this.marsh.context(), out, null, null);){
                    w.writeInt(qry.getPageSize());
                    w.writeBoolean(qry.isLocal());
                    w.writeInt(qry.getPartition() == null ? -1 : qry.getPartition());
                    if (!payloadCh.clientChannel().protocolCtx().isFeatureSupported(ProtocolBitmaskFeature.INDEX_QUERY_LIMIT)) {
                        if (qry.getLimit() > 0) {
                            throw new ClientFeatureNotSupportedByServerException(ProtocolBitmaskFeature.INDEX_QUERY_LIMIT);
                        }
                    } else {
                        w.writeInt(qry.getLimit());
                    }
                    w.writeString(qry.getValueType());
                    w.writeString(qry.getIndexName());
                    if (qry.getCriteria() != null) {
                        out.writeByte((byte)1);
                        out.writeInt(qry.getCriteria().size());
                        for (IndexQueryCriterion c : qry.getCriteria()) {
                            if (c instanceof RangeIndexQueryCriterion) {
                                out.writeByte((byte)0);
                                RangeIndexQueryCriterion range = (RangeIndexQueryCriterion)c;
                                w.writeString(range.field());
                                w.writeBoolean(range.lowerIncl());
                                w.writeBoolean(range.upperIncl());
                                w.writeBoolean(range.lowerNull());
                                w.writeBoolean(range.upperNull());
                                this.serDes.writeObject(out, range.lower());
                                this.serDes.writeObject(out, range.upper());
                                continue;
                            }
                            if (c instanceof InIndexQueryCriterion) {
                                out.writeByte((byte)1);
                                InIndexQueryCriterion in = (InIndexQueryCriterion)c;
                                w.writeString(in.field());
                                w.writeInt(in.values().size());
                                for (Object v : in.values()) {
                                    this.serDes.writeObject(out, v);
                                }
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("Unknown IndexQuery criterion type [%s]", c.getClass().getSimpleName()));
                        }
                        break block23;
                    }
                    out.writeByte((byte)101);
                }
            }
            if (qry.getFilter() == null) {
                out.writeByte((byte)101);
            } else {
                this.serDes.writeObject(out, qry.getFilter());
                out.writeByte((byte)1);
            }
        };
        return new ClientQueryCursor<Cache.Entry<K, V>>(new ClientQueryPager(this.ch, ClientOperation.QUERY_INDEX, ClientOperation.QUERY_INDEX_CURSOR_GET_PAGE, qryWriter, this.keepBinary, this.marsh, this.cacheId, qry.getPartition() == null ? -1 : qry.getPartition()));
    }

    private QueryCursor<Cache.Entry<K, V>> sqlQuery(SqlQuery qry) {
        Consumer<PayloadOutputChannel> qryWriter = payloadCh -> {
            this.writeCacheInfo((PayloadOutputChannel)payloadCh);
            BinaryOutputStream out = payloadCh.out();
            this.serDes.writeObject(out, qry.getType());
            this.serDes.writeObject(out, qry.getSql());
            ClientUtils.collection(qry.getArgs(), out, this.serDes::writeObject);
            out.writeBoolean(qry.isDistributedJoins());
            out.writeBoolean(qry.isLocal());
            out.writeBoolean(qry.isReplicatedOnly());
            out.writeInt(qry.getPageSize());
            out.writeLong(qry.getTimeout());
        };
        return new ClientQueryCursor<Cache.Entry<K, V>>(new ClientQueryPager(this.ch, ClientOperation.QUERY_SQL, ClientOperation.QUERY_SQL_CURSOR_GET_PAGE, qryWriter, this.keepBinary, this.marsh));
    }

    private <T> T txAwareService(@Nullable K affKey, TcpClientTransactions.TcpClientTransaction tx, ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader) {
        if (tx != null) {
            try {
                return tx.clientChannel().service(op, payloadWriter, payloadReader);
            }
            catch (ClientConnectionException e) {
                throw new ClientException("Transaction context has been lost due to connection errors. Cache operations are prohibited until current transaction closed.", e);
            }
        }
        if (affKey != null) {
            return this.ch.affinityService(this.cacheId, affKey, op, payloadWriter, payloadReader);
        }
        return this.ch.service(op, payloadWriter, payloadReader);
    }

    private <T> IgniteClientFuture<T> txAwareServiceAsync(@Nullable K affKey, TcpClientTransactions.TcpClientTransaction tx, ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader) {
        if (tx != null) {
            CompletableFuture fut = new CompletableFuture();
            tx.clientChannel().serviceAsync(op, payloadWriter, payloadReader).whenComplete((res, err) -> {
                if (err instanceof ClientConnectionException) {
                    fut.completeExceptionally(new ClientException("Transaction context has been lost due to connection errors. Cache operations are prohibited until current transaction closed.", (Throwable)err));
                } else if (err != null) {
                    fut.completeExceptionally((Throwable)err);
                } else {
                    fut.complete(res);
                }
            });
            return new IgniteClientFutureImpl(fut);
        }
        if (affKey != null) {
            return this.ch.affinityServiceAsync(this.cacheId, affKey, op, payloadWriter, payloadReader);
        }
        return this.ch.serviceAsync(op, payloadWriter, payloadReader);
    }

    private <T> T cacheSingleKeyOperation(K key, ClientOperation op, Consumer<PayloadOutputChannel> additionalPayloadWriter, Function<PayloadInputChannel, T> payloadReader) throws ClientException {
        TcpClientTransactions.TcpClientTransaction tx = this.transactions.tx();
        Consumer<PayloadOutputChannel> payloadWriter = req -> {
            this.writeCacheInfo((PayloadOutputChannel)req, tx);
            this.writeObject((PayloadOutputChannel)req, key);
            if (additionalPayloadWriter != null) {
                additionalPayloadWriter.accept((PayloadOutputChannel)req);
            }
        };
        return this.txAwareService(key, tx, op, payloadWriter, payloadReader);
    }

    private <T> IgniteClientFuture<T> cacheSingleKeyOperationAsync(K key, ClientOperation op, Consumer<PayloadOutputChannel> additionalPayloadWriter, Function<PayloadInputChannel, T> payloadReader) throws ClientException {
        TcpClientTransactions.TcpClientTransaction tx = this.transactions.tx();
        Consumer<PayloadOutputChannel> payloadWriter = req -> {
            this.writeCacheInfo((PayloadOutputChannel)req, tx);
            this.writeObject((PayloadOutputChannel)req, key);
            if (additionalPayloadWriter != null) {
                additionalPayloadWriter.accept((PayloadOutputChannel)req);
            }
        };
        return this.txAwareServiceAsync(key, tx, op, payloadWriter, payloadReader);
    }

    private void writeCacheInfo(PayloadOutputChannel payloadCh) {
        this.writeCacheInfo(payloadCh, null);
    }

    private void writeCacheInfo(PayloadOutputChannel payloadCh, TcpClientTransactions.TcpClientTransaction tx) {
        byte flags;
        BinaryOutputStream out = payloadCh.out();
        out.writeInt(this.cacheId);
        byte by = flags = this.keepBinary ? (byte)1 : 0;
        if (this.expiryPlc != null) {
            ProtocolContext protocolCtx = payloadCh.clientChannel().protocolCtx();
            if (!protocolCtx.isFeatureSupported(ProtocolVersionFeature.EXPIRY_POLICY)) {
                throw new ClientProtocolError(String.format("Expire policies are not supported by the server version %s, required version %s", protocolCtx.version(), ProtocolVersionFeature.EXPIRY_POLICY.verIntroduced()));
            }
            flags = (byte)(flags | 4);
        }
        if (tx != null) {
            flags = (byte)(flags | 2);
        }
        out.writeByte(flags);
        if ((flags & 4) != 0) {
            out.writeLong(PlatformExpiryPolicy.convertDuration(this.expiryPlc.getExpiryForCreation()));
            out.writeLong(PlatformExpiryPolicy.convertDuration(this.expiryPlc.getExpiryForUpdate()));
            out.writeLong(PlatformExpiryPolicy.convertDuration(this.expiryPlc.getExpiryForAccess()));
        }
        if ((flags & 2) != 0) {
            out.writeInt(tx.txId());
        }
    }

    private <T> T readObject(BinaryInputStream in) {
        return this.serDes.readObject(in, this.keepBinary);
    }

    private <T> T readObject(PayloadInputChannel payloadCh) {
        return this.readObject(payloadCh.in());
    }

    private void writeObject(PayloadOutputChannel payloadCh, Object obj) {
        this.serDes.writeObject(payloadCh.out(), obj);
    }

    @Nullable
    private ClientCacheConfiguration getClientCacheConfiguration(PayloadInputChannel res) {
        try {
            return this.serDes.cacheConfiguration(res.in(), res.clientChannel().protocolCtx());
        }
        catch (IOException e) {
            return null;
        }
    }

    private void writeKeys(Set<? extends K> keys, PayloadOutputChannel req, TcpClientTransactions.TcpClientTransaction tx) {
        this.writeCacheInfo(req, tx);
        ClientUtils.collection(keys, req.out(), this.serDes::writeObject);
    }

    private Map<K, V> readEntries(PayloadInputChannel res) {
        BinaryInputStream in = res.in();
        int cnt = in.readInt();
        HashMap map = new HashMap();
        for (int i = 0; i < cnt; ++i) {
            map.put(this.readObject(in), this.readObject(in));
        }
        return map;
    }

    private void writeEntries(Map<? extends K, ? extends V> map, PayloadOutputChannel req, TcpClientTransactions.TcpClientTransaction tx) {
        this.writeCacheInfo(req, tx);
        ClientUtils.collection(map.entrySet(), req.out(), (out, e) -> {
            this.serDes.writeObject((BinaryOutputStream)out, e.getKey());
            this.serDes.writeObject((BinaryOutputStream)out, e.getValue());
        });
    }

    private void writePutAllConflict(Map<? extends K, ? extends T3<? extends V, GridCacheVersion, Long>> map, PayloadOutputChannel req) {
        this.checkDataReplicationSupported(req.clientChannel().protocolCtx());
        this.writeCacheInfo(req);
        ClientUtils.collection(map.entrySet(), req.out(), (out, e) -> {
            this.serDes.writeObject((BinaryOutputStream)out, e.getKey());
            this.serDes.writeObject((BinaryOutputStream)out, ((T3)e.getValue()).get1());
            this.serDes.writeObject((BinaryOutputStream)out, ((T3)e.getValue()).get2());
            out.writeLong((Long)((T3)e.getValue()).get3());
        });
    }

    private void writeRemoveAllConflict(Map<? extends K, GridCacheVersion> map, PayloadOutputChannel req) {
        this.checkDataReplicationSupported(req.clientChannel().protocolCtx());
        this.writeCacheInfo(req);
        ClientUtils.collection(map.entrySet(), req.out(), (out, e) -> {
            this.serDes.writeObject((BinaryOutputStream)out, e.getKey());
            this.serDes.writeObject((BinaryOutputStream)out, e.getValue());
        });
    }

    private void checkDataReplicationSupported(ProtocolContext protocolCtx) throws ClientFeatureNotSupportedByServerException {
        if (!protocolCtx.isFeatureSupported(ProtocolBitmaskFeature.DATA_REPLICATION_OPERATIONS)) {
            throw new ClientFeatureNotSupportedByServerException(ProtocolBitmaskFeature.DATA_REPLICATION_OPERATIONS);
        }
    }
}

