/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.client.ClientAddressFinder;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.ProtocolBitmaskFeature;
import org.apache.ignite.internal.util.HostAndPortRange;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.logger.NullLogger;
import org.jetbrains.annotations.Nullable;

public class ClientDiscoveryContext {
    private static final long UNKNOWN_TOP_VER = -1L;
    private final AtomicBoolean refreshIsInProgress = new AtomicBoolean();
    private final IgniteLogger log;
    @Nullable
    private final String[] addresses;
    @Nullable
    private final ClientAddressFinder addrFinder;
    private final boolean enabled;
    private volatile TopologyInfo topInfo;
    private volatile String[] prevHostAddrs;
    private volatile long prevTopVer = -1L;

    public ClientDiscoveryContext(ClientConfiguration clientCfg) {
        this.log = NullLogger.whenNull(clientCfg.getLogger());
        this.addresses = clientCfg.getAddresses();
        this.addrFinder = clientCfg.getAddressesFinder();
        this.enabled = clientCfg.isClusterDiscoveryEnabled();
        this.reset();
    }

    void reset() {
        this.topInfo = new TopologyInfo(-1L, Collections.emptyMap());
        this.prevTopVer = -1L;
        this.prevHostAddrs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean refresh(ClientChannel ch) {
        if (this.addrFinder != null || !this.enabled) {
            return false;
        }
        if (!ch.protocolCtx().isFeatureSupported(ProtocolBitmaskFeature.CLUSTER_GROUP_GET_NODES_ENDPOINTS)) {
            return false;
        }
        if (ch.serverTopologyVersion() != null && this.topInfo.topVer >= ch.serverTopologyVersion().topologyVersion()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Endpoints information is up to date, no update required");
            }
            return false;
        }
        if (this.refreshIsInProgress.compareAndSet(false, true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Updating nodes endpoints");
            }
            try {
                HashMap nodes = new HashMap(this.topInfo.nodes);
                TopologyInfo newTopInfo = ch.service(ClientOperation.CLUSTER_GROUP_GET_NODE_ENDPOINTS, req -> {
                    req.out().writeLong(this.topInfo.topVer);
                    req.out().writeLong(-1L);
                }, res -> {
                    try (BinaryReaderExImpl reader = ClientUtils.createBinaryReader(null, res.in());){
                        long topVer = reader.readLong();
                        int nodesAdded = reader.readInt();
                        for (int i = 0; i < nodesAdded; ++i) {
                            UUID nodeId = new UUID(reader.readLong(), reader.readLong());
                            int port = reader.readInt();
                            int addrsCnt = reader.readInt();
                            ArrayList<String> addrs = new ArrayList<String>();
                            for (int j = 0; j < addrsCnt; ++j) {
                                addrs.add(reader.readString());
                            }
                            nodes.put(nodeId, new NodeInfo(port, addrs));
                        }
                        int nodesRemoved = reader.readInt();
                        for (int i = 0; i < nodesRemoved; ++i) {
                            UUID nodeId = new UUID(reader.readLong(), reader.readLong());
                            nodes.remove(nodeId);
                        }
                        TopologyInfo topologyInfo = new TopologyInfo(topVer, nodes);
                        return topologyInfo;
                    }
                    catch (IOException e) {
                        assert (false) : "Unexpected exception: " + e;
                        return null;
                    }
                });
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Updated nodes endpoints [topVer=" + newTopInfo.topVer + ", nodesCnt=" + newTopInfo.nodes.size() + ']');
                }
                if (this.topInfo.topVer < newTopInfo.topVer) {
                    this.topInfo = newTopInfo;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.refreshIsInProgress.set(false);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Concurrent nodes endpoints update already in progress, skipping");
        }
        return false;
    }

    @Nullable
    Collection<List<InetSocketAddress>> getEndpoints() {
        Collection<List<InetSocketAddress>> endpoints = null;
        TopologyInfo topInfo = this.topInfo;
        if (this.addrFinder != null || topInfo.topVer == -1L) {
            Object[] hostAddrs;
            Object[] objectArray = hostAddrs = this.addrFinder == null ? this.addresses : this.addrFinder.getAddresses();
            if (F.isEmpty(hostAddrs)) {
                throw new ClientException("Empty addresses");
            }
            if (!Arrays.equals(hostAddrs, this.prevHostAddrs)) {
                endpoints = ClientDiscoveryContext.parsedAddresses((String[])hostAddrs);
                this.prevHostAddrs = hostAddrs;
            }
        } else if (this.prevTopVer != topInfo.topVer) {
            endpoints = topInfo.endpoints;
            this.prevTopVer = topInfo.topVer;
        }
        return endpoints;
    }

    private static Collection<List<InetSocketAddress>> parsedAddresses(String[] addrs) throws ClientException {
        if (F.isEmpty(addrs)) {
            throw new ClientException("Empty addresses");
        }
        ArrayList<HostAndPortRange> ranges = new ArrayList<HostAndPortRange>(addrs.length);
        for (String a : addrs) {
            try {
                ranges.add(HostAndPortRange.parse(a, 10800, 10900, "Failed to parse Ignite server address"));
            }
            catch (IgniteCheckedException e) {
                throw new ClientException(e);
            }
        }
        return ranges.stream().flatMap(r -> IntStream.rangeClosed(r.portFrom(), r.portTo()).boxed().map(p -> Collections.singletonList(InetSocketAddress.createUnresolved(r.host(), p)))).collect(Collectors.toList());
    }

    private static class NodeInfo {
        private final int port;
        private final List<String> addrs;

        private NodeInfo(int port, List<String> addrs) {
            this.port = port;
            this.addrs = addrs;
        }
    }

    private static class TopologyInfo {
        private final long topVer;
        private final Map<UUID, NodeInfo> nodes;
        private final Collection<List<InetSocketAddress>> endpoints;

        private TopologyInfo(long ver, Map<UUID, NodeInfo> nodes) {
            this.topVer = ver;
            this.nodes = nodes;
            this.endpoints = TopologyInfo.normalizeEndpoints(nodes.values());
        }

        private static Collection<List<InetSocketAddress>> normalizeEndpoints(Collection<NodeInfo> nodes) {
            ArrayList endpoints = new ArrayList(nodes.size());
            HashSet<InetSocketAddress> used = new HashSet<InetSocketAddress>();
            for (NodeInfo nodeInfo : nodes) {
                ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>(nodeInfo.addrs.size());
                for (String host : nodeInfo.addrs) {
                    InetSocketAddress addr = InetSocketAddress.createUnresolved(host, nodeInfo.port);
                    if (!used.add(addr)) continue;
                    addrs.add(addr);
                }
                if (addrs.isEmpty()) continue;
                endpoints.add(addrs);
            }
            return Collections.unmodifiableCollection(endpoints);
        }
    }
}

