/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteEvents;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.AsyncSupportAdapter;
import org.apache.ignite.internal.GridEventConsumeHandler;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.SecurityAwarePredicate;
import org.apache.ignite.internal.cluster.ClusterGroupAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class IgniteEventsImpl
extends AsyncSupportAdapter<IgniteEvents>
implements IgniteEvents,
Externalizable {
    private static final long serialVersionUID = 0L;
    private GridKernalContext ctx;
    private ClusterGroupAdapter prj;

    public IgniteEventsImpl() {
    }

    public IgniteEventsImpl(GridKernalContext ctx, ClusterGroupAdapter prj, boolean async) {
        super(async);
        this.ctx = ctx;
        this.prj = prj;
    }

    @Override
    public ClusterGroup clusterGroup() {
        return this.prj;
    }

    @Override
    public <T extends Event> List<T> remoteQuery(IgnitePredicate<T> p, long timeout, int ... types) {
        A.notNull(p, "p");
        this.guard();
        try {
            List<T> list = this.saveOrGet(this.ctx.event().remoteEventsAsync(IgniteEventsImpl.compoundPredicate(p, types), this.prj.nodes(), timeout));
            return list;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Event> IgniteFuture<List<T>> remoteQueryAsync(IgnitePredicate<T> p, long timeout, int ... types) throws IgniteException {
        this.guard();
        try {
            IgniteFutureImpl<List<T>> igniteFutureImpl = new IgniteFutureImpl<List<T>>(this.ctx.event().remoteEventsAsync(IgniteEventsImpl.compoundPredicate(p, types), this.prj.nodes(), timeout));
            return igniteFutureImpl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T extends Event> UUID remoteListen(@Nullable IgniteBiPredicate<UUID, T> locLsnr, @Nullable IgnitePredicate<T> rmtFilter, int ... types) {
        return this.remoteListen(1, 0L, true, locLsnr, rmtFilter, types);
    }

    @Override
    public <T extends Event> IgniteFuture<UUID> remoteListenAsync(@Nullable IgniteBiPredicate<UUID, T> locLsnr, @Nullable IgnitePredicate<T> rmtFilter, int ... types) throws IgniteException {
        return this.remoteListenAsync(1, 0L, true, locLsnr, rmtFilter, types);
    }

    @Override
    public <T extends Event> UUID remoteListen(int bufSize, long interval, boolean autoUnsubscribe, @Nullable IgniteBiPredicate<UUID, T> locLsnr, @Nullable IgnitePredicate<T> rmtFilter, int ... types) {
        A.ensure(bufSize > 0, "bufSize > 0");
        A.ensure(interval >= 0L, "interval >= 0");
        this.guard();
        try {
            GridEventConsumeHandler hnd = new GridEventConsumeHandler(locLsnr, this.securityAwareRemoteFilter(rmtFilter), types);
            UUID uUID = this.saveOrGet(this.ctx.continuous().startRoutine(hnd, false, bufSize, interval, autoUnsubscribe, this.prj.predicate()));
            return uUID;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T extends Event> IgniteFuture<UUID> remoteListenAsync(int bufSize, long interval, boolean autoUnsubscribe, @Nullable IgniteBiPredicate<UUID, T> locLsnr, @Nullable IgnitePredicate<T> rmtFilter, int ... types) throws IgniteException {
        A.ensure(bufSize > 0, "bufSize > 0");
        A.ensure(interval >= 0L, "interval >= 0");
        this.guard();
        try {
            GridEventConsumeHandler hnd = new GridEventConsumeHandler(locLsnr, this.securityAwareRemoteFilter(rmtFilter), types);
            IgniteFutureImpl<UUID> igniteFutureImpl = new IgniteFutureImpl<UUID>(this.ctx.continuous().startRoutine(hnd, false, bufSize, interval, autoUnsubscribe, this.prj.predicate()));
            return igniteFutureImpl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    private <T> IgnitePredicate<Event> securityAwareRemoteFilter(@Nullable IgnitePredicate<T> original) {
        if (original == null) {
            return null;
        }
        IgnitePredicate<Event> res = original;
        if (this.ctx.security().enabled()) {
            UUID subjId = this.ctx.security().securityContext().subject().id();
            return new SecurityAwarePredicate<Event>(subjId, res);
        }
        return res;
    }

    @Override
    public void stopRemoteListen(UUID opId) {
        A.notNull(opId, "consumeId");
        this.guard();
        try {
            this.saveOrGet(this.ctx.continuous().stopRoutine(opId));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public IgniteFuture<Void> stopRemoteListenAsync(UUID opId) throws IgniteException {
        A.notNull(opId, "consumeId");
        this.guard();
        try {
            IgniteFutureImpl<Void> igniteFutureImpl = new IgniteFutureImpl<Void>(this.ctx.continuous().stopRoutine(opId));
            return igniteFutureImpl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T extends Event> T waitForLocal(@Nullable IgnitePredicate<T> filter, int ... types) {
        this.guard();
        try {
            Event event = (Event)this.saveOrGet(this.ctx.event().waitForEvent(filter, types));
            return (T)event;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Event> IgniteFuture<T> waitForLocalAsync(@Nullable IgnitePredicate<T> filter, int ... types) throws IgniteException {
        this.guard();
        try {
            IgniteFutureImpl<T> igniteFutureImpl = new IgniteFutureImpl<T>(this.ctx.event().waitForEvent(filter, types));
            return igniteFutureImpl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T extends Event> Collection<T> localQuery(IgnitePredicate<T> p, int ... types) {
        A.notNull(p, "p");
        this.guard();
        try {
            Collection<T> collection = this.ctx.event().localEvents(IgniteEventsImpl.compoundPredicate(p, types));
            return collection;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void recordLocal(Event evt) {
        A.notNull(evt, "evt");
        if (evt.type() <= 1000) {
            throw new IllegalArgumentException("All types in range from 1 to 1000 are reserved for internal Ignite events [evtType=" + evt.type() + ", evt=" + evt + ']');
        }
        this.guard();
        try {
            this.ctx.event().record(evt);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void localListen(IgnitePredicate<? extends Event> lsnr, int[] types) {
        A.notNull(lsnr, "lsnr");
        A.notEmpty(types, "types");
        this.guard();
        try {
            this.ctx.event().addLocalEventListener(lsnr, types);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopLocalListen(IgnitePredicate<? extends Event> lsnr, int ... types) {
        A.notNull(lsnr, "lsnr");
        this.guard();
        try {
            boolean bl = this.ctx.event().removeLocalEventListener(lsnr, types);
            return bl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void enableLocal(int[] types) {
        A.notEmpty(types, "types");
        this.guard();
        try {
            this.ctx.event().enableEvents(types);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void disableLocal(int[] types) {
        A.notEmpty(types, "types");
        this.guard();
        try {
            this.ctx.event().disableEvents(types);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public int[] enabledEvents() {
        return this.ctx.event().enabledEvents();
    }

    @Override
    public boolean isEnabled(int type) {
        if (type < 0) {
            throw new IllegalArgumentException("Invalid event type: " + type);
        }
        return this.ctx.event().isUserRecordable(type);
    }

    private void guard() {
        this.ctx.gateway().readLock();
    }

    private void unguard() {
        this.ctx.gateway().readUnlock();
    }

    private static <T extends Event> IgnitePredicate<T> compoundPredicate(final IgnitePredicate<T> p, final int ... types) {
        return F.isEmpty(types) ? p : new IgnitePredicate<T>(){

            @Override
            public boolean apply(T t) {
                for (int type : types) {
                    if (type != t.type()) continue;
                    return p.apply(t);
                }
                return false;
            }
        };
    }

    @Override
    protected IgniteEvents createAsyncInstance() {
        return new IgniteEventsImpl(this.ctx, this.prj, true);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.prj);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.prj = (ClusterGroupAdapter)in.readObject();
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.prj.events();
    }
}

